/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.cozystudios.cozystudioscore.entity.ModEntities;
import net.cozystudios.cozystudioscore.entity.custom.FernlingEntity;
import net.cozystudios.cozystudioscore.entity.custom.MushlingEntity;
import net.cozystudios.cozystudioscore.entity.custom.MysticalElkEntity;
import net.cozystudios.cozystudioscore.item.ModItems;
import net.cozystudios.cozystudioscore.villager.ModVillagers;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3489;
import net.minecraft.class_3852;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ModRegistries {
    private static final int PRICE_EMERALDS = 1;
    private static final int OUT_COUNT = 2;
    private static final int MAX_USES = 6;
    private static final int VILLAGER_XP = 6;
    private static final float PRICE_MULT = 0.08f;
    private static final int NOVICE_COUNT = 3;
    private static final int APPRENTICE_COUNT = 3;
    private static final int JOURNEYMAN_COUNT = 2;
    private static final int EXPERT_COUNT = 2;
    private static final int MASTER_COUNT = 2;

    public static void registerModStuffs() {
        ModRegistries.registerAttributes();
        ModRegistries.registerCustomTrades();
    }

    private static void registerAttributes() {
        FabricDefaultAttributeRegistry.register(ModEntities.MUSHLING, (class_5132.class_5133)MushlingEntity.createMushlingAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.FERNLING, (class_5132.class_5133)FernlingEntity.createFernlingAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MYSTICAL_ELK, (class_5132.class_5133)MysticalElkEntity.createMysticalElkAttributes());
    }

    private static void registerCustomTrades() {
        ModRegistries.registerSaplingLevel(ModVillagers.ARBORIST, 1, 3);
        ModRegistries.registerSaplingLevel(ModVillagers.ARBORIST, 2, 3);
        ModRegistries.registerSaplingLevel(ModVillagers.ARBORIST, 3, 2);
        ModRegistries.registerSaplingLevel(ModVillagers.ARBORIST, 4, 2);
        ModRegistries.registerSaplingLevel(ModVillagers.ARBORIST, 5, 2);
        TradeOfferHelper.registerVillagerOffers((class_3852)ModVillagers.ARBORIST, (int)5, factories -> factories.add((entity, random) -> new class_1914(new class_1799((class_1935)class_1802.field_8687, 5), new class_1799((class_1935)ModItems.COZY_CRUMBS, 3), 8, 30, 0.05f)));
    }

    private static void registerSaplingLevel(class_3852 profession, int level, int countForLevel) {
        TradeOfferHelper.registerVillagerOffers((class_3852)profession, (int)level, factories -> {
            int i = 0;
            while (i < countForLevel) {
                int indexWithinLevel = i++;
                factories.add((entity, random) -> {
                    Optional optList = class_7923.field_41178.method_40266(class_3489.field_15528);
                    List<class_6880<class_1792>> entries = optList.map(l -> l.method_40239().toList()).orElse(List.of());
                    if (entries.isEmpty()) {
                        return null;
                    }
                    int baseOffset = ModRegistries.cumulativeOffsetForLevel(level);
                    class_1792 chosen = ModRegistries.pickStableUnique(entries, random, baseOffset + indexWithinLevel);
                    if (chosen == null) {
                        return null;
                    }
                    return new class_1914(new class_1799((class_1935)class_1802.field_8687, 1), new class_1799((class_1935)chosen, 2), 6, 6, 0.08f);
                });
            }
        });
    }

    private static int cumulativeOffsetForLevel(int level) {
        return switch (level) {
            case 2 -> 3;
            case 3 -> 6;
            case 4 -> 8;
            case 5 -> 10;
            default -> 0;
        };
    }

    private static class_1792 pickStableUnique(List<class_6880<class_1792>> entries, class_5819 random, int globalIndex) {
        int size = entries.size();
        if (size == 0 || globalIndex >= size) {
            return null;
        }
        ArrayList<Integer> order = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            order.add(i);
        }
        Random shuffleRandom = new Random(random.method_43055());
        Collections.shuffle(order, shuffleRandom);
        int pickedIdx = (Integer)order.get(globalIndex);
        return (class_1792)entries.get(pickedIdx).comp_349();
    }
}

