/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.cozystudios.cozystudioscore.config.ModConfig;
import net.cozystudios.cozystudioscore.network.ModNetworking;
import net.cozystudios.cozystudioscore.world.TranquilLanternState;
import net.cozystudios.cozystudioscore.world.TranquilLingerState;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1593;
import net.minecraft.class_1621;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TranquilLanternSpawnBlocker {
    private static final Map<class_3218, Set<class_2338>> ACTIVE_LANTERNS = new HashMap<class_3218, Set<class_2338>>();
    private static final Set<UUID> PHANTOM_DEATH_MEMORY = new HashSet<UUID>();
    private static final int LINGER_TICKS_THRESHOLD = 60;
    private static final int TICK_INTERVAL = 10;
    private static int tickTimer = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(TranquilLanternSpawnBlocker::tick);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            TranquilLanternSpawnBlocker.refreshAllLanterns(server);
            for (class_3222 p : server.method_3760().method_14571()) {
                TranquilLanternSpawnBlocker.syncLanternsToPlayer(p);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(TranquilLanternSpawnBlocker::refreshAllLanterns);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> TranquilLanternSpawnBlocker.syncLanternsToPlayer(handler.field_14140));
    }

    private static Map<UUID, Integer> getLingerMap(class_3218 world) {
        return TranquilLingerState.get((class_3218)world).lingerTicks;
    }

    private static void tick(MinecraftServer server) {
        if (++tickTimer < 10) {
            return;
        }
        tickTimer = 0;
        if (ACTIVE_LANTERNS.isEmpty()) {
            for (class_3218 w : server.method_3738()) {
                TranquilLanternSpawnBlocker.getLingerMap(w).clear();
                TranquilLingerState.get(w).method_80();
            }
            return;
        }
        int radius = ModConfig.get().tranquilLanternRadius;
        double radiusSq = radius * radius;
        for (class_3218 world : server.method_3738()) {
            Set<class_2338> lanterns = ACTIVE_LANTERNS.get(world);
            if (lanterns == null || lanterns.isEmpty()) continue;
            lanterns.removeIf(pos -> !world.method_22340(pos));
            if (lanterns.isEmpty()) continue;
            Map<UUID, Integer> linger = TranquilLanternSpawnBlocker.getLingerMap(world);
            for (class_2338 lanternPos : lanterns) {
                class_238 box = new class_238((double)(lanternPos.method_10263() - radius), (double)(lanternPos.method_10264() - radius), (double)(lanternPos.method_10260() - radius), (double)(lanternPos.method_10263() + radius), (double)(lanternPos.method_10264() + radius), (double)(lanternPos.method_10260() + radius));
                List mobs = world.method_8390(class_1308.class, box, mob -> mob != null && !mob.method_31481() && TranquilLanternSpawnBlocker.isHostileMob(mob));
                if (mobs.isEmpty()) continue;
                double cx = (double)lanternPos.method_10263() + 0.5;
                double cy = (double)lanternPos.method_10264() + 0.5;
                double cz = (double)lanternPos.method_10260() + 0.5;
                for (class_1308 mob2 : mobs) {
                    boolean insideRadius;
                    UUID id = mob2.method_5667();
                    double dx = mob2.method_23317() - cx;
                    double dy = mob2.method_23318() - cy;
                    double dz = mob2.method_23321() - cz;
                    double distSq2 = dx * dx + dy * dy + dz * dz;
                    if (mob2 instanceof class_1593) {
                        boolean insideCube;
                        class_1593 phantom = (class_1593)mob2;
                        boolean bl = insideCube = Math.abs(phantom.method_23317() - cx) <= (double)radius && Math.abs(phantom.method_23318() - cy) <= (double)radius && Math.abs(phantom.method_23321() - cz) <= (double)radius;
                        if (insideCube) {
                            PHANTOM_DEATH_MEMORY.add(id);
                        }
                    }
                    boolean bl = insideRadius = distSq2 <= radiusSq;
                    if (insideRadius) {
                        int current = linger.getOrDefault(id, 0) + 10;
                        if (current >= 60) {
                            mob2.method_5768();
                            linger.remove(id);
                            TranquilLingerState.get(world).method_80();
                            continue;
                        }
                        linger.put(id, current);
                        TranquilLingerState.get(world).method_80();
                        if (!(distSq2 > 0.001)) continue;
                        double dist = Math.sqrt(distSq2);
                        double push = 0.15;
                        mob2.method_5762(dx / dist * push, 0.12, dz / dist * push);
                        mob2.field_6037 = true;
                        continue;
                    }
                    if (linger.remove(id) == null) continue;
                    TranquilLingerState.get(world).method_80();
                }
            }
            Iterator<UUID> it = PHANTOM_DEATH_MEMORY.iterator();
            while (it.hasNext()) {
                class_1593 phantom;
                UUID id = it.next();
                class_1297 e = world.method_14190(id);
                if (e instanceof class_1593 && (phantom = (class_1593)e).method_5805()) {
                    phantom.method_5768();
                }
                it.remove();
            }
        }
    }

    private static boolean isHostileMob(class_1308 mob) {
        return mob instanceof class_1588 || mob instanceof class_1621 || mob instanceof class_1589 || mob instanceof class_1593;
    }

    private static TranquilLanternState getState(class_3218 world) {
        return (TranquilLanternState)world.method_17983().method_17924(TranquilLanternState::readNbt, TranquilLanternState::create, "tranquil_lanterns");
    }

    public static void addLantern(class_3218 world, class_2338 pos) {
        ACTIVE_LANTERNS.computeIfAbsent(world, w -> new HashSet()).add(pos.method_10062());
        TranquilLanternState state = TranquilLanternSpawnBlocker.getState(world);
        state.lanterns.add(pos.method_10062());
        state.method_80();
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_2960)ModNetworking.TRANQUIL_LANTERN_ADD, (class_2540)buf);
        }
    }

    public static void removeLantern(class_3218 world, class_2338 pos) {
        Set<class_2338> set = ACTIVE_LANTERNS.get(world);
        if (set != null) {
            set.remove(pos.method_10062());
        }
        TranquilLanternState state = TranquilLanternSpawnBlocker.getState(world);
        state.lanterns.remove(pos.method_10062());
        state.method_80();
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_2960)ModNetworking.TRANQUIL_LANTERN_REMOVE, (class_2540)buf);
        }
    }

    public static void refreshAllLanterns(MinecraftServer server) {
        ACTIVE_LANTERNS.clear();
        for (class_3218 world : server.method_3738()) {
            TranquilLanternState state = TranquilLanternSpawnBlocker.getState(world);
            if (state.lanterns.isEmpty()) continue;
            ACTIVE_LANTERNS.put(world, new HashSet<class_2338>(state.lanterns));
        }
        for (class_3222 p : server.method_3760().method_14571()) {
            TranquilLanternSpawnBlocker.syncLanternsToPlayer(p);
        }
    }

    private static void syncLanternsToPlayer(class_3222 player) {
        Set lanterns = ACTIVE_LANTERNS.getOrDefault(player.method_51469(), Collections.emptySet());
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(lanterns.size());
        for (class_2338 pos : lanterns) {
            buf.method_10807(pos);
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModNetworking.TRANQUIL_LANTERN_SYNC, (class_2540)buf);
    }
}

