/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.entity.custom;

import net.cozystudios.cozystudioscore.entity.ModEntities;
import net.cozystudios.cozystudioscore.entity.variant.MushlingVariant;
import net.cozystudios.cozystudioscore.item.ModItems;
import net.cozystudios.cozystudioscore.sound.ModSounds;
import net.cozystudios.cozystudioscore.world.gen.ModEntitySpawns;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6089;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class MushlingEntity
extends class_1321 {
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(MushlingEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public final class_7094 sitAnimationState = new class_7094();
    @Nullable
    private class_2338 lastLightPos = null;
    private static final int NIGHT_GLOW_LEVEL = 12;

    public MushlingEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.1, 10.0f, 3.0f, false));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.15));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{ModItems.COZY_CRUMBS}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f){

            public boolean method_6264() {
                return !MushlingEntity.this.method_6172() && super.method_6264();
            }
        });
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    private void setupAnimationStates() {
        if (this.method_6172()) {
            this.idleAnimationState.method_41325();
            this.sitAnimationState.method_41324(this.field_6012);
        } else {
            this.sitAnimationState.method_41325();
            if (this.idleAnimationTimeout-- <= 0) {
                this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                this.idleAnimationState.method_41322(this.field_6012);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
            return;
        }
        if (this.method_6172() && this.field_6012 % 120 == 0) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_18062, this.method_5634(), 0.5f, 1.0f);
        }
        if (this.method_6181() && this.field_6012 % 5 == 0) {
            this.updateTamedNightLight();
        }
        if (this.method_37908().method_8597().comp_644() && this.method_23318() > 200.0) {
            this.method_31472();
        }
    }

    public static class_5132.class_5133 createMushlingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MushlingEntity baby = (MushlingEntity)ModEntities.MUSHLING.method_5883((class_1937)world);
        if (baby != null) {
            if (entity instanceof MushlingEntity) {
                MushlingEntity other = (MushlingEntity)entity;
                baby.setVariant(this.getVariant() == other.getVariant() ? this.getVariant() : (MushlingVariant)((Object)class_156.method_27173((Object[])MushlingVariant.values(), (class_5819)this.field_5974)));
            } else {
                baby.setVariant(this.getVariant());
            }
        }
        return baby;
    }

    @Nullable
    protected class_3414 method_5994() {
        return switch (this.field_5974.method_43048(4)) {
            case 0 -> ModSounds.MUSHLING_IDLE_1;
            case 1 -> ModSounds.MUSHLING_IDLE_2;
            case 2 -> ModSounds.MUSHLING_IDLE_3;
            default -> ModSounds.MUSHLING_IDLE_4;
        };
    }

    public int method_5970() {
        return 200;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14668;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15208;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (item == ModItems.COZY_CRUMBS) {
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            if (!this.method_6181()) {
                if (!this.method_37908().method_8608()) {
                    if (this.field_5974.method_43048(3) == 0) {
                        this.method_6170(player);
                        this.field_6189.method_6356();
                        this.method_5980(null);
                        this.method_37908().method_8421((class_1297)this, (byte)7);
                    } else {
                        this.method_37908().method_8421((class_1297)this, (byte)6);
                    }
                }
                return class_1269.field_5812;
            }
            if (this.method_6181() && this.method_6032() < this.method_6063()) {
                this.method_6025(2.0f);
                return class_1269.field_5812;
            }
        }
        if (this.method_6181() && this.method_6171((class_1309)player) && hand == class_1268.field_5808 && item != ModItems.COZY_CRUMBS) {
            boolean sitting = !this.method_24345();
            this.method_24346(sitting);
            this.method_6179(sitting);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(ModItems.COZY_CRUMBS);
    }

    private void updateTamedNightLight() {
        if (!this.method_5805() || !this.method_6181() || this.method_37908().method_8530()) {
            this.removeLastLightIfPresent();
            return;
        }
        class_2338 target = this.method_24515();
        if (!this.isAirOrLight(target)) {
            target = target.method_10084();
        }
        if (this.lastLightPos != null && !this.lastLightPos.equals((Object)target)) {
            this.removeLastLightIfPresent();
        }
        if (this.isAirOrLight(target)) {
            class_2680 desired = (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(12));
            class_2680 current = this.method_37908().method_8320(target);
            if (!current.method_27852(class_2246.field_31037) || (Integer)current.method_11654((class_2769)class_6089.field_31187) != 12) {
                this.method_37908().method_8652(target, desired, 2);
            }
            this.lastLightPos = target;
        } else {
            this.lastLightPos = null;
        }
    }

    private void removeLastLightIfPresent() {
        if (this.lastLightPos == null) {
            return;
        }
        class_2680 state = this.method_37908().method_8320(this.lastLightPos);
        if (state.method_27852(class_2246.field_31037)) {
            this.method_37908().method_8652(this.lastLightPos, class_2246.field_10124.method_9564(), 2);
        }
        this.lastLightPos = null;
    }

    private boolean isAirOrLight(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        return state.method_26215() || state.method_27852(class_2246.field_31037);
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().method_8608()) {
            this.removeLastLightIfPresent();
        }
        super.method_5650(reason);
    }

    public MushlingVariant getVariant() {
        return MushlingVariant.byId((Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT) & 0xFF);
    }

    public void setVariant(MushlingVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", ((Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT)).intValue());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(MushlingVariant.byId(nbt.method_10550("Variant")));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 reason, @Nullable class_1315 data, @Nullable class_2487 nbt) {
        MushlingVariant chosen = ModEntitySpawns.pickVariantForBiome(world, this.method_24515()).orElse((MushlingVariant)((Object)class_156.method_27173((Object[])MushlingVariant.values(), (class_5819)this.field_5974)));
        this.setVariant(chosen);
        return super.method_5943(world, difficulty, reason, data, nbt);
    }
}

