/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.cozystudios.cozystudioscore.CozyStudiosCore;
import net.cozystudios.cozystudioscore.config.ModConfig;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class ConfigKilnDataPack {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PACK_FOLDER_NAME = "cozystudioscore_kiln_config";
    private static final int PACK_FORMAT_1_20_1 = 15;

    private ConfigKilnDataPack() {
    }

    public static void writePackForServer(MinecraftServer server, ModConfig config) {
        try {
            Path datapacksDir = server.method_27050(class_5218.field_24186);
            Path packRoot = datapacksDir.resolve(PACK_FOLDER_NAME);
            Path packMeta = packRoot.resolve("pack.mcmeta");
            Path recipesDir = packRoot.resolve("data/cozystudioscore/recipes/kiln");
            Files.createDirectories(recipesDir, new FileAttribute[0]);
            String mcmeta = "{\n  \"pack\": {\n    \"pack_format\": %d,\n    \"description\": \"Cozy Studios Core \u2022 Kiln recipes generated from config\"\n  }\n}\n".formatted(15);
            Files.writeString(packMeta, (CharSequence)mcmeta, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(recipesDir, "*.json");){
                for (Path p : stream2) {
                    Files.deleteIfExists(p);
                }
            }
            catch (IOException stream2) {
                // empty catch block
            }
            int written = 0;
            for (String line : config.extraKilnRecipes) {
                RecipeSpec spec = ConfigKilnDataPack.parseLine(line, config.kilnConfigDefaultXp, config.kilnConfigDefaultTime);
                if (spec == null) {
                    CozyStudiosCore.LOGGER.warn("[Kiln Config] Skipping invalid line: {}", (Object)line);
                    continue;
                }
                if (!class_7923.field_41178.method_10250(spec.input) || !class_7923.field_41178.method_10250(spec.output)) {
                    CozyStudiosCore.LOGGER.warn("[Kiln Config] Unknown item id in line: {}", (Object)line);
                    continue;
                }
                LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                json.put("type", "cozystudioscore:kiln");
                json.put("ingredient", Map.of("item", spec.input.toString()));
                json.put("result", spec.output.toString());
                json.put("experience", spec.xp);
                json.put("cookingtime", spec.time);
                String safeIn = spec.input.toString().replace(':', '_').replace('/', '_');
                String safeOut = spec.output.toString().replace(':', '_').replace('/', '_');
                Path outFile = recipesDir.resolve("cfg_%s_to_%s.json".formatted(safeIn, safeOut));
                Files.writeString(outFile, (CharSequence)GSON.toJson(json), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                ++written;
            }
            CozyStudiosCore.LOGGER.info("[Kiln Config] Wrote {} config kiln recipes to datapack '{}'. Use /reload to apply changes.", (Object)written, (Object)PACK_FOLDER_NAME);
        }
        catch (Exception e) {
            CozyStudiosCore.LOGGER.error("[Kiln Config] Failed to write kiln config datapack", (Throwable)e);
        }
    }

    private static RecipeSpec parseLine(String raw, double defXp, int defTime) {
        Matcher mt;
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        if (s.isEmpty()) {
            return null;
        }
        String[] lr = s.split("->");
        if (lr.length != 2) {
            return null;
        }
        class_2960 in = ConfigKilnDataPack.toId(lr[0]);
        if (in == null) {
            return null;
        }
        String right = lr[1];
        String[] parts = right.split(";");
        class_2960 out = ConfigKilnDataPack.toId(parts[0]);
        if (out == null) {
            return null;
        }
        double xp = defXp;
        int time = defTime;
        Pattern XP = Pattern.compile("\\bxp\\s*=\\s*([0-9]*\\.?[0-9]+)\\b", 2);
        Pattern TIME = Pattern.compile("\\btime\\s*=\\s*([0-9]+)\\b", 2);
        Matcher mx = XP.matcher(s);
        if (mx.find()) {
            xp = Double.parseDouble(mx.group(1));
        }
        if ((mt = TIME.matcher(s)).find()) {
            time = Integer.parseInt(mt.group(1));
        }
        return new RecipeSpec(in, out, xp, time);
    }

    private static class_2960 toId(String side) {
        String t = side.trim().replace(",", "");
        if (t.isEmpty()) {
            return null;
        }
        try {
            return new class_2960(t);
        }
        catch (Exception e) {
            return null;
        }
    }

    private record RecipeSpec(class_2960 input, class_2960 output, double xp, int time) {
    }
}

