/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.world;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.cozystudios.cozystudioscore.block.ModBlocks;
import net.cozystudios.cozystudioscore.config.ModConfig;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1593;
import net.minecraft.class_1621;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class TranquilLanternSpawnBlocker {
    private static final Map<class_3218, Set<class_2338>> ACTIVE_LANTERNS = new HashMap<class_3218, Set<class_2338>>();
    private static int tickTimer = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(TranquilLanternSpawnBlocker::tick);
    }

    private static void tick(MinecraftServer server) {
        if (++tickTimer < 10) {
            return;
        }
        tickTimer = 0;
        if (ACTIVE_LANTERNS.isEmpty()) {
            return;
        }
        int radius = ModConfig.get().tranquilLanternRadius;
        double radiusSq = radius * radius;
        for (class_3218 world : server.method_3738()) {
            Set<class_2338> lanterns = ACTIVE_LANTERNS.get(world);
            if (lanterns == null || lanterns.isEmpty()) continue;
            Iterator<class_2338> it = lanterns.iterator();
            while (it.hasNext()) {
                class_2338 lanternPos = it.next();
                if (!world.method_22340(lanternPos)) continue;
                class_2680 state = world.method_8320(lanternPos);
                if (!state.method_27852(ModBlocks.TRANQUIL_LANTERN)) {
                    it.remove();
                    continue;
                }
                class_238 box = new class_238((double)(lanternPos.method_10263() - radius), (double)(lanternPos.method_10264() - radius), (double)(lanternPos.method_10260() - radius), (double)(lanternPos.method_10263() + radius), (double)(lanternPos.method_10264() + radius), (double)(lanternPos.method_10260() + radius));
                List mobs = world.method_8390(class_1308.class, box, mob -> mob.method_5805() && TranquilLanternSpawnBlocker.isHostileMob(mob));
                if (mobs.isEmpty()) continue;
                double cx = (double)lanternPos.method_10263() + 0.5;
                double cy = (double)lanternPos.method_10264() + 0.5;
                double cz = (double)lanternPos.method_10260() + 0.5;
                for (class_1308 mob2 : mobs) {
                    double dx = mob2.method_23317() - cx;
                    double dy = mob2.method_23318() - cy;
                    double dz = mob2.method_23321() - cz;
                    double distSq = dx * dx + dy * dy + dz * dz;
                    if (mob2 instanceof class_1593 && distSq <= radiusSq) {
                        mob2.method_5768();
                        continue;
                    }
                    if (!(distSq < radiusSq) || !(distSq > 0.001)) continue;
                    double dist = Math.sqrt(distSq);
                    double pushStrength = 0.25 * (1.0 - dist / (double)radius);
                    mob2.method_5762(dx / dist * pushStrength, 0.05, dz / dist * pushStrength);
                    mob2.field_6037 = true;
                    if (!(dist < (double)radius * 0.95)) continue;
                    double edgeDist = ((double)radius - dist) * 0.25;
                    mob2.method_5859(mob2.method_23317() + dx / dist * edgeDist, mob2.method_23318(), mob2.method_23321() + dz / dist * edgeDist);
                }
            }
        }
    }

    private static boolean isHostileMob(class_1308 mob) {
        return mob instanceof class_1588 || mob instanceof class_1621 || mob instanceof class_1589 || mob instanceof class_1593;
    }

    public static void addLantern(class_3218 world, class_2338 pos) {
        ACTIVE_LANTERNS.computeIfAbsent(world, k -> new HashSet()).add(pos.method_10062());
    }

    public static void removeLantern(class_3218 world, class_2338 pos) {
        Set<class_2338> set = ACTIVE_LANTERNS.get(world);
        if (set != null) {
            set.remove(pos.method_10062());
        }
    }
}

