/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore;

import java.lang.reflect.Field;
import me.shedaniel.autoconfig.AutoConfig;
import net.cozystudios.cozystudioscore.block.ModBlocks;
import net.cozystudios.cozystudioscore.block.entity.ModBlockEntities;
import net.cozystudios.cozystudioscore.config.ModConfig;
import net.cozystudios.cozystudioscore.entity.ModEntities;
import net.cozystudios.cozystudioscore.events.RightClickRecolorHandler;
import net.cozystudios.cozystudioscore.item.ModItemGroups;
import net.cozystudios.cozystudioscore.item.ModItems;
import net.cozystudios.cozystudioscore.loot.ModLootInjector;
import net.cozystudios.cozystudioscore.recipe.ConfigKilnDataPack;
import net.cozystudios.cozystudioscore.recipe.ModRecipeTypes;
import net.cozystudios.cozystudioscore.save.FirstJoinGiftState;
import net.cozystudios.cozystudioscore.screen.ModScreenHandlers;
import net.cozystudios.cozystudioscore.sound.ModSounds;
import net.cozystudios.cozystudioscore.util.ModMasonTrades;
import net.cozystudios.cozystudioscore.util.ModRegistries;
import net.cozystudios.cozystudioscore.villager.ModVillagers;
import net.cozystudios.cozystudioscore.world.ModTradersSpawner;
import net.cozystudios.cozystudioscore.world.TranquilLanternSpawnBlocker;
import net.cozystudios.cozystudioscore.world.gen.ModWorldGeneration;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CozyStudiosCore
implements ModInitializer {
    public static final String MOD_ID = "cozystudioscore";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cozystudioscore");

    public void onInitialize() {
        ModConfig.register();
        ModItemGroups.registerItemGroups();
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerBlockEntities();
        ModRecipeTypes.register();
        TranquilLanternSpawnBlocker.register();
        ModScreenHandlers.registerScreenHandlers();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            ConfigKilnDataPack.writePackForServer(server, config);
        });
        ModMasonTrades.registerCustomTrades();
        RightClickRecolorHandler.register();
        ModEntities.registerModEntities();
        ModRegistries.registerModStuffs();
        ModWorldGeneration.generateModWorldGeneration();
        ModSounds.registerSounds();
        ModVillagers.registerVillagers();
        ModTradersSpawner.register();
        ModLootInjector.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ModConfig config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
            if (config.maxStackSizeOverride >= 16 && config.maxStackSizeOverride <= 64) {
                this.fixStackSizes(config.maxStackSizeOverride);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            FirstJoinGiftState state = FirstJoinGiftState.get(server);
            if (state.markIfNew(player.method_5667())) {
                class_1799 gift = new class_1799((class_1935)ModItems.GOLDEN_LEAF);
                if (!player.method_31548().method_7394(gift)) {
                    player.method_7328(gift, false);
                }
            }
        });
        LOGGER.info("Cozy Studios Core initialized!");
    }

    private void fixStackSizes(int newMax) {
        int changed = 0;
        for (class_1792 item : class_7923.field_41178) {
            if (item.method_7882() != 16) continue;
            try {
                Field field = null;
                block3: for (Class<?> cls = item.getClass(); cls != null && field == null; cls = cls.getSuperclass()) {
                    for (Field f : cls.getDeclaredFields()) {
                        if (!f.getName().equals("maxCount") && !f.getName().equals("field_8013")) continue;
                        field = f;
                        continue block3;
                    }
                }
                if (field == null) {
                    throw new NoSuchFieldException("maxCount not found in hierarchy");
                }
                field.setAccessible(true);
                field.set(item, newMax);
                ++changed;
            }
            catch (Exception e) {
                LOGGER.error("Failed to update stack size for {}: {}", (Object)class_7923.field_41178.method_10221((Object)item), (Object)e.toString());
            }
        }
    }
}

