/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.world.gen;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.cozystudios.cozystudioscore.entity.ModEntities;
import net.cozystudios.cozystudioscore.entity.variant.FernlingVariant;
import net.cozystudios.cozystudioscore.entity.variant.MushlingVariant;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class ModEntitySpawns {
    public static final Map<MushlingVariant, Set<class_5321<class_1959>>> VARIANT_BIOMES = new EnumMap<MushlingVariant, Set<class_5321<class_1959>>>(MushlingVariant.class);
    public static final Map<FernlingVariant, Set<class_5321<class_1959>>> FERNLING_VARIANT_BIOMES = new EnumMap<FernlingVariant, Set<class_5321<class_1959>>>(FernlingVariant.class);

    public static void addSpawns() {
        class_5321[] keys;
        for (Map.Entry<MushlingVariant, Set<class_5321<class_1959>>> entry : VARIANT_BIOMES.entrySet()) {
            int min;
            int weight;
            class_1311 group;
            if (entry.getValue().isEmpty()) continue;
            keys = entry.getValue().toArray(new class_5321[0]);
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])keys), (class_1311)group, ModEntities.MUSHLING, (int)weight, (int)min, (int)(switch (entry.getKey()) {
                case MushlingVariant.CRIMSON, MushlingVariant.WARPED -> {
                    group = class_1311.field_6302;
                    weight = 80;
                    min = 1;
                    yield 2;
                }
                case MushlingVariant.LUSH -> {
                    group = class_1311.field_6294;
                    weight = 160;
                    min = 2;
                    yield 5;
                }
                default -> {
                    group = class_1311.field_6294;
                    weight = 50;
                    min = 1;
                    yield 3;
                }
            }));
        }
        class_1317.method_20637(ModEntities.MUSHLING, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, (type, world, reason, pos, random) -> {
            class_6880 entry = world.method_23753(pos);
            if (entry.method_40225(class_1972.field_22077) || entry.method_40225(class_1972.field_22075)) {
                return true;
            }
            if (entry.method_40225(class_1972.field_29218)) {
                class_2248 blockBelow = world.method_8320(pos.method_10074()).method_26204();
                boolean validBlock = blockBelow == class_2246.field_10460 || blockBelow == class_2246.field_10219 || blockBelow == class_2246.field_28681 || blockBelow == class_2246.field_28680 || blockBelow == class_2246.field_28678 || blockBelow == class_2246.field_28679 || blockBelow == class_2246.field_28685 || blockBelow == class_2246.field_10340 || blockBelow == class_2246.field_28888;
                boolean inWater = world.method_8320(pos).method_27852(class_2246.field_10382);
                return world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074()) || inWater || validBlock;
            }
            return class_1429.method_20663((class_1299)type, (class_1936)world, (class_3730)reason, (class_2338)pos, (class_5819)random);
        });
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}), (class_1311)class_1311.field_6294, ModEntities.MYSTICAL_ELK, (int)30, (int)1, (int)2);
        class_1317.method_20637(ModEntities.MYSTICAL_ELK, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        for (Map.Entry<Enum, Set<class_5321<class_1959>>> entry : FERNLING_VARIANT_BIOMES.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            keys = entry.getValue().toArray(new class_5321[0]);
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.includeByKey((class_5321[])keys), (class_1311)class_1311.field_6294, ModEntities.FERNLING, (int)50, (int)1, (int)2);
        }
        class_1317.method_20637(ModEntities.FERNLING, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
    }

    public static Optional<MushlingVariant> pickVariantForBiome(class_5425 world, class_2338 pos) {
        class_6880 entry = world.method_23753(pos);
        Optional keyOpt = entry.method_40230();
        if (keyOpt.isEmpty()) {
            return Optional.empty();
        }
        class_5321 key = (class_5321)keyOpt.get();
        for (MushlingVariant variant : MushlingVariant.values()) {
            Set biomes = VARIANT_BIOMES.getOrDefault((Object)variant, Collections.emptySet());
            if (!biomes.contains(key)) continue;
            return Optional.of(variant);
        }
        return Optional.empty();
    }

    public static Optional<FernlingVariant> pickFernlingVariantForBiome(class_5425 world, class_2338 pos) {
        class_6880 entry = world.method_23753(pos);
        Optional keyOpt = entry.method_40230();
        if (keyOpt.isEmpty()) {
            return Optional.empty();
        }
        class_5321 key = (class_5321)keyOpt.get();
        for (FernlingVariant variant : FernlingVariant.values()) {
            Set biomes = FERNLING_VARIANT_BIOMES.getOrDefault((Object)variant, Collections.emptySet());
            if (!biomes.contains(key)) continue;
            return Optional.of(variant);
        }
        return Optional.empty();
    }

    static {
        VARIANT_BIOMES.put(MushlingVariant.DEFAULT, Set.of(class_1972.field_9409, class_1972.field_9475, class_1972.field_34470, class_1972.field_9462));
        VARIANT_BIOMES.put(MushlingVariant.ICE, Set.of(class_1972.field_34471, class_1972.field_9454, class_1972.field_34472, class_1972.field_9453, class_1972.field_35115, class_1972.field_9478, class_1972.field_35117));
        VARIANT_BIOMES.put(MushlingVariant.CRIMSON, Set.of(class_1972.field_22077));
        VARIANT_BIOMES.put(MushlingVariant.LUSH, Set.of(class_1972.field_29218));
        VARIANT_BIOMES.put(MushlingVariant.WARPED, Set.of(class_1972.field_22075));
        FERNLING_VARIANT_BIOMES.put(FernlingVariant.DEFAULT, Set.of(class_1972.field_9409, class_1972.field_9412, class_1972.field_9414, class_1972.field_9475));
        FERNLING_VARIANT_BIOMES.put(FernlingVariant.DESERT, Set.of(class_1972.field_9424, class_1972.field_9415, class_1972.field_9443, class_1972.field_35110));
        FERNLING_VARIANT_BIOMES.put(FernlingVariant.ICE, Set.of(class_1972.field_34471, class_1972.field_9454, class_1972.field_34472, class_1972.field_9453, class_1972.field_35115, class_1972.field_9478, class_1972.field_35117));
        FERNLING_VARIANT_BIOMES.put(FernlingVariant.SWAMP, Set.of(class_1972.field_9471, class_1972.field_38748));
    }
}

