/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage;

import fabric.com.cursee.automessage.core.ServerMessageService;
import fabric.com.cursee.automessage.core.data.ServerMessages;
import fabric.com.cursee.automessage.core.message.Message;
import fabric.com.cursee.automessage.core.message.MessageServiceUtil;
import fabric.com.cursee.automessage.core.message.MessageType;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AutoMessageServer {
    public static void init(MinecraftServer server) {
        new ServerMessageService().load();
    }

    public static void onFirstJoin(class_3222 player, class_3218 level) {
        ServerMessages.ON_FIRST_JOIN_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "firstJoin"));
    }

    public static void onJoinLevel(class_3222 player, class_3218 level) {
        ServerMessages.ON_JOIN_LEVEL_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "join"));
    }

    public static void onDeath(class_3222 player, class_3218 level) {
        ServerMessages.ON_DEATH_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "death"));
    }

    public static void onRespawn(class_3222 player, class_3218 level) {
        ServerMessages.ON_RESPAWN_MESSAGES.forEach(message -> AutoMessageServer.trySendMessageOnce(player, message, "respawn"));
    }

    public static void trySendMessageOnce(class_3222 player, Message message, String suffix) {
        if (!ServerMessageService.instance.general.enabled) {
            return;
        }
        boolean hasTag = player.method_5752().contains(message.identifier + "." + suffix);
        if (message.repeats || !hasTag) {
            player.method_7353(MessageServiceUtil.styledComponent(message, (class_1657)player), message.type == MessageType.OVERLAY);
            if (!hasTag) {
                player.method_5780(message.identifier + "." + suffix);
            }
        }
    }
}

