/*
 * Decompiled with CFR 0.152.
 */
package net.dsoda.deployanddestroy.blocks.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import net.dsoda.deployanddestroy.blocks.DDBlocks;
import net.dsoda.deployanddestroy.blocks.block.entity.MaterialBarrelBlockEntity;
import net.dsoda.deployanddestroy.stats.DDStats;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4838;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class MaterialBarrelBlock
extends class_2237 {
    public static MapCodec<MaterialBarrelBlock> CODEC = MaterialBarrelBlock.method_54094(MaterialBarrelBlock::new);
    private static final Map<BarrelMaterial, class_2960> STAT_FOR_MATERIAL = new ImmutableMap.Builder().put((Object)BarrelMaterial.COPPER, (Object)DDStats.OPEN_COPPER_BARREL).put((Object)BarrelMaterial.IRON, (Object)DDStats.OPEN_IRON_BARREL).put((Object)BarrelMaterial.GOLD, (Object)DDStats.OPEN_GOLD_BARREL).put((Object)BarrelMaterial.DIAMOND, (Object)DDStats.OPEN_DIAMOND_BARREL).put((Object)BarrelMaterial.NETHERITE, (Object)DDStats.OPEN_NETHERITE_BARREL).build();
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 OPEN = class_2741.field_12537;
    private final BarrelMaterial material;

    public MaterialBarrelBlock(class_4970.class_2251 settings, BarrelMaterial material) {
        super(settings);
        this.material = material;
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private MaterialBarrelBlock(class_4970.class_2251 settings) {
        super(settings);
        this.material = BarrelMaterial.COPPER;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MaterialBarrelBlockEntity) {
            player.method_17355((class_3908)((MaterialBarrelBlockEntity)blockEntity));
            player.method_7281(STAT_FOR_MATERIAL.get((Object)this.material));
            class_4838.method_24733((class_3218)((class_3218)world), (class_1657)player, (boolean)true);
        }
        return class_1269.field_21466;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291((class_2680)state, (class_2680)newState, (class_1937)world, (class_2338)pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MaterialBarrelBlockEntity) {
            ((MaterialBarrelBlockEntity)blockEntity).tick();
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return switch (this.material.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new MaterialBarrelBlockEntity.Copper(pos, state);
            case 1 -> new MaterialBarrelBlockEntity.Iron(pos, state);
            case 2 -> new MaterialBarrelBlockEntity.Gold(pos, state);
            case 3 -> new MaterialBarrelBlockEntity.Diamond(pos, state);
            case 4 -> new MaterialBarrelBlockEntity.Netherite(pos, state);
        };
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_57824(class_9334.field_49631) != null && (blockEntity = world.method_8321(pos)) instanceof MaterialBarrelBlockEntity) {
            ((MaterialBarrelBlockEntity)blockEntity).setCustomName(itemStack.method_7964());
        }
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, OPEN});
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_7715().method_10153());
    }

    public static Optional<class_2248> getUpgradedBarrel(class_2248 block, BarrelMaterial material) {
        return switch (material.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (block.equals(class_2246.field_16328)) {
                    yield Optional.ofNullable(DDBlocks.COPPER_BARREL);
                }
                yield Optional.empty();
            }
            case 1 -> {
                if (block.equals(DDBlocks.COPPER_BARREL)) {
                    yield Optional.ofNullable(DDBlocks.IRON_BARREL);
                }
                yield Optional.empty();
            }
            case 2 -> {
                if (block.equals(DDBlocks.IRON_BARREL)) {
                    yield Optional.ofNullable(DDBlocks.GOLD_BARREL);
                }
                yield Optional.empty();
            }
            case 3 -> {
                if (block.equals(DDBlocks.GOLD_BARREL)) {
                    yield Optional.ofNullable(DDBlocks.DIAMOND_BARREL);
                }
                yield Optional.empty();
            }
            case 4 -> block.equals(DDBlocks.DIAMOND_BARREL) ? Optional.ofNullable(DDBlocks.NETHERITE_BARREL) : Optional.empty();
        };
    }

    public static enum BarrelMaterial {
        COPPER,
        IRON,
        GOLD,
        DIAMOND,
        NETHERITE;

    }
}

