package yesman.epicfight.main;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationManager.AnimationRegistryEvent;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.property.JointMaskReloadListener;
import yesman.epicfight.api.client.model.ItemSkinsReloadListener;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.client.events.engine.IEventBasedEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.config.IngameConfigurationScreen;
import yesman.epicfight.client.gui.screen.config.ItemsPreferenceScreen;
import yesman.epicfight.client.renderer.patched.item.EpicFightItemProperties;
import yesman.epicfight.client.renderer.shader.compute.loader.ComputeShaderProvider;
import yesman.epicfight.compat.AzureLibArmorCompat;
import yesman.epicfight.compat.AzureLibCompat;
import yesman.epicfight.compat.CuriosCompat;
import yesman.epicfight.compat.FirstPersonCompat;
import yesman.epicfight.compat.GeckolibCompat;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.compat.IRISCompat;
import yesman.epicfight.compat.PlayerAnimatorCompat;
import yesman.epicfight.compat.SkinLayer3DCompat;
import yesman.epicfight.compat.VampirismCompat;
import yesman.epicfight.compat.WerewolvesCompat;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.config.CommonConfig;
import yesman.epicfight.config.ServerConfig;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.network.EntityPairingPacketType;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightCommandArgumentTypes;
import yesman.epicfight.registry.entries.EpicFightCreativeTabs;
import yesman.epicfight.registry.entries.EpicFightItems;
import yesman.epicfight.registry.entries.EpicFightMobEffects;
import yesman.epicfight.registry.entries.EpicFightPotions;
import yesman.epicfight.server.commands.AnimatorCommand;
import yesman.epicfight.server.commands.PlayerModeCommand;
import yesman.epicfight.server.commands.PlayerSkillCommand;
import yesman.epicfight.server.commands.PlayerStaminaCommand;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.item.CapabilityItem.Styles;
import yesman.epicfight.world.capabilities.item.CapabilityItem.WeaponCategories;
import yesman.epicfight.world.capabilities.item.ItemKeywordReloadListener;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.item.WeaponTypeReloadListener;
import yesman.epicfight.world.gamerule.EpicFightGameRules;
import yesman.epicfight.world.item.SkillBookItem;

/**
 *  ***************************************************************
 *  Major version changes
 *  ***************************************************************
 *  Created 21.12.1
 *  
 *  Port from 20.12.2
 *  Fixed the Epic Fight crafting recipes not working (#2034)
 *  Fixed the Epic Fight weapons couldn't be enchanted (#2034)
 *  Fixed the crash with Storage Drawers (#2050)
 *  
 *  ***************************************************************
 *  21.12.2
 *  
 *  Port from 20.12.6
 *  Fixed the crash when other players join to server
 *  
 *  ***************************************************************
 *  21.12.3
 *  
 *  Port from 20.12.8
 *  
 *  ***************************************************************
 *  21.12.4
 *  
 *  Port from 20.12.9
 *  Fixed the recipes not working
 *  FIxed the skillbooks having the same texture
 *  
 *  ***************************************************************
 *  21.12.5
 *  
 *  Port from 20.12.12
 *  Fixed the crash when equipping geckolib armors
 *  Fixed the armor's texture path to follow the render property first
 *  Restored Skin layer 3d compatibility
 *  
 *  ***************************************************************
 *  
 *  --- TO DO ---
 *  
 *  Update language files (always)
 *  Add an alert function when an entity targeting the player tries grappling or execution attack
 *  Add UI for execution resistance
 *  Add functionality to blooming effect (resists wither effect)
 *  Add a screen for setting animation properties in datapack editor
 *  Enhance the stun system (maybe remove or barely leave knockback)
 *  
 *  @author yesman
 */
@Mod(EpicFightMod.MODID)
public class EpicFightMod {
	public static final String MODID = "epicfight";
	public static final String EPICSKINS_MODID = "epicskins";
	public static final Logger LOGGER = LogManager.getLogger(MODID);
	
	public static String prefix(String s) {
		return String.format("%s:%s", MODID, s);
	}
	
	public static void logAndStacktraceIfDevSide(BiConsumer<Logger, String> logFunction, String message, Function<String, Throwable> exceptionProvider) {
		logAndStacktraceIfDevSide(logFunction, message, exceptionProvider, message);
	}
	
	public static void logAndStacktraceIfDevSide(BiConsumer<Logger, String> logFunction, String message, Function<String, Throwable> exceptionProvider, String stackTraceMessage) {
		logFunction.accept(LOGGER, message);
		stacktraceIfDevSide(message, exceptionProvider, stackTraceMessage);
	}
	
	public static void stacktraceIfDevSide(String message, Function<String, Throwable> exceptionProvider) {
		stacktraceIfDevSide(message, exceptionProvider, message);
	}
	
	public static void stacktraceIfDevSide(String message, Function<String, Throwable> exceptionProvider, String stackTraceMessage) {
		if (exceptionProvider != null && EpicFightSharedConstants.IS_DEV_ENV) {
			exceptionProvider.apply(stackTraceMessage).printStackTrace();
		}
	}
	
    public EpicFightMod(IEventBus modEventBus, ModContainer modContainer) {
    	if (EpicFightSharedConstants.isPhysicalClient()) {
    		modContainer.registerConfig(ModConfig.Type.CLIENT, ClientConfig.SPEC);
    		modContainer.registerExtensionPoint(IConfigScreenFactory.class, IngameConfigurationScreen::new);
    		IEventBasedEngine.init(NeoForge.EVENT_BUS, modEventBus);
    	} else {
    		modContainer.registerConfig(ModConfig.Type.SERVER, ServerConfig.SPEC);
    	}
    	
    	modContainer.registerConfig(ModConfig.Type.COMMON, CommonConfig.SPEC);
    	modContainer.registerExtensionPoint(EpicFightExtensions.class, (Supplier<EpicFightExtensions>)() -> new EpicFightExtensions(EpicFightCreativeTabs.ITEMS));
    	
		modEventBus.addListener(this::constructMod);
		modEventBus.addListener(this::doCommonStuff);
		modEventBus.addListener(this::addPackFindersEvent);
		modEventBus.addListener(this::buildCreativeTabWithSkillBooks);
		modEventBus.addListener(EpicFightCapabilities::registerCapabilities);
    	
    	NeoForge.EVENT_BUS.addListener(this::command);
        NeoForge.EVENT_BUS.addListener(this::addReloadListnerEvent);
        
    	LivingMotion.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, LivingMotions.class);
    	SkillCategory.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, SkillCategories.class);
    	SkillSlot.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, SkillSlots.class);
    	Style.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, Styles.class);
    	WeaponCategory.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, WeaponCategories.class);
    	Faction.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, Factions.class);
    	EntityPairingPacketType.ENUM_MANAGER.registerEnumCls(EpicFightMod.MODID, EntityPairingPacketTypes.class);
    	
    	EpicFightRegistries.DEFERRED_REGISTRIES.forEach(deferredRegistry -> deferredRegistry.register(modEventBus));
		
		if (ModList.get().isLoaded("vampirism")) {
			ICompatModule.loadCompatModule(modEventBus, VampirismCompat.class);
		}
        
        if (ModList.get().isLoaded("werewolves")) {
			ICompatModule.loadCompatModule(modEventBus, WerewolvesCompat.class);
		}
        
        if (ModList.get().isLoaded("curios")) {
			ICompatModule.loadCompatModule(modEventBus, CuriosCompat.class);
		}
        
		if (EpicFightSharedConstants.isPhysicalClient()) {
			modEventBus.addListener(ComputeShaderProvider::epicfight$registerComputeShaders);
			
			if (ModList.get().isLoaded("geckolib")) {
				ICompatModule.loadCompatModule(modEventBus, GeckolibCompat.class);
			}
			
			if (ModList.get().isLoaded("azurelib")) {
				ICompatModule.loadCompatModule(modEventBus, AzureLibCompat.class);
			}
			
			if (ModList.get().isLoaded("azurelibarmor")) {
				ICompatModule.loadCompatModule(modEventBus, AzureLibArmorCompat.class);
			}
			
			if (ModList.get().isLoaded("firstperson")) {
				ICompatModule.loadCompatModule(modEventBus, FirstPersonCompat.class);
			}
			
			if (ModList.get().isLoaded("skinlayers3d")) {
				ICompatModule.loadCompatModule(modEventBus, SkinLayer3DCompat.class);
			}
			
			if (ModList.get().isLoaded("iris")) {
				ICompatModule.loadCompatModule(modEventBus, IRISCompat.class);
			}
			
			if (ModList.get().isLoaded("playeranimator")) {
				ICompatModule.loadCompatModule(modEventBus, PlayerAnimatorCompat.class);
			}
		}
	}
    
    /**
     * FML Lifecycle Events
     */
    private void constructMod(final FMLConstructModEvent event) {
    	event.enqueueWork(LivingMotion.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(SkillCategory.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(SkillSlot.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(Style.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(WeaponCategory.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(Faction.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(EntityPairingPacketType.ENUM_MANAGER::loadEnum);
    	event.enqueueWork(() -> {
    		AnimationManager.addNoWarningModId(EPICSKINS_MODID);
			AnimationRegistryEvent animationregistryevent = new AnimationRegistryEvent();
    		ModLoader.postEvent(animationregistryevent);
    		animationregistryevent.getBuilders().stream().sorted((b1, b2) -> b1.namespace().compareTo(b2.namespace())).forEach((builder) -> builder.task().accept(builder));
    	});
    }
    
	private void doCommonStuff(final FMLCommonSetupEvent event) {
		event.enqueueWork(Armatures::registerEntityTypes);
		event.enqueueWork(EpicFightCommandArgumentTypes::registerArgumentTypes);
		event.enqueueWork(EpicFightPotions::addRecipes);
		event.enqueueWork(EpicFightCapabilities.ITEM_CAPABILITY_PROVIDER::registerWeaponTypesByClass);
		event.enqueueWork(EpicFightCapabilities.ENTITY_PATCH_PROVIDER::registerVanillaEntityPatches);
		event.enqueueWork(EpicFightGameRules::registerGameRules);
		event.enqueueWork(WeaponTypeReloadListener::registerDefaultWeaponTypes);
		event.enqueueWork(EpicFightMobEffects::addOffhandModifier);
		event.enqueueWork(EpicFightExtensibleEnums::initExtensibleEnums);
    }
	
	/**
	 * Register Commands
	 */
	private void command(final RegisterCommandsEvent event) {
		PlayerModeCommand.register(event.getDispatcher());
		PlayerSkillCommand.register(event.getDispatcher());
		PlayerStaminaCommand.register(event.getDispatcher());
		AnimatorCommand.register(event.getDispatcher());
    }
	
	public void addPackFindersEvent(AddPackFindersEvent event) {
		if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Path resourcePath = ModList.get().getModFileById(EpicFightMod.MODID).getFile().findResource("packs/epicfight_legacy");
            
            PackLocationInfo packLocation = new PackLocationInfo("epicfight_legacy", Component.translatable("pack.epicfight_legacy.title"), PackSource.BUILT_IN, Optional.empty());
            Pack.ResourcesSupplier resourcesSupplier = new PathPackResources.PathResourcesSupplier(resourcePath);
            
            Pack pack = Pack.readMetaAndCreate(packLocation, resourcesSupplier, PackType.CLIENT_RESOURCES, new PackSelectionConfig(false, Pack.Position.TOP, false));
            
            if (pack != null) {
                event.addRepositorySource(source -> source.accept(pack));
            }
        }
    }
	
	private void addReloadListnerEvent(final AddReloadListenerEvent event) {
		event.addListener(new ColliderPreset());
		event.addListener(new SkillReloadListener());
		event.addListener(new WeaponTypeReloadListener());
		event.addListener(new ItemKeywordReloadListener());
		event.addListener(new ItemCapabilityReloadListener());
		event.addListener(new MobPatchReloadListener());
	}
	
	@EventBusSubscriber(modid = EpicFightMod.MODID, value = Dist.CLIENT)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        	event.enqueueWork(ComputeShaderProvider::checkIfSupports);
    		event.enqueueWork(EpicFightCapabilities.ENTITY_PATCH_PROVIDER::registerClientPlayerPatches);
    		event.enqueueWork(SkillBookScreen::registerIconItems);
    		event.enqueueWork(EpicFightItemProperties::registerItemProperties);
    		
    		event.enqueueWork(() -> {
    			if (ClientConfig.combatPreferredItems.isEmpty() && ClientConfig.miningPreferredItems.isEmpty()) {
    				ItemsPreferenceScreen.resetItems();
    			}
    		});
    		
    		event.enqueueWork(RenderEngine.getInstance()::initialize);
        }
        
        @SubscribeEvent
        public static void registerResourcepackReloadListnerEvent(final RegisterClientReloadListenersEvent event) {
    		event.registerReloadListener(new JointMaskReloadListener());
    		event.registerReloadListener(Meshes.INSTANCE);
    		event.registerReloadListener(AnimationManager.getInstance());
    		event.registerReloadListener(ItemSkinsReloadListener.INSTANCE);
    	}
    }
	
	@EventBusSubscriber(modid = EpicFightMod.MODID, value = Dist.DEDICATED_SERVER)
    public static class ServerForgeEvents {
		@SubscribeEvent(priority = EventPriority.HIGHEST)
		public static void addReloadListnerEvent(final AddReloadListenerEvent event) {
			event.addListener(AnimationManager.getInstance());
		}
    }
	
	private void buildCreativeTabWithSkillBooks(final BuildCreativeModeTabContentsEvent event) {
		/**
		 * Accept learnable skills for each mod by {@link EpicFightExtensions#skillBookCreativeTab}.
		 * If the extension doesn't exist, add them to {@link EpicFightCreativeTabs.ITEMS} tab.
		 */
		EpicFightRegistries.SKILL.keySet().stream().map(id -> id.getNamespace()).distinct().forEach((modid) -> {
			ModList.get().getModContainerById(modid).flatMap(modcontainer -> modcontainer.getCustomExtension(EpicFightExtensions.class)).ifPresentOrElse(extension -> {
				if (extension.skillBookCreativeTab().get() == event.getTab()) {
					EpicFightRegistries.SKILL.holders()
						.filter(skill ->
							skill.value().getCategory().learnable() &&
							skill.value().getCreativeTab() == null &&
							skill.value().getRegistryName().getNamespace() == modid
						).forEach(holder -> {
							ItemStack stack = new ItemStack(EpicFightItems.SKILLBOOK.get());
							SkillBookItem.setContainingSkill(holder, stack);
							event.accept(stack);
						});
				}
			}, () -> {
				if (event.getTab() == EpicFightCreativeTabs.ITEMS.get()) {
					EpicFightRegistries.SKILL.holders()
						.filter(skill ->
							skill.value().getCategory().learnable() &&
							skill.value().getCreativeTab() == null &&
							skill.value().getRegistryName().getNamespace() == modid
						).forEach(holder -> {
							ItemStack stack = new ItemStack(EpicFightItems.SKILLBOOK.get());
							SkillBookItem.setContainingSkill(holder, stack);
							event.accept(stack);
						});
				}
			});
		});
		
		EpicFightRegistries.SKILL.holders()
			.filter(skill -> 
				skill.value().getCategory().learnable() &&
				skill.value().getCreativeTab() == event.getTab()
			).forEach(holder -> {
				ItemStack stack = new ItemStack(EpicFightItems.SKILLBOOK.get());
				SkillBookItem.setContainingSkill(holder, stack);
				event.accept(stack);
			});
	}
}