/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.ServerAnimator;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.JointMask;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class ClientAnimator
extends Animator {
    private final Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> compositeLivingAnimations;
    private final Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> defaultLivingAnimations;
    private final Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> defaultCompositeLivingAnimations;
    public final Layer.BaseLayer baseLayer;
    private LivingMotion currentMotion = LivingMotions.IDLE;
    private LivingMotion currentCompositeMotion = LivingMotions.IDLE;
    private boolean hardPaused;

    public static Animator getAnimator(LivingEntityPatch<?> entitypatch) {
        return entitypatch.isLogicalClient() ? new ClientAnimator(entitypatch) : ServerAnimator.getAnimator(entitypatch);
    }

    public ClientAnimator(LivingEntityPatch<?> entitypatch) {
        this(entitypatch, Layer.BaseLayer::new);
    }

    public ClientAnimator(LivingEntityPatch<?> entitypatch, Supplier<Layer.BaseLayer> layerSupplier) {
        super(entitypatch);
        this.compositeLivingAnimations = Maps.newHashMap();
        this.defaultLivingAnimations = Maps.newHashMap();
        this.defaultCompositeLivingAnimations = Maps.newHashMap();
        this.baseLayer = layerSupplier.get();
    }

    @Override
    public void playAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, float transitionTimeModifier) {
        Layer.BaseLayer layer = nextAnimation.get().getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)nextAnimation.get().getPriority());
        layer.paused = false;
        ((Layer)layer).playAnimation(nextAnimation, this.entitypatch, transitionTimeModifier);
    }

    @ApiStatus.Internal
    public void playAnimationAt(AssetAccessor<? extends StaticAnimation> nextAnimation, float transitionTimeModifier, AbstractAnimatorControl.Layer layerType, AbstractAnimatorControl.Priority priority) {
        Layer.BaseLayer layer = layerType == AbstractAnimatorControl.Layer.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)AbstractAnimatorControl.getPriority(priority));
        layer.paused = false;
        ((Layer)layer).playAnimation(nextAnimation, this.entitypatch, transitionTimeModifier);
    }

    @Override
    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> nextAnimation) {
        Layer.BaseLayer layer = nextAnimation.get().getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)nextAnimation.get().getPriority());
        layer.paused = false;
        layer.playAnimationInstantly(nextAnimation, this.entitypatch);
    }

    @Override
    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation) {
        Layer.BaseLayer layer;
        Layer layer2 = layer = nextAnimation.get().getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)nextAnimation.get().getPriority());
        if (nextAnimation.get().getPriority().isHigherThan(layer.animationPlayer.getRealAnimation().get().getPriority())) {
            if (!layer.animationPlayer.isEnd() && layer.animationPlayer.getAnimation() != null) {
                layer.animationPlayer.getAnimation().get().end(this.entitypatch, nextAnimation, false);
            }
            layer.animationPlayer.terminate(this.entitypatch);
        }
        layer.nextAnimation = nextAnimation;
        layer.paused = false;
    }

    @Override
    public boolean stopPlaying(AssetAccessor<? extends StaticAnimation> targetAnimation) {
        Layer.BaseLayer layer;
        Layer layer2 = layer = targetAnimation.get().getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)targetAnimation.get().getPriority());
        if (layer.animationPlayer.getRealAnimation() == targetAnimation) {
            layer.animationPlayer.terminate(this.entitypatch);
            return true;
        }
        return false;
    }

    @Override
    public void setSoftPause(boolean paused) {
        this.iterAllLayers(layer -> {
            layer.paused = paused;
        });
    }

    @Override
    public void setHardPause(boolean paused) {
        this.hardPaused = paused;
    }

    @Override
    public void addLivingAnimation(LivingMotion livingMotion, AssetAccessor<? extends StaticAnimation> animation) {
        EntityState state;
        if (!AnimationManager.checkNonNull(animation)) {
            EpicFightMod.LOGGER.warn("Unable to put an empty animation for " + String.valueOf(livingMotion));
            return;
        }
        Layer.LayerType layerType = animation.get().getLayerType();
        boolean isBaseLayer = layerType == Layer.LayerType.BASE_LAYER;
        Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> storage = layerType == Layer.LayerType.BASE_LAYER ? this.livingAnimations : this.compositeLivingAnimations;
        LivingMotion compareMotion = layerType == Layer.LayerType.BASE_LAYER ? this.currentMotion : this.currentCompositeMotion;
        Layer.BaseLayer layer = layerType == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)animation.get().getPriority());
        storage.put(livingMotion, animation);
        if (livingMotion == compareMotion && !(state = this.getEntityState()).inaction()) {
            ((Layer)layer).playLivingAnimation(animation, this.entitypatch);
        }
        if (isBaseLayer) {
            animation.get().getProperty(ClientAnimationProperties.MULTILAYER_ANIMATION).ifPresent(multilayerAnimation -> {
                EntityState state;
                this.compositeLivingAnimations.put(livingMotion, (AssetAccessor<? extends StaticAnimation>)multilayerAnimation);
                if (livingMotion == this.currentCompositeMotion && !(state = this.getEntityState()).inaction()) {
                    layer.playLivingAnimation((AssetAccessor<? extends StaticAnimation>)multilayerAnimation, this.entitypatch);
                }
            });
        }
    }

    public void setCurrentMotionsAsDefault() {
        this.defaultLivingAnimations.putAll(this.livingAnimations);
        this.defaultCompositeLivingAnimations.putAll(this.compositeLivingAnimations);
    }

    @Override
    public void resetLivingAnimations() {
        super.resetLivingAnimations();
        this.compositeLivingAnimations.clear();
        this.defaultLivingAnimations.forEach((key, val) -> this.addLivingAnimation((LivingMotion)key, (AssetAccessor<? extends StaticAnimation>)val));
        this.defaultCompositeLivingAnimations.forEach((key, val) -> this.addLivingAnimation((LivingMotion)key, (AssetAccessor<? extends StaticAnimation>)val));
    }

    public AssetAccessor<? extends StaticAnimation> getLivingMotion(LivingMotion motion) {
        return this.livingAnimations.getOrDefault(motion, (AssetAccessor)this.livingAnimations.get(LivingMotions.IDLE));
    }

    public AssetAccessor<? extends StaticAnimation> getCompositeLivingMotion(LivingMotion motion) {
        return this.compositeLivingAnimations.get(motion);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.setCurrentMotionsAsDefault();
        AssetAccessor idleMotion = (AssetAccessor)this.livingAnimations.get(this.currentMotion);
        this.baseLayer.playAnimationInstantly(idleMotion, this.entitypatch);
    }

    @Override
    public void tick() {
        if (this.hardPaused) {
            return;
        }
        this.baseLayer.update(this.entitypatch);
        if (this.baseLayer.animationPlayer.isEnd() && this.baseLayer.nextAnimation == null && this.currentMotion != LivingMotions.DEATH) {
            this.entitypatch.updateMotion(false);
            if (this.compositeLivingAnimations.containsKey(this.entitypatch.currentCompositeMotion)) {
                this.playAnimation(this.getCompositeLivingMotion(this.entitypatch.currentCompositeMotion), 0.0f);
            }
            this.baseLayer.playAnimation(this.getLivingMotion(this.entitypatch.currentLivingMotion), this.entitypatch, 0.0f);
        } else {
            if (!this.compareCompositeMotion(this.entitypatch.currentCompositeMotion)) {
                AssetAccessor<? extends StaticAnimation> nextLivingAnimation;
                this.getLivingMotion(this.currentCompositeMotion).get().getProperty(ClientAnimationProperties.MULTILAYER_ANIMATION).ifPresent(multilayerAnimation -> {
                    if (!this.compositeLivingAnimations.containsKey(this.entitypatch.currentCompositeMotion)) {
                        this.getCompositeLayer(multilayerAnimation.get().getPriority()).off(this.entitypatch);
                    }
                });
                if (this.compositeLivingAnimations.containsKey(this.currentCompositeMotion) && ((nextLivingAnimation = this.getCompositeLivingMotion(this.entitypatch.currentCompositeMotion)) == null || nextLivingAnimation.get().getPriority() != this.getCompositeLivingMotion(this.currentCompositeMotion).get().getPriority())) {
                    this.getCompositeLayer(this.getCompositeLivingMotion(this.currentCompositeMotion).get().getPriority()).off(this.entitypatch);
                }
                if (this.compositeLivingAnimations.containsKey(this.entitypatch.currentCompositeMotion)) {
                    this.playAnimation(this.getCompositeLivingMotion(this.entitypatch.currentCompositeMotion), 0.0f);
                }
            }
            if (!this.compareMotion(this.entitypatch.currentLivingMotion) && this.entitypatch.currentLivingMotion != LivingMotions.DEATH && this.livingAnimations.containsKey(this.entitypatch.currentLivingMotion)) {
                this.baseLayer.playAnimation(this.getLivingMotion(this.entitypatch.currentLivingMotion), this.entitypatch, 0.0f);
            }
        }
        this.currentMotion = this.entitypatch.currentLivingMotion;
        this.currentCompositeMotion = this.entitypatch.currentCompositeMotion;
    }

    @Override
    public void playDeathAnimation() {
        if (!this.getPlayerFor(null).getAnimation().get().getProperty(AnimationProperty.ActionAnimationProperty.IS_DEATH_ANIMATION).orElse(false).booleanValue()) {
            this.playAnimation(this.livingAnimations.getOrDefault(LivingMotions.DEATH, Animations.EMPTY_ANIMATION), 0.0f);
            this.currentMotion = LivingMotions.DEATH;
        }
    }

    public AssetAccessor<? extends StaticAnimation> getJumpAnimation() {
        return (AssetAccessor)this.livingAnimations.get(LivingMotions.JUMP);
    }

    public Layer getCompositeLayer(Layer.Priority priority) {
        return this.baseLayer.compositeLayers.get((Object)priority);
    }

    public void renderDebuggingInfoForAllLayers(PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        this.iterAllLayers(layer -> {
            if (layer.isOff()) {
                return;
            }
            AnimationPlayer animPlayer = layer.animationPlayer;
            float playTime = Mth.lerp((float)partialTicks, (float)animPlayer.getPrevElapsedTime(), (float)animPlayer.getElapsedTime());
            animPlayer.getAnimation().get().renderDebugging(poseStack, buffer, this.entitypatch, playTime, partialTicks);
        });
    }

    public Collection<Layer> getAllLayers() {
        ArrayList layerList = Lists.newArrayList();
        layerList.add(this.baseLayer);
        layerList.addAll(this.baseLayer.compositeLayers.values());
        return layerList;
    }

    public void iterAllLayers(Consumer<Layer> task) {
        task.accept(this.baseLayer);
        this.baseLayer.compositeLayers.values().forEach(task);
    }

    public void iterVisibleLayers(Consumer<Layer> task) {
        task.accept(this.baseLayer);
        this.baseLayer.compositeLayers.values().stream().filter(layer -> layer.isDisabled() || layer.animationPlayer.isEmpty() || !layer.priority.isHigherOrEqual(this.baseLayer.baseLayerPriority)).forEach(task);
    }

    public boolean iterVisibleLayersUntilFalse(Function<Layer, Boolean> task) {
        Layer.Priority[] highers = this.baseLayer.baseLayerPriority.highers();
        for (int i = highers.length - 1; i >= 0; --i) {
            Layer layer = this.baseLayer.getLayer(highers[i]);
            if (layer.isDisabled() || layer.animationPlayer.isEmpty()) {
                if (highers[i] != this.baseLayer.baseLayerPriority) continue;
                return task.apply(this.baseLayer);
            }
            if (!task.apply(layer).booleanValue()) {
                return false;
            }
            if (highers[i] != this.baseLayer.baseLayerPriority) continue;
            return task.apply(this.baseLayer);
        }
        return true;
    }

    @Override
    public Pose getPose(float partialTicks) {
        return this.getPose(partialTicks, true);
    }

    public Pose getPose(float partialTicks, boolean useCurrentMotion) {
        Pose composedPose = new Pose();
        Pose baseLayerPose = this.baseLayer.getEnabledPose(this.entitypatch, useCurrentMotion, partialTicks);
        LinkedHashMap layerPoses = Maps.newLinkedHashMap();
        composedPose.load(baseLayerPose, Pose.LoadOperation.OVERWRITE);
        for (Layer.Priority priority : this.baseLayer.baseLayerPriority.highers()) {
            Layer compositeLayer = this.baseLayer.compositeLayers.get((Object)priority);
            if (compositeLayer.isDisabled() || compositeLayer.animationPlayer.isEmpty()) continue;
            Pose layerPose = compositeLayer.getEnabledPose(this.entitypatch, useCurrentMotion, partialTicks);
            layerPoses.put(priority, Pair.of(compositeLayer.animationPlayer.getAnimation(), (Object)layerPose));
            composedPose.load(layerPose, Pose.LoadOperation.OVERWRITE);
        }
        Joint rootJoint = this.entitypatch.getArmature().rootJoint;
        this.applyBindModifier(baseLayerPose, composedPose, rootJoint, layerPoses, useCurrentMotion);
        return composedPose;
    }

    public Pose getComposedLayerPoseBelow(Layer.Priority priorityLimit, float partialTicks) {
        Pose composedPose = this.baseLayer.getEnabledPose(this.entitypatch, true, partialTicks);
        Pose baseLayerPose = this.baseLayer.getEnabledPose(this.entitypatch, true, partialTicks);
        LinkedHashMap layerPoses = Maps.newLinkedHashMap();
        for (Layer.Priority priority : priorityLimit.lowers()) {
            Layer compositeLayer = this.baseLayer.compositeLayers.get((Object)priority);
            if (compositeLayer.isDisabled()) continue;
            Pose layerPose = compositeLayer.getEnabledPose(this.entitypatch, true, partialTicks);
            layerPoses.put(priority, Pair.of(compositeLayer.animationPlayer.getAnimation(), (Object)layerPose));
            composedPose.load(layerPose, Pose.LoadOperation.OVERWRITE);
        }
        if (!layerPoses.isEmpty()) {
            this.applyBindModifier(baseLayerPose, composedPose, this.entitypatch.getArmature().rootJoint, layerPoses, true);
        }
        return composedPose;
    }

    public void applyBindModifier(Pose basePose, Pose result, Joint joint, Map<Layer.Priority, Pair<AssetAccessor<? extends DynamicAnimation>, Pose>> poses, boolean useCurrentMotion) {
        ArrayList list = Lists.newArrayList(poses.keySet());
        Collections.reverse(list);
        for (Layer.Priority priority : list) {
            JointMask.JointMaskSet jointmaskset;
            JointMask.BindModifier bindModifier;
            AssetAccessor nowPlaying = (AssetAccessor)poses.get((Object)priority).getFirst();
            JointMaskEntry jointMaskEntry = ((DynamicAnimation)nowPlaying.get()).getJointMaskEntry(this.entitypatch, useCurrentMotion).orElse(null);
            if (jointMaskEntry == null) continue;
            LivingMotion livingMotion = this.getCompositeLayer(priority).getLivingMotion(this.entitypatch, useCurrentMotion);
            if (!((DynamicAnimation)nowPlaying.get()).hasTransformFor(joint.getName()) || jointMaskEntry.isMasked(livingMotion, joint.getName()) || (bindModifier = (jointmaskset = jointMaskEntry.getMask(livingMotion)).getBindModifier(joint.getName())) == null) continue;
            bindModifier.modify(this.entitypatch, basePose, result, livingMotion, jointMaskEntry, priority, joint, poses);
            break;
        }
        for (Joint subJoints : joint.getSubJoints()) {
            this.applyBindModifier(basePose, result, subJoints, poses, useCurrentMotion);
        }
    }

    public boolean compareMotion(LivingMotion motion) {
        return this.currentMotion.isSame(motion);
    }

    public boolean compareCompositeMotion(LivingMotion motion) {
        return this.currentCompositeMotion.isSame(motion);
    }

    public void forceResetBeforeAction(LivingMotion livingMotion, LivingMotion compositeLivingMotion) {
        if (!this.currentMotion.equals(livingMotion) && this.livingAnimations.containsKey(livingMotion)) {
            this.baseLayer.playAnimation(this.getLivingMotion(livingMotion), this.entitypatch, 0.0f);
        }
        this.entitypatch.currentLivingMotion = livingMotion;
        this.currentMotion = livingMotion;
        if (!this.currentCompositeMotion.equals(compositeLivingMotion)) {
            if (this.compositeLivingAnimations.containsKey(this.currentCompositeMotion)) {
                this.getCompositeLayer(this.getCompositeLivingMotion(this.currentCompositeMotion).get().getPriority()).off(this.entitypatch);
            }
            if (this.compositeLivingAnimations.containsKey(compositeLivingMotion)) {
                this.playAnimation(this.getCompositeLivingMotion(compositeLivingMotion), 0.0f);
            }
        }
        this.currentCompositeMotion = LivingMotions.NONE;
        this.entitypatch.currentCompositeMotion = LivingMotions.NONE;
    }

    public void resetMotion(boolean resetPrevMotion) {
        if (resetPrevMotion) {
            this.currentMotion = LivingMotions.IDLE;
        }
        this.entitypatch.currentLivingMotion = LivingMotions.IDLE;
    }

    public void resetCompositeMotion() {
        if (this.currentCompositeMotion != this.entitypatch.currentCompositeMotion && this.compositeLivingAnimations.containsKey(this.currentCompositeMotion)) {
            AssetAccessor<? extends StaticAnimation> currentPlaying = this.getCompositeLivingMotion(this.currentCompositeMotion);
            AssetAccessor<? extends StaticAnimation> resetPlaying = this.getCompositeLivingMotion(LivingMotions.IDLE);
            if (resetPlaying != null && currentPlaying != resetPlaying) {
                this.getCompositeLayer(currentPlaying.get().getPriority()).off(this.entitypatch);
                this.playAnimation(resetPlaying, 0.0f);
            }
        }
        this.currentCompositeMotion = LivingMotions.NONE;
        this.entitypatch.currentCompositeMotion = LivingMotions.NONE;
    }

    public void offAllLayers() {
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            layer.off(this.entitypatch);
        }
    }

    public boolean isAiming() {
        return this.currentCompositeMotion == LivingMotions.AIM;
    }

    @Override
    public void playShootingAnimation() {
        if (this.compositeLivingAnimations.containsKey(LivingMotions.SHOT)) {
            this.playAnimation(this.compositeLivingAnimations.get(LivingMotions.SHOT), 0.0f);
            this.entitypatch.currentCompositeMotion = LivingMotions.NONE;
            this.currentCompositeMotion = LivingMotions.NONE;
        }
    }

    @Override
    public boolean isPlaying(AssetAccessor<? extends DynamicAnimation> animation) {
        for (Layer layer : this.getAllLayers()) {
            if (!layer.animationPlayer.getRealAnimation().equals(animation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AnimationPlayer getPlayerFor(AssetAccessor<? extends DynamicAnimation> playingAnimation) {
        if (playingAnimation == null) {
            return this.baseLayer.animationPlayer;
        }
        DynamicAnimation animation = playingAnimation.get();
        if (animation instanceof StaticAnimation) {
            StaticAnimation staticAnimation = (StaticAnimation)animation;
            Layer.BaseLayer layer = staticAnimation.getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)staticAnimation.getPriority());
            return layer.animationPlayer;
        }
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            if (!layer.animationPlayer.getRealAnimation().equals(playingAnimation)) continue;
            return layer.animationPlayer;
        }
        return this.baseLayer.animationPlayer;
    }

    @Override
    public Optional<AnimationPlayer> getPlayer(AssetAccessor<? extends DynamicAnimation> playingAnimation) {
        DynamicAnimation animation = playingAnimation.get();
        if (animation instanceof StaticAnimation) {
            StaticAnimation staticAnimation = (StaticAnimation)animation;
            Layer.BaseLayer layer = staticAnimation.getLayerType() == Layer.LayerType.BASE_LAYER ? this.baseLayer : this.baseLayer.compositeLayers.get((Object)staticAnimation.getPriority());
            return Optional.ofNullable(layer.animationPlayer.getRealAnimation().equals(playingAnimation) ? layer.animationPlayer : null);
        }
        if (this.baseLayer.animationPlayer.getRealAnimation().equals(playingAnimation.get().getRealAnimation())) {
            return Optional.of(this.baseLayer.animationPlayer);
        }
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            if (!layer.animationPlayer.getRealAnimation().equals(playingAnimation.get().getRealAnimation())) continue;
            return Optional.of(layer.animationPlayer);
        }
        return Optional.empty();
    }

    public Layer.Priority getPriorityFor(AssetAccessor<? extends DynamicAnimation> playingAnimation) {
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            if (!layer.animationPlayer.getRealAnimation().equals(playingAnimation)) continue;
            return layer.priority;
        }
        return this.baseLayer.priority;
    }

    public LivingMotion currentMotion() {
        return this.currentMotion;
    }

    public LivingMotion currentCompositeMotion() {
        return this.currentCompositeMotion;
    }

    @Override
    public <T> Pair<AnimationPlayer, T> findFor(Class<T> animationType) {
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            if (!animationType.isAssignableFrom(layer.animationPlayer.getAnimation().getClass())) continue;
            return Pair.of((Object)layer.animationPlayer, layer.animationPlayer.getAnimation());
        }
        return animationType.isAssignableFrom(this.baseLayer.animationPlayer.getAnimation().getClass()) ? Pair.of((Object)this.baseLayer.animationPlayer, this.baseLayer.animationPlayer.getAnimation()) : null;
    }

    public LivingEntityPatch<?> getOwner() {
        return this.entitypatch;
    }

    @Override
    public EntityState getEntityState() {
        ParameterizedHashMap stateMap = new ParameterizedHashMap();
        for (Layer layer : this.baseLayer.compositeLayers.values()) {
            if (this.baseLayer.baseLayerPriority.isHigherThan(layer.priority)) continue;
            if (!layer.isOff()) {
                stateMap.putAll(layer.animationPlayer.getAnimation().get().getStatesMap(this.entitypatch, layer.animationPlayer.getElapsedTime()));
            }
            if (layer.priority != this.baseLayer.baseLayerPriority) continue;
            stateMap.putAll(this.baseLayer.animationPlayer.getAnimation().get().getStatesMap(this.entitypatch, this.baseLayer.animationPlayer.getElapsedTime()));
        }
        return new EntityState(stateMap);
    }
}

