/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public interface Mesh {
    public void initialize();

    public void draw(PoseStack var1, VertexConsumer var2, DrawingFunction var3, int var4, float var5, float var6, float var7, float var8, int var9);

    public void drawPosed(PoseStack var1, VertexConsumer var2, DrawingFunction var3, int var4, float var5, float var6, float var7, float var8, int var9, @Nullable Armature var10, OpenMatrix4f[] var11);

    default public void draw(PoseStack poseStack, MultiBufferSource bufferSources, RenderType renderType, DrawingFunction drawingFunction, int packedLight, float r, float g, float b, float a, int overlay, @Nullable Armature armature, OpenMatrix4f[] poses) {
        this.drawPosed(poseStack, bufferSources.getBuffer(EpicFightRenderTypes.getTriangulated(renderType)), drawingFunction, packedLight, r, g, b, a, overlay, armature, poses);
    }

    @OnlyIn(value=Dist.CLIENT)
    @FunctionalInterface
    public static interface DrawingFunction {
        public static final DrawingFunction NEW_ENTITY = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setColor(r, g, b, a).setUv(u, v).setOverlay(overlay).setLight(packedLight).setNormal(normX, normY, normZ);
        public static final DrawingFunction POSITION_TEX = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setUv(u, v);
        public static final DrawingFunction POSITION_TEX_COLOR_NORMAL = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setUv(u, v).setColor(r, g, b, a).setNormal(normX, normY, normZ);
        public static final DrawingFunction POSITION_TEX_COLOR_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setUv(u, v).setColor(r, g, b, a).setLight(packedLight);
        public static final DrawingFunction POSITION_COLOR_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setColor(r, g, b, a).setLight(packedLight);
        public static final DrawingFunction POSITION_COLOR_NORMAL = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setColor(r, g, b, a).setNormal(normX, normY, normZ);
        public static final DrawingFunction POSITION_COLOR_TEX_LIGHTMAP = (builder, posX, posY, posZ, normX, normY, normZ, packedLight, r, g, b, a, u, v, overlay) -> builder.addVertex(posX, posY, posZ).setColor(r, g, b, a).setUv(u, v).setLight(packedLight);

        public void draw(VertexConsumer var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, float var9, float var10, float var11, float var12, float var13, float var14, int var15);

        default public void putBulkData(PoseStack.Pose pose, BakedQuad bakedQuad, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, boolean readExistingColor) {
            DrawingFunction.putBulkDataWithDrawingFunction(this, vertexConsumer, pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, readExistingColor);
        }

        public static void putBulkDataWithDrawingFunction(DrawingFunction drawingFunction, VertexConsumer builder, PoseStack.Pose pPoseEntry, BakedQuad pQuad, float[] pColorMuls, float pRed, float pGreen, float pBlue, float alpha, int[] pCombinedLights, int pCombinedOverlay, boolean pMulColor) {
            float[] afloat = new float[]{pColorMuls[0], pColorMuls[1], pColorMuls[2], pColorMuls[3]};
            int[] aint1 = pQuad.getVertices();
            Vec3i vec3i = pQuad.getDirection().getNormal();
            Matrix4f matrix4f = pPoseEntry.pose();
            Vector3f vector3f = pPoseEntry.normal().transform(new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ()));
            int j = aint1.length / 8;
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
                IntBuffer intbuffer = bytebuffer.asIntBuffer();
                for (int k = 0; k < j; ++k) {
                    float f5;
                    float f4;
                    float f3;
                    intbuffer.clear();
                    intbuffer.put(aint1, k * 8, 8);
                    float f = bytebuffer.getFloat(0);
                    float f1 = bytebuffer.getFloat(4);
                    float f2 = bytebuffer.getFloat(8);
                    if (pMulColor) {
                        float f6 = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                        float f7 = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                        float f8 = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                        f3 = f6 * afloat[k] * pRed;
                        f4 = f7 * afloat[k] * pGreen;
                        f5 = f8 * afloat[k] * pBlue;
                    } else {
                        f3 = afloat[k] * pRed;
                        f4 = afloat[k] * pGreen;
                        f5 = afloat[k] * pBlue;
                    }
                    int l = DrawingFunction.applyBakedLighting(pCombinedLights[k], bytebuffer);
                    float f9 = bytebuffer.getFloat(16);
                    float f10 = bytebuffer.getFloat(20);
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f, f1, f2, 1.0f));
                    DrawingFunction.applyBakedNormals(vector3f, bytebuffer, pPoseEntry.normal());
                    float vertexAlpha = pMulColor ? alpha * (float)(bytebuffer.get(15) & 0xFF) / 255.0f : alpha;
                    drawingFunction.draw(builder, vector4f.x(), vector4f.y(), vector4f.z(), vector3f.x(), vector3f.y(), vector3f.z(), l, f3, f4, f5, vertexAlpha, f9, f10, pCombinedOverlay);
                }
            }
        }

        public static int applyBakedLighting(int packedLight, ByteBuffer data) {
            int bl = packedLight & 0xFFFF;
            int sl = packedLight >> 16 & 0xFFFF;
            int offset = IQuadTransformer.UV2 * 4;
            int blBaked = Short.toUnsignedInt(data.getShort(offset));
            int slBaked = Short.toUnsignedInt(data.getShort(offset + 2));
            bl = Math.max(bl, blBaked);
            sl = Math.max(sl, slBaked);
            return bl | sl << 16;
        }

        public static void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
            byte nx = data.get(28);
            byte ny = data.get(29);
            byte nz = data.get(30);
            if (nx != 0 || ny != 0 || nz != 0) {
                generated.set((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
                generated.mul((Matrix3fc)normalTransform);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record RenderProperties(ResourceLocation customTexturePath, Vec3f customColor, boolean isTransparent) {

        public static class Builder {
            protected String customTexturePath;
            protected Vec3f customColor = new Vec3f();
            protected boolean isTransparent;

            public Builder customTexturePath(String path) {
                this.customTexturePath = path;
                return this;
            }

            public Builder transparency(boolean isTransparent) {
                this.isTransparent = isTransparent;
                return this;
            }

            public Builder customColor(float r, float g, float b) {
                this.customColor.x = r;
                this.customColor.y = g;
                this.customColor.z = b;
                return this;
            }

            public RenderProperties build() {
                return new RenderProperties(this.customTexturePath == null ? null : ResourceLocation.parse((String)this.customTexturePath), this.customColor, this.isTransparent);
            }

            public static Builder create() {
                return new Builder();
            }
        }
    }
}

