/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.StaticMesh;
import yesman.epicfight.api.client.physics.cloth.ClothSimulatable;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.physics.SimulationProvider;

@OnlyIn(value=Dist.CLIENT)
public interface SoftBodyTranslatable
extends SimulationProvider<ClothSimulatable, ClothSimulator.ClothObject, ClothSimulator.ClothObjectBuilder, SoftBodyTranslatable> {
    public static final List<ClothSimulatable> TRACKING_SIMULATION_SUBJECTS = Lists.newArrayList();

    default public boolean canStartSoftBodySimulation() {
        return this.getSoftBodySimulationInfo() != null;
    }

    public void putSoftBodySimulationInfo(Map<String, ClothSimulationInfo> var1);

    public Map<String, ClothSimulationInfo> getSoftBodySimulationInfo();

    default public StaticMesh<?> getOriginalMesh() {
        SoftBodyTranslatable softBodyTranslatable = this;
        if (softBodyTranslatable instanceof Meshes.MeshAccessor) {
            Meshes.MeshAccessor meshAccessor = (Meshes.MeshAccessor)softBodyTranslatable;
            return (StaticMesh)meshAccessor.get();
        }
        return (StaticMesh)this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ClothSimulationInfo(float particleMass, float selfCollision, List<int[]> constraints, ClothSimulator.ClothObject.ClothPart.ConstraintType[] constraintTypes, float[] compliances, int[] particles, float[] weights, float[] rootDistance, int[] normalOffsetMapping) {
    }
}

