/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.PartEntity;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class Collider {
    protected final Vec3 modelCenter;
    protected final AABB outerAABB;
    protected Vec3 worldCenter;

    public Collider(Vec3 center, @Nullable AABB outerAABB) {
        this.modelCenter = center;
        this.outerAABB = outerAABB;
        this.worldCenter = new Vec3(0.0, 0.0, 0.0);
    }

    protected void transform(OpenMatrix4f mat) {
        this.worldCenter = OpenMatrix4f.transform(mat, this.modelCenter);
    }

    public List<Entity> updateAndSelectCollideEntity(LivingEntityPatch<?> entitypatch, AttackAnimation attackAnimation, float prevElapsedTime, float elapsedTime, Joint joint, float attackSpeed) {
        OpenMatrix4f transformMatrix;
        Armature armature = entitypatch.getArmature();
        if (armature.rootJoint.equals(joint)) {
            Pose rootPose = new Pose();
            rootPose.putJointData("Root", JointTransform.empty());
            attackAnimation.modifyPose(attackAnimation, rootPose, entitypatch, elapsedTime, 1.0f);
            transformMatrix = rootPose.orElseEmpty("Root").getAnimationBoundMatrix(armature.rootJoint, new OpenMatrix4f()).removeTranslation();
        } else {
            transformMatrix = armature.getBoundTransformFor(attackAnimation.getPoseByTime(entitypatch, elapsedTime, 1.0f), joint);
        }
        OpenMatrix4f toWorldCoord = OpenMatrix4f.createTranslation(-((float)((LivingEntity)entitypatch.getOriginal()).getX()), (float)((LivingEntity)entitypatch.getOriginal()).getY(), -((float)((LivingEntity)entitypatch.getOriginal()).getZ()));
        transformMatrix.mulFront(toWorldCoord.mulBack(entitypatch.getModelMatrix(1.0f)));
        this.transform(transformMatrix);
        return this.getCollideEntities((Entity)entitypatch.getOriginal());
    }

    public List<Entity> getCollideEntities(Entity entity) {
        List list = entity.level().getEntities(entity, this.getHitboxAABB(), e -> {
            PartEntity partEntity;
            if (e instanceof PartEntity && (partEntity = (PartEntity)e).getParent().is(entity)) {
                return false;
            }
            if (e.isSpectator()) {
                return false;
            }
            return this.isCollide((Entity)e);
        });
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawInternal(PoseStack var1, VertexConsumer var2, Armature var3, Joint var4, Pose var5, Pose var6, float var7, int var8);

    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        Pose currentPose;
        Pose prevPose;
        boolean attacking;
        Armature armature = entitypatch.getArmature();
        EntityState state = animation.getState(entitypatch, elapsedTime);
        EntityState prevState = animation.getState(entitypatch, prevElapsedTime);
        boolean bl = attacking = prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2;
        if (joint.getName().equals(armature.rootJoint.getName())) {
            prevPose = new Pose();
            currentPose = new Pose();
            prevPose.putJointData("Root", JointTransform.empty());
            currentPose.putJointData("Root", JointTransform.empty());
            animation.modifyPose(animation, prevPose, entitypatch, prevElapsedTime, 0.0f);
            animation.modifyPose(animation, currentPose, entitypatch, elapsedTime, 1.0f);
        } else {
            prevPose = animation.getPoseByTime(entitypatch, prevElapsedTime, 0.0f);
            currentPose = animation.getPoseByTime(entitypatch, elapsedTime, 1.0f);
        }
        this.drawInternal(poseStack, buffer.getBuffer(this.getRenderType()), armature, joint, prevPose, currentPose, partialTicks, attacking ? -65536 : -1);
    }

    public abstract Collider deepCopy();

    public abstract boolean isCollide(Entity var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract RenderType getRenderType();

    protected AABB getHitboxAABB() {
        return this.outerAABB.move(-this.worldCenter.x, this.worldCenter.y, -this.worldCenter.z);
    }

    public CompoundTag serialize(CompoundTag resultTag) {
        return resultTag;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " center: " + String.valueOf(this.modelCenter);
    }
}

