/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.neoevent.playerpatch;

import java.util.function.Consumer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public abstract class PlayerPatchEvent<T extends PlayerPatch<?>>
extends Event {
    protected final T playerpatch;

    public PlayerPatchEvent(T playerpatch) {
        this.playerpatch = playerpatch;
    }

    public T getPlayerPatch() {
        return this.playerpatch;
    }

    public void runOnClient(Consumer<AbstractClientPlayerPatch<?>> task) {
        if (((EntityPatch)this.playerpatch).isLogicalClient()) {
            task.accept((AbstractClientPlayerPatch)this.playerpatch);
        }
    }

    public void runOnLocalClient(Consumer<LocalPlayerPatch> task) {
        if (((Player)((EntityPatch)this.playerpatch).getOriginal()).isLocalPlayer()) {
            task.accept((LocalPlayerPatch)this.playerpatch);
        }
    }

    public void runOnServer(Consumer<ServerPlayerPatch> task) {
        if (!((EntityPatch)this.playerpatch).isLogicalClient()) {
            task.accept((ServerPlayerPatch)this.playerpatch);
        }
    }

    public static <T extends PlayerPatchEvent<?>> T postAndFireSkillListeners(T event) {
        ICancellableEvent canceclable;
        PlayerPatchEvent postedEvent = (PlayerPatchEvent)NeoForge.EVENT_BUS.post(event);
        if (postedEvent instanceof ICancellableEvent && (canceclable = (ICancellableEvent)postedEvent).isCanceled()) {
            return (T)((Object)postedEvent);
        }
        ((PlayerPatch)event.playerpatch).getPlayerSkills().fireSkillEvents("epicfight", postedEvent);
        return (T)((Object)postedEvent);
    }
}

