/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.skill.PlayerSkills;

@OnlyIn(value=Dist.CLIENT)
public class SkillEditScreen
extends Screen {
    private static final ResourceLocation SKILL_EDIT_UI = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/skill_edit.png");
    private static final MutableComponent NO_SKILLS = Component.translatable((String)"gui.epicfight.no_skills");
    private static final int MAX_SHOWING_BUTTONS = 6;
    private final Player player;
    private final PlayerSkills skills;
    private final Map<SkillSlot, SlotButton> slotButtons = Maps.newHashMap();
    private final List<LearnSkillButton> learnedSkillButtons = Lists.newArrayList();
    private int start;
    private SlotButton selectedSlotButton;

    public SkillEditScreen(Player player, PlayerSkills skills) {
        super((Component)Component.translatable((String)"gui.epicfight.skill_edit"));
        this.player = player;
        this.skills = skills;
    }

    public void init() {
        int i = this.width / 2 - 96;
        int j = this.height / 2 - 82;
        this.slotButtons.clear();
        this.learnedSkillButtons.clear();
        for (SkillSlot skillSlot : SkillSlot.ENUM_MANAGER.universalValues()) {
            if (!this.player.isCreative() && this.skills.getSkillContainersFor(skillSlot.category()).isEmpty() || !skillSlot.category().learnable()) continue;
            SlotButton slotButton = new SlotButton(i, j, 18, 18, skillSlot, this.skills.getSkillContainerFor(skillSlot).getSkill(), button -> {
                this.start = 0;
                for (Button button2 : this.learnedSkillButtons) {
                    this.children().remove(button2);
                }
                this.learnedSkillButtons.clear();
                int k = this.width / 2 - 69;
                MutableInt mutableInt = new MutableInt(this.height / 2 - 78);
                Stream<Skill> learnedSkillCollection = this.player.isCreative() ? SkillReloadListener.getSkills(skill -> skill.getCategory() == skillSlot.category()).stream() : this.skills.listAcquiredSkills().filter(skill -> skill.getCategory() == skillSlot.category());
                learnedSkillCollection.forEach(skill -> {
                    this.learnedSkillButtons.add(new LearnSkillButton(k, widgetHeight.intValue(), 147, 24, (Skill)skill, (Component)Component.translatable((String)skill.getTranslationKey()), pressedButton -> {
                        if (this.minecraft.player.experienceLevel >= skill.getRequiredXp() || this.minecraft.player.isCreative()) {
                            if (!this.canPress(pressedButton)) {
                                return;
                            }
                            this.skills.getSkillContainerFor(skillSlot).setSkill((Skill)skill);
                            EpicFightNetworkManager.sendToServer(new CPChangeSkill(skillSlot, skill.holder(), -1, !this.minecraft.player.isCreative()), new CustomPacketPayload[0]);
                            this.skills.addLearnedSkill((Skill)skill);
                            this.onClose();
                        }
                    }).setActive(this.skills.getSkillContainer((Skill)skill) == null));
                    widgetHeight.add(26);
                });
                for (Button button3 : this.learnedSkillButtons) {
                    this.addWidget((GuiEventListener)button3);
                }
                this.selectedSlotButton = (SlotButton)button;
            }, (Component)Component.translatable((String)SkillSlot.ENUM_MANAGER.toTranslated(skillSlot)));
            this.slotButtons.put(skillSlot, slotButton);
            this.addWidget((GuiEventListener)slotButton);
            j += 18;
        }
        if (this.selectedSlotButton != null) {
            this.selectedSlotButton = this.slotButtons.get(this.selectedSlotButton.slot);
            this.selectedSlotButton.onPress();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.canScroll()) {
            int scrollPosition = (int)(140.0f * ((float)this.start / (float)(this.learnedSkillButtons.size() - 6)));
            guiGraphics.blit(SKILL_EDIT_UI, this.width / 2 + 80, this.height / 2 - 80 + scrollPosition, 12, 15, 231.0f, 2.0f, 12, 15, 256, 256);
        }
        int maxShowingButtons = Math.min(this.learnedSkillButtons.size(), 6);
        for (int i = this.start; i < maxShowingButtons + this.start; ++i) {
            this.learnedSkillButtons.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        for (SlotButton sb : this.slotButtons.values()) {
            sb.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.slotButtons.isEmpty()) {
            int lineHeight = 0;
            for (FormattedCharSequence s : this.font.split((FormattedText)NO_SKILLS, 140)) {
                guiGraphics.drawString(this.font, s, this.width / 2 - 65, this.height / 2 - 72 + lineHeight, 0x303030, false);
                lineHeight += 10;
            }
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.blit(SKILL_EDIT_UI, this.width / 2 - 104, this.height / 2 - 100, 0, 0, 208, 200);
    }

    private boolean canScroll() {
        return this.learnedSkillButtons.size() > 6;
    }

    private boolean canPress(Button button) {
        int buttonOrder = this.learnedSkillButtons.indexOf(button);
        return buttonOrder >= this.start && buttonOrder <= this.start + 6;
    }

    public boolean mouseScrolled(double x, double y, double xScroll, double yScroll) {
        if (!this.canScroll()) {
            return false;
        }
        if (yScroll > 0.0) {
            if (this.start > 0) {
                --this.start;
                for (Button button : this.learnedSkillButtons) {
                    button.setY(button.getY() + 26);
                }
                return true;
            }
        } else if (this.start < this.learnedSkillButtons.size() - 6) {
            ++this.start;
            for (Button button : this.learnedSkillButtons) {
                button.setY(button.getY() - 26);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    class SlotButton
    extends Button {
        private final Skill iconSkill;
        private final SkillSlot slot;

        public SlotButton(int x, int y, int width, int height, SkillSlot slot, Skill skill, Button.OnPress pressedAction, Component tooltipMessage) {
            super(x, y, width, height, (Component)Component.empty(), pressedAction, Button.DEFAULT_NARRATION);
            this.iconSkill = skill;
            this.slot = slot;
            this.setTooltip(Tooltip.create((Component)tooltipMessage));
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int y = this.isHovered || SkillEditScreen.this.selectedSlotButton == this ? 35 : 17;
            guiGraphics.blit(SKILL_EDIT_UI, this.getX(), this.getY(), 237, y, this.width, this.height);
            if (this.iconSkill != null) {
                RenderSystem.enableBlend();
                guiGraphics.blit(this.iconSkill.getSkillTexture(), this.getX() + 1, this.getY() + 1, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class LearnSkillButton
    extends Button {
        private final Skill skill;

        public LearnSkillButton(int x, int y, int width, int height, Skill skill, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.DEFAULT_NARRATION);
            this.skill = skill;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int texY = this.isHovered || !this.active ? 224 : 200;
            guiGraphics.blit(SKILL_EDIT_UI, this.getX(), this.getY(), 0, texY, this.width, this.height);
            RenderSystem.enableBlend();
            guiGraphics.blit(this.skill.getSkillTexture(), this.getX() + 5, this.getY() + 4, 16, 16, 0.0f, 0.0f, 128, 128, 128, 128);
            guiGraphics.drawString(SkillEditScreen.this.font, this.getMessage(), this.getX() + 26, this.getY() + 2, -1, false);
            if (this.active) {
                int color = ((SkillEditScreen)SkillEditScreen.this).minecraft.player.experienceLevel >= this.skill.getRequiredXp() || ((SkillEditScreen)SkillEditScreen.this).minecraft.player.isCreative() ? 8453920 : 0xFF6060;
                guiGraphics.drawString(SkillEditScreen.this.font, (Component)Component.translatable((String)"gui.epicfight.changing_cost", (Object[])new Object[]{this.skill.getRequiredXp()}), this.getX() + 70, this.getY() + 12, color, false);
            } else {
                guiGraphics.drawString(SkillEditScreen.this.font, (Component)Component.literal((String)SkillEditScreen.this.skills.getSkillContainer(this.skill).getSlot().toString().toLowerCase(Locale.ROOT)), this.getX() + 26, this.getY() + 12, 0xFF6060, false);
            }
        }

        public boolean mouseClicked(double x, double y, int pressType) {
            boolean flag;
            if (this.visible && pressType == 1 && (flag = this.clickedNoCountActive(x, y))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                SkillEditScreen.this.minecraft.setScreen((Screen)new SkillBookScreen(SkillEditScreen.this.player, this.skill, null, SkillEditScreen.this));
                return true;
            }
            return super.mouseClicked(x, y, pressType);
        }

        protected boolean clickedNoCountActive(double x, double y) {
            return this.visible && x >= (double)this.getX() && y >= (double)this.getY() && x < (double)(this.getX() + this.width) && y < (double)(this.getY() + this.height);
        }

        public LearnSkillButton setActive(boolean active) {
            this.active = active;
            return this;
        }
    }
}

