/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.skill.SkillContainer;

@OnlyIn(value=Dist.CLIENT)
public class SlotSelectScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/gui/screen/slot_select.png");
    private final SkillBookScreen parent;
    private final List<SkillContainer> containers;

    public SlotSelectScreen(Set<SkillContainer> containers, SkillBookScreen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        this.containers = containers.stream().sorted((c1, c2) -> {
            if (c1.getSlotId() > c2.getSlotId()) {
                return 1;
            }
            if (c1.getSlotId() < c2.getSlotId()) {
                return -1;
            }
            return 0;
        }).toList();
    }

    protected void init() {
        this.parent.init(this.minecraft, this.width, this.height);
        int k = this.width / 2 - 80;
        int l = this.height / 2 - 45;
        for (SkillContainer container : this.containers) {
            String slotName = container.getSlot().toString().toLowerCase(Locale.ROOT);
            String skillName = container.getSkill() == null ? "Empty" : Component.translatable((String)container.getSkill().getTranslationKey()).getString();
            SlotButton slotbutton = new SlotButton(k, l, 167, 17, (Component)Component.literal((String)(slotName + ": " + skillName)), button -> {
                this.parent.acquireSkillTo(container);
                if (Minecraft.getInstance().screen == this) {
                    this.onClose();
                }
            });
            l += 22;
            this.addRenderableWidget((GuiEventListener)slotbutton);
        }
    }

    public void onClose() {
        if (this.parent != null) {
            this.minecraft.setScreen((Screen)this.parent);
        } else {
            super.onClose();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int posX = (this.width - 184) / 2;
        int posY = (this.height - 150) / 2;
        this.parent.render(guiGraphics, mouseX, mouseY, partialTick, true);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().translate(0.0f, 0.0f, 5000.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        guiGraphics.blit(BACKGROUND, posX, posY, 0, 0, 191, 154);
        MutableComponent component = Component.translatable((String)"gui.epicfight.select_slot_tooltip");
        int lineHeight = 0;
        for (FormattedCharSequence s : this.font.split((FormattedText)component, 250)) {
            guiGraphics.drawString(this.font, s, this.width / 2 - 84, this.height / 2 - 66 + lineHeight, 0x303030, false);
            lineHeight += 10;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SlotButton
    extends Button {
        public SlotButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction, Button.DEFAULT_NARRATION);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            int y = this.isHovered || !this.active ? 171 : 154;
            guiGraphics.blit(BACKGROUND, this.getX(), this.getY(), 0, y, this.width, this.height);
            guiGraphics.drawString(SlotSelectScreen.this.font, this.getMessage(), this.getX() + 3, this.getY() + 3, -1, false);
        }
    }
}

