/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class ImaginaryBlockRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();

    public void render(Camera camera, PoseStack poseStack, MultiBufferSource buffers, Level level, BlockPos bp, float r, float g, float b, float a) {
        BlockState bs = level.getBlockState(bp);
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(bs);
        RandomSource randomsource = RandomSource.create();
        long seed = bs.getSeed(bp);
        randomsource.setSeed(seed);
        poseStack.pushPose();
        Vec3 cameraPosition = camera.getPosition();
        poseStack.translate((double)bp.getX() - cameraPosition.x, (double)bp.getY() - cameraPosition.y, (double)bp.getZ() - cameraPosition.z);
        level.getLightEmission(bp);
        VertexConsumer buffer = buffers.getBuffer(RenderType.debugSectionQuads());
        BlockPos.MutableBlockPos mutablepos = bp.mutable();
        for (Direction d : DIRECTIONS) {
            List culledFaces = model.getQuads(bs, d, randomsource, ModelData.EMPTY, null);
            mutablepos.setWithOffset((Vec3i)bp, d);
            if (!Block.shouldRenderFace((BlockState)bs, (BlockGetter)level, (BlockPos)bp, (Direction)d, (BlockPos)mutablepos)) continue;
            this.renderPreviewBlocks(poseStack, buffer, culledFaces);
        }
        this.renderPreviewBlocks(poseStack, buffer, model.getQuads(bs, null, randomsource, ModelData.EMPTY, null));
        poseStack.popPose();
        ((MultiBufferSource.BufferSource)buffers).endBatch();
    }

    private void renderPreviewBlocks(PoseStack poseStack, VertexConsumer consumer, List<BakedQuad> quads) {
        for (BakedQuad bakedquad : quads) {
            int[] vertices = bakedquad.getVertices();
            Matrix4f matrix4f = poseStack.last().pose();
            MemoryStack memorystack = MemoryStack.stackPush();
            try {
                ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
                IntBuffer intbuffer = bytebuffer.asIntBuffer();
                for (int k = 0; k < vertices.length / 8; ++k) {
                    intbuffer.clear();
                    intbuffer.put(vertices, k * 8, 8);
                    float f = bytebuffer.getFloat(0);
                    float f1 = bytebuffer.getFloat(4);
                    float f2 = bytebuffer.getFloat(8);
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f, f1, f2, 1.0f));
                    consumer.addVertex(vector4f.x(), vector4f.y(), vector4f.z());
                    consumer.setColor(255, 255, 255, 44);
                }
            }
            finally {
                if (memorystack == null) continue;
                memorystack.close();
            }
        }
    }
}

