/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPAnimatorControl;
import yesman.epicfight.network.client.CPChangePlayerMode;
import yesman.epicfight.network.client.CPModifyEntityModelYRot;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.network.client.CPSetStamina;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.registry.entries.EpicFightDataComponentTypes;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

@OnlyIn(value=Dist.CLIENT)
public class LocalPlayerPatch
extends AbstractClientPlayerPatch<LocalPlayer> {
    private Minecraft minecraft;
    private LivingEntity rayTarget;
    private boolean targetLockedOn;
    private int chargingTicksO;
    private float lockOnXRot;
    private float lockOnXRotO;
    private float lockOnYRot;
    private float lockOnYRotO;
    private float fpvXRotO;
    private float fpvXRot;
    private float fpvYRotO;
    private float fpvYRot;
    private int fpvLerpTick;
    private FirstPersonLayer firstPersonLayer = new FirstPersonLayer();
    private AnimationSubFileReader.PovSettings povSettings;

    public LocalPlayerPatch(LocalPlayer entity) {
        super(entity);
        this.minecraft = Minecraft.getInstance();
    }

    public void onRespawnLocalPlayer(ClientPlayerNetworkEvent.Clone event) {
        this.onJoinWorld(event.getNewPlayer(), new EntityJoinLevelEvent((Entity)event.getNewPlayer(), event.getNewPlayer().level()));
    }

    private EntityHitResult pickEntity() {
        double distance = ((LocalPlayer)this.original).blockInteractionRange() * 2.0;
        double entityReach = ((LocalPlayer)this.original).entityInteractionRange() * 2.0;
        double pickRange = Math.max(distance, entityReach);
        Vec3 vec3 = ((LocalPlayer)this.original).getEyePosition(1.0f);
        Vec3 vec31 = ((LocalPlayer)this.original).getViewVector(1.0f);
        Vec3 vec32 = vec3.add(vec31.x * pickRange, vec31.y * pickRange, vec31.z * pickRange);
        BlockHitResult blockHitResulst = ((LocalPlayer)this.getOriginal()).level().clip(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.original));
        if (blockHitResulst.getType() != HitResult.Type.MISS) {
            pickRange = blockHitResulst.getLocation().distanceToSqr(vec3);
        }
        AABB aabb = ((LocalPlayer)this.original).getBoundingBox().expandTowards(vec31.scale(distance)).inflate(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)this.original, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, p_234237_ -> !p_234237_.isSpectator() && p_234237_.isPickable(), (double)pickRange);
        return entityhitresult;
    }

    @Override
    public void preTick(EntityTickEvent.Pre event) {
        this.chargingTicksO = this.isHoldingAny() ? this.getChargingTicks() : 0;
        super.preTick(event);
    }

    @Override
    public void preTickClient(EntityTickEvent.Pre event) {
        Entity hit;
        super.preTickClient(event);
        EntityHitResult cameraHitResult = this.pickEntity();
        if (cameraHitResult != null && (hit = cameraHitResult.getEntity()) != this.rayTarget && hit != this.original) {
            if (hit instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)hit;
                if (!(hit instanceof ArmorStand) && !this.targetLockedOn) {
                    this.rayTarget = livingentity;
                }
            } else if (hit instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)hit;
                Entity parent = partEntity.getParent();
                if (parent instanceof LivingEntity) {
                    LivingEntity parentLivingEntity = (LivingEntity)parent;
                    if (!this.targetLockedOn) {
                        this.rayTarget = parentLivingEntity;
                    }
                }
            } else {
                this.rayTarget = null;
            }
            if (this.rayTarget != null) {
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(this.getTarget().getId()), new CustomPacketPayload[0]);
            }
        }
        this.lockOnXRotO = this.lockOnXRot;
        this.lockOnYRotO = this.lockOnYRot;
        if (this.rayTarget != null) {
            if (this.targetLockedOn && !this.isLerpingFpv()) {
                Vec3 playerPosition = ((LocalPlayer)this.original).getEyePosition();
                Vec3 targetPosition = this.rayTarget.getEyePosition();
                Vec3 toTarget = targetPosition.subtract(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                CameraType cameraType = this.minecraft.options.getCameraType();
                float lockOnXRotDst = pitch + (cameraType.isFirstPerson() ? 0.0f : 30.0f);
                lockOnXRotDst = Mth.clamp((float)lockOnXRotDst, (float)0.0f, (float)60.0f);
                if (cameraType.isMirrored()) {
                    lockOnXRotDst = -lockOnXRotDst;
                }
                float lockOnYRotDst = yaw + (cameraType.isMirrored() ? 180.0f : 0.0f);
                float xDiff = Mth.wrapDegrees((float)(lockOnXRotDst - this.lockOnXRotO));
                float yDiff = Mth.wrapDegrees((float)(lockOnYRotDst - this.lockOnYRotO));
                float xLerp = Mth.clamp((float)(xDiff * 0.4f), (float)-30.0f, (float)30.0f);
                float yLerp = Mth.clamp((float)(yDiff * 0.4f), (float)-30.0f, (float)30.0f);
                this.lockOnXRot = this.lockOnXRotO + xLerp;
                this.lockOnYRot = this.lockOnYRotO + yLerp;
                if (!this.getEntityState().turningLocked() || this.getEntityState().lookTarget()) {
                    Vec3 playerEye = ((LocalPlayer)this.original).getEyePosition();
                    Vec3 targetEye = this.rayTarget.getEyePosition();
                    double eyeYDiff = Math.abs(playerEye.y - targetEye.y);
                    double dist = playerEye.distanceTo(targetEye);
                    double xDegree = Math.tan(eyeYDiff / dist) * 57.29577951308232;
                    xDegree = Mth.clamp((double)xDegree, (double)-60.0, (double)60.0);
                    ((LocalPlayer)this.original).setXRot((float)xDegree);
                    ((LocalPlayer)this.original).setYRot(lockOnYRotDst);
                }
            } else {
                this.lockOnXRot = ((LocalPlayer)this.original).getXRot();
                this.lockOnYRot = ((LocalPlayer)this.original).getYRot();
            }
            if (this.rayTarget.isRemoved() || this.rayTarget.isInvisibleTo((Player)this.original) || ((LocalPlayer)this.getOriginal()).distanceToSqr((Entity)this.rayTarget) > 400.0 || this.getAngleTo((Entity)this.rayTarget) > 80.0 && !this.targetLockedOn) {
                if (this.targetLockedOn) {
                    ((LocalPlayer)this.original).setXRot(this.lockOnXRot);
                    ((LocalPlayer)this.original).setYRot(this.lockOnYRot);
                    this.targetLockedOn = false;
                }
                this.rayTarget = null;
                EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(-1), new CustomPacketPayload[0]);
            }
        } else {
            this.lockOnXRot = ((LocalPlayer)this.original).getXRot();
            this.lockOnYRot = ((LocalPlayer)this.original).getYRot();
            this.targetLockedOn = false;
        }
        CapabilityItem mainhandItemCap = this.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandItemCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        CapabilityItem.ZoomInType rangeWeaponZoomInType = mainhandItemCap.isEmpty() || mainhandItemCap.getZoomInType() == CapabilityItem.ZoomInType.NONE ? offhandItemCap.getZoomInType() : mainhandItemCap.getZoomInType();
        switch (rangeWeaponZoomInType) {
            case ALWAYS: {
                RenderEngine.getInstance().zoomIn();
                break;
            }
            case USE_TICK: {
                if (((LocalPlayer)this.original).getUseItemRemainingTicks() > 0) {
                    RenderEngine.getInstance().zoomIn();
                    break;
                }
                RenderEngine.getInstance().zoomOut(8);
                break;
            }
            case AIMING: {
                if (this.getClientAnimator().isAiming()) {
                    RenderEngine.getInstance().zoomIn();
                    break;
                }
                RenderEngine.getInstance().zoomOut(8);
                break;
            }
            case CUSTOM: {
                break;
            }
            default: {
                RenderEngine.getInstance().zoomOut(0);
            }
        }
    }

    @Override
    public void postTickClient(EntityTickEvent.Post event) {
        boolean isLerping;
        AssetAccessor<? extends StaticAnimation> currentPlaying = this.firstPersonLayer.animationPlayer.getRealAnimation();
        boolean noPovAnimation = this.getClientAnimator().iterVisibleLayersUntilFalse(layer -> {
            if (layer.isOff()) {
                return true;
            }
            Optional<DirectStaticAnimation> optPovAnimation = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_ANIMATION);
            Optional<AnimationSubFileReader.PovSettings> optPovSettings = layer.animationPlayer.getRealAnimation().get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            optPovAnimation.ifPresent(povAnimation -> {
                if (!povAnimation.equals(currentPlaying.get())) {
                    this.firstPersonLayer.playAnimation((AssetAccessor<? extends StaticAnimation>)povAnimation, layer.animationPlayer.getRealAnimation(), this, 0.0f);
                    this.povSettings = (AnimationSubFileReader.PovSettings)optPovSettings.get();
                }
            });
            return !optPovAnimation.isPresent();
        });
        if (noPovAnimation && !currentPlaying.equals(Animations.EMPTY_ANIMATION)) {
            this.firstPersonLayer.off();
        }
        this.firstPersonLayer.update(this);
        if (this.firstPersonLayer.animationPlayer.getAnimation().equals(Animations.EMPTY_ANIMATION)) {
            this.povSettings = null;
        }
        if (isLerping = this.isLerpingFpv()) {
            --this.fpvLerpTick;
        }
        if (isLerping && !this.isLerpingFpv()) {
            ((LocalPlayer)this.original).setXRot(this.fpvXRot);
            ((LocalPlayer)this.original).setYRot(this.fpvYRot);
        }
    }

    @Override
    public boolean overrideRender() {
        if (((LocalPlayer)this.original).is((Entity)this.minecraft.player) && this.minecraft.options.getCameraType().isFirstPerson() && !ClientConfig.enableAnimatedFirstPersonModel) {
            return false;
        }
        return super.overrideRender();
    }

    @Override
    public LivingEntity getTarget() {
        return this.rayTarget;
    }

    @Override
    public void toVanillaMode(boolean synchronize) {
        RenderEngine.getInstance().battleModeHUD.slideDown();
        if (this.playerMode != PlayerPatch.PlayerMode.VANILLA) {
            if (ClientConfig.authSwitchCamera) {
                this.minecraft.options.setCameraType(CameraType.FIRST_PERSON);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.VANILLA), new CustomPacketPayload[0]);
            }
        }
        super.toVanillaMode(synchronize);
    }

    @Override
    public void toEpicFightMode(boolean synchronize) {
        RenderEngine.getInstance().battleModeHUD.slideUp();
        if (this.playerMode != PlayerPatch.PlayerMode.EPICFIGHT) {
            if (ClientConfig.authSwitchCamera) {
                this.minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
            }
            if (synchronize) {
                EpicFightNetworkManager.sendToServer(new CPChangePlayerMode(PlayerPatch.PlayerMode.EPICFIGHT), new CustomPacketPayload[0]);
            }
        }
        super.toEpicFightMode(synchronize);
    }

    @Override
    public boolean isFirstPerson() {
        return this.minecraft.options.getCameraType() == CameraType.FIRST_PERSON;
    }

    @Override
    public boolean shouldBlockMoving() {
        return ControlEngine.isKeyDown(this.minecraft.options.keyDown);
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        if (!this.isLogicalClient()) {
            return false;
        }
        return actionAnimation.shouldPlayerMove(this);
    }

    public int getChargingTicksO() {
        return this.chargingTicksO;
    }

    public float getLerpedLockOnX(double partialTick) {
        return Mth.rotLerp((float)((float)partialTick), (float)this.lockOnXRotO, (float)this.lockOnXRot);
    }

    public float getLerpedLockOnY(double partialTick) {
        return Mth.rotLerp((float)((float)partialTick), (float)this.lockOnYRotO, (float)this.lockOnYRot);
    }

    @Override
    public Vec3 getViewVector(float partialTick) {
        return this.targetLockedOn ? ((LocalPlayer)this.original).calculateViewVector(((LocalPlayer)this.original).getXRot(), this.getLerpedLockOnY(partialTick)) : super.getViewVector(partialTick);
    }

    public boolean isTargetLockedOn() {
        return this.targetLockedOn;
    }

    public void setLockOn(boolean targetLockedOn) {
        if (this.targetLockedOn && this.rayTarget != null) {
            ((LocalPlayer)this.original).setXRot(this.lockOnXRot);
            ((LocalPlayer)this.original).setYRot(this.lockOnYRot);
        }
        this.targetLockedOn = targetLockedOn;
    }

    public void toggleLockOn() {
        this.setLockOn(!this.targetLockedOn);
    }

    public FirstPersonLayer getFirstPersonLayer() {
        return this.firstPersonLayer;
    }

    public AnimationSubFileReader.PovSettings getPovSettings() {
        return this.povSettings;
    }

    public boolean hasCameraAnimation() {
        return this.povSettings != null && this.povSettings.cameraTransform() != null;
    }

    @Override
    public void setStamina(float value) {
        EpicFightNetworkManager.sendToServer(new CPSetStamina(value, true), new CustomPacketPayload[0]);
    }

    @Override
    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
        ((LocalPlayer)this.original).setXRot(this.lockOnXRot);
        ((LocalPlayer)this.original).setYRot(this.lockOnYRot);
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(amount), new CustomPacketPayload[0]);
        }
    }

    public float getModelYRot() {
        return this.modelYRot;
    }

    public void setModelYRotInGui(float rotDeg) {
        this.useModelYRot = true;
        this.modelYRot = rotDeg;
    }

    public void disableModelYRotInGui(float originalDeg) {
        this.useModelYRot = false;
        this.modelYRot = originalDeg;
    }

    public void fixFpvRotation(float xRot, float yRot) {
        this.fpvXRot = Mth.wrapDegrees((float)xRot);
        this.fpvXRotO = Mth.wrapDegrees((float)((LocalPlayer)this.original).getXRot());
        this.fpvYRot = Mth.wrapDegrees((float)yRot);
        this.fpvYRotO = Mth.wrapDegrees((float)((LocalPlayer)this.original).getYRot());
        this.fpvLerpTick = 5;
    }

    public float getLerpedFpvXRot(float partialTicks) {
        float delta = (float)this.fpvLerpTick / 5.0f + (1.0f - partialTicks) * 0.2f;
        return this.isLerpingFpv() ? Mth.rotLerp((float)delta, (float)this.fpvXRot, (float)this.fpvXRotO) : ((LocalPlayer)this.original).getXRot();
    }

    public float getLerpedFpvYRot(float partialTicks) {
        float delta = (float)this.fpvLerpTick / 5.0f + (1.0f - partialTicks) * 0.2f;
        return this.isLerpingFpv() ? Mth.rotLerp((float)delta, (float)this.fpvYRot, (float)this.fpvYRotO) : ((LocalPlayer)this.original).getYRot();
    }

    public boolean isLerpingFpv() {
        return this.fpvLerpTick > -1;
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToServer(new CPModifyEntityModelYRot(0.0f, true), new CustomPacketPayload[0]);
        }
    }

    @Override
    public double checkXTurn(double xRot) {
        float xRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (xRot == 0.0) {
            return xRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.options.getCameraType().isFirstPerson() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && ((xRotDest = ((LocalPlayer)this.original).getXRot() + (float)xRot * 0.15f) <= viewLimit.xRotMin() || xRotDest >= viewLimit.xRotMax())) {
            return 0.0;
        }
        return xRot;
    }

    @Override
    public double checkYTurn(double yRot) {
        float yRotClamped;
        float yRotDest;
        AnimationSubFileReader.PovSettings.ViewLimit viewLimit;
        if (yRot == 0.0) {
            return yRot;
        }
        if (ClientConfig.enablePovAction && this.minecraft.options.getCameraType().isFirstPerson() && this.isEpicFightMode() && !this.getFirstPersonLayer().isOff() && (viewLimit = this.getPovSettings().viewLimit()) != null && (yRotDest = ((LocalPlayer)this.original).getYRot() + (float)yRot * 0.15f) != (yRotClamped = Mth.clamp((float)yRotDest, (float)(this.getYRot() + viewLimit.yRotMin()), (float)(this.getYRot() + viewLimit.yRotMax())))) {
            return 0.0;
        }
        return yRot;
    }

    @Override
    public void beginAction(ActionAnimation animation) {
        if (!this.useModelYRot || animation.getProperty(AnimationProperty.ActionAnimationProperty.SYNC_CAMERA).orElse(false).booleanValue()) {
            this.modelYRot = ((LocalPlayer)this.getOriginal()).getYRot();
        }
        if (this.targetLockedOn) {
            if (this.rayTarget != null && !this.rayTarget.isRemoved()) {
                Vec3 playerPosition = ((LocalPlayer)this.original).position();
                Vec3 targetPosition = this.rayTarget.position();
                Vec3 toTarget = targetPosition.subtract(playerPosition);
                float yaw = (float)MathUtils.getYRotOfVector(toTarget);
                float pitch = (float)MathUtils.getXRotOfVector(toTarget);
                ((LocalPlayer)this.original).setYRot(yaw);
                ((LocalPlayer)this.original).setXRot(pitch);
            } else {
                ((LocalPlayer)this.original).setYRot(this.lockOnYRot);
                ((LocalPlayer)this.original).setXRot(this.lockOnXRot);
            }
        }
    }

    @Override
    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.reserveAnimation(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.RESERVE, animation, 0.0f, false, false, false));
    }

    @Override
    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.playAnimationInstantly(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY_INSTANTLY, animation, 0.0f, false, false, false));
    }

    @Override
    public void playShootingAnimation() {
        this.animator.playShootingAnimation();
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.SHOT, Animations.EMPTY_ANIMATION, 0.0f, false, true, false));
    }

    @Override
    public void stopPlaying(AssetAccessor<? extends StaticAnimation> animation) {
        this.animator.stopPlaying(animation);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.STOP, animation, -1.0f, false, false, false));
    }

    @Override
    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, transitionTimeModifier, false, false, true));
    }

    @Override
    public void playAnimationInClientSide(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        this.animator.playAnimation(animation, transitionTimeModifier);
        this.handleAnimationPayloadSend(new CPAnimatorControl(AbstractAnimatorControl.Action.PLAY, animation, transitionTimeModifier, false, true, false));
    }

    @Override
    public void pauseAnimator(AbstractAnimatorControl.Action action, boolean pause) {
        super.pauseAnimator(action, pause);
        this.handleAnimationPayloadSend(new CPAnimatorControl(action, Animations.EMPTY_ANIMATION, 0.0f, pause, false, false));
    }

    private void handleAnimationPayloadSend(CPAnimatorControl payload) {
        if (payload.action().syncVariables()) {
            payload.animationVariables().addAll(((Animator)this.getAnimator()).getVariables().createPendingVariablesPayloads(payload.animation()));
        }
        EpicFightNetworkManager.sendToServer(payload, new CustomPacketPayload[0]);
    }

    @Override
    public void openSkillBook(ItemStack itemstack, InteractionHand hand) {
        if (itemstack.has(EpicFightDataComponentTypes.SKILL)) {
            Minecraft.getInstance().setScreen((Screen)new SkillBookScreen((Player)this.original, itemstack, hand));
        }
    }

    @Override
    public void resetHolding() {
        if (this.holdingSkill != null) {
            ControlEngine.getInstance().releaseAllServedKeys();
        }
        super.resetHolding();
    }

    public boolean canPlayAttackAnimation() {
        Entity hitEntity;
        if (this.minecraft.hitResult.getType() == HitResult.Type.ENTITY && !((hitEntity = ((EntityHitResult)this.minecraft.hitResult).getEntity()) instanceof LivingEntity) && !(hitEntity instanceof PartEntity)) {
            return false;
        }
        if (this.targetLockedOn) {
            return true;
        }
        if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).getMainHandItem().getItem())) {
            if (this.minecraft.hitResult.getType() == HitResult.Type.BLOCK && this.minecraft.level != null) {
                BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
                BlockState bs = this.minecraft.level.getBlockState(bp);
                return !((LocalPlayer)this.original).getMainHandItem().getItem().canAttackBlock(bs, ((LocalPlayer)this.original).level(), bp, (Player)this.original) || !((LocalPlayer)this.original).getMainHandItem().isCorrectToolForDrops(bs);
            }
        } else {
            return this.minecraft.hitResult.getType() != HitResult.Type.BLOCK;
        }
        return true;
    }

    public boolean shouldHighlightTarget(Entity entity) {
        if (!ClientConfig.enableTargetEntityGuide) {
            return false;
        }
        if (entity == this.rayTarget) {
            if (!EpicFightCapabilities.getUnparameterizedEntityPatch(entity, EntityPatch.class).map(entitypatch -> entitypatch.isOutlineVisible(this)).orElse(false).booleanValue()) {
                return false;
            }
            if (ClientConfig.combatPreferredItems.contains(((LocalPlayer)this.original).getMainHandItem().getItem())) {
                if (this.minecraft.hitResult.getType() == HitResult.Type.BLOCK && this.minecraft.level != null) {
                    BlockPos bp = ((BlockHitResult)this.minecraft.hitResult).getBlockPos();
                    BlockState bs = this.minecraft.level.getBlockState(bp);
                    return !((LocalPlayer)this.original).getMainHandItem().getItem().canAttackBlock(bs, ((LocalPlayer)this.original).level(), bp, (Player)this.original) || !((LocalPlayer)this.original).getMainHandItem().isCorrectToolForDrops(bs);
                }
                return true;
            }
            return this.minecraft.crosshairPickEntity == entity;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class FirstPersonLayer
    extends Layer {
        private TransformSheet linkCameraTransform;

        public FirstPersonLayer() {
            super(null);
            this.linkCameraTransform = new TransformSheet(List.of(new Keyframe(0.0f, JointTransform.empty()), new Keyframe(Float.MAX_VALUE, JointTransform.empty())));
        }

        public void playAnimation(AssetAccessor<? extends StaticAnimation> nextFirstPersonAnimation, AssetAccessor<? extends StaticAnimation> originalAnimation, LivingEntityPatch<?> entitypatch, float transitionTimeModifier) {
            boolean hasNextCameraAnimation;
            Optional<AnimationSubFileReader.PovSettings> povSettings = originalAnimation.get().getProperty(ClientAnimationProperties.POV_SETTINGS);
            boolean hasPrevCameraAnimation = LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null;
            boolean bl = hasNextCameraAnimation = povSettings.isPresent() && povSettings.get().cameraTransform() != null;
            if (hasPrevCameraAnimation || hasNextCameraAnimation) {
                if (hasPrevCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                } else {
                    this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(JointTransform.empty());
                }
                if (hasNextCameraAnimation) {
                    this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(povSettings.get().cameraTransform().getKeyframes()[0].transform());
                } else {
                    this.linkCameraTransform.getKeyframes()[1].transform().clearTransform();
                }
                this.linkCameraTransform.getKeyframes()[1].setTime(nextFirstPersonAnimation.get().getTransitionTime());
            }
            super.playAnimation(nextFirstPersonAnimation, entitypatch, transitionTimeModifier);
        }

        public void off() {
            if (LocalPlayerPatch.this.povSettings != null && LocalPlayerPatch.this.povSettings.cameraTransform() != null) {
                this.linkCameraTransform.getKeyframes()[0].transform().copyFrom(LocalPlayerPatch.this.povSettings.cameraTransform().getInterpolatedTransform(this.animationPlayer.getElapsedTime()));
                this.linkCameraTransform.getKeyframes()[1].transform().copyFrom(JointTransform.empty());
                this.linkCameraTransform.getKeyframes()[1].setTime(0.15f);
            }
            super.off(LocalPlayerPatch.this);
        }

        @Override
        protected Pose getCurrentPose(LivingEntityPatch<?> entitypatch) {
            return this.animationPlayer.isEmpty() ? super.getCurrentPose(entitypatch) : this.animationPlayer.getCurrentPose(entitypatch, 0.0f);
        }

        public TransformSheet getLinkCameraTransform() {
            return this.linkCameraTransform;
        }
    }
}

