/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.projectile.ThrownTridentPatch;

@Mixin(value={ThrownTridentRenderer.class})
public abstract class MixinThrownTridentRenderer
extends EntityRenderer<ThrownTrident> {
    protected MixinThrownTridentRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=0)}, method={"render(Lnet/minecraft/world/entity/projectile/ThrownTrident;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void epicfight_render(ThrownTrident tridentEntity, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource multiSourceBuffer, int packedLight, CallbackInfo info) {
        ThrownTridentPatch tridentPatch = EpicFightCapabilities.getEntityPatch((Entity)tridentEntity, ThrownTridentPatch.class);
        if (tridentPatch != null && tridentPatch.isInnateActivated()) {
            Entity owner = tridentEntity.getOwner();
            Vec3 toOwner = owner.position().subtract(tridentEntity.position());
            Vec3 toOwnerHorizontalNorm = owner.position().subtract(tridentEntity.position()).subtract(0.0, toOwner.y, 0.0).normalize();
            Vec3 toOwnerNorm = toOwner.normalize();
            Vec3 rotAxis = toOwnerHorizontalNorm.cross(toOwnerNorm).normalize();
            float deg = (float)(MathUtils.getAngleBetween(toOwnerNorm, toOwnerHorizontalNorm) * 57.29577951308232);
            poseStack.mulPose(QuaternionUtils.rotationDegrees(new Vector3f((float)rotAxis.x, (float)rotAxis.y, (float)rotAxis.z), deg));
            poseStack.mulPose(QuaternionUtils.XP.rotationDegrees(90.0f));
            poseStack.mulPose(QuaternionUtils.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)tridentEntity.xRotO, (float)tridentEntity.getXRot()) + 90.0f));
            poseStack.translate(0.0, -0.8, -0.0);
            tridentPatch.renderXRot = tridentEntity.getXRot();
            tridentPatch.renderXRotO = tridentEntity.xRotO;
            tridentPatch.renderYRot = tridentEntity.getYRot();
            tridentPatch.renderYRotO = tridentEntity.yRotO;
            tridentEntity.xRotO = -90.0f;
            tridentEntity.yRotO = 90.0f;
            tridentEntity.setXRot(-90.0f);
            tridentEntity.setYRot(90.0f);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"render(Lnet/minecraft/world/entity/projectile/ThrownTrident;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void epicfight_renderPost(ThrownTrident tridentEntity, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource multiSourceBuffer, int packedLight, CallbackInfo info) {
        ThrownTridentPatch tridentPatch = EpicFightCapabilities.getEntityPatch((Entity)tridentEntity, ThrownTridentPatch.class);
        if (tridentPatch != null && tridentPatch.isInnateActivated()) {
            tridentEntity.xRotO = tridentPatch.renderXRotO;
            tridentEntity.yRotO = tridentPatch.renderYRotO;
            tridentEntity.setXRot(tridentPatch.renderXRot);
            tridentEntity.setYRot(tridentPatch.renderYRot);
        }
    }
}

