/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.common;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.ComboAttackEvent;
import yesman.epicfight.api.neoevent.playerpatch.ComboCounterHandleEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillConsumeEvent;
import yesman.epicfight.api.neoevent.playerpatch.StartActionEvent;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AbstractAnimatorControl;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class ComboAttacks
extends Skill {
    public static final AnimationVariables.IndependentVariableKey<Boolean> COMBO = AnimationVariables.unsyncIndependent(animator -> false, false);

    public static SkillBuilder<?> createComboAttackBuilder() {
        return ((SkillBuilder)new SkillBuilder<SkillBuilder>(ComboAttacks::new).setCategory(SkillCategories.BASIC_ATTACK).setActivateType(Skill.ActivateType.ONE_SHOT)).setResource(Skill.Resource.NONE);
    }

    public static void setComboCounterWithEvent(ComboCounterHandleEvent.Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, AnimationManager.AnimationAccessor<? extends StaticAnimation> causalAnimation, int value) {
        int prevValue = container.getDataManager().getDataValue(EpicFightSkillDataKeys.COMBO_COUNTER);
        ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
        PlayerPatchEvent.postAndFireSkillListeners(comboResetEvent);
        container.getDataManager().setData(EpicFightSkillDataKeys.COMBO_COUNTER, comboResetEvent.getNextValue());
    }

    public ComboAttacks(SkillBuilder<?> builder) {
        super(builder);
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void actionEvent(StartActionEvent event, SkillContainer skillContainer) {
        event.runOnServer(serverplayerpatch -> {
            if (((StaticAnimation)event.getAnimation().get()).getProperty(AnimationProperty.ActionAnimationProperty.RESET_PLAYER_COMBO_COUNTER).orElse(true).booleanValue()) {
                CapabilityItem itemCapability = serverplayerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
                List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> comboAnimations = itemCapability.getAutoAttackMotion(skillContainer.getExecutor());
                if (comboAnimations == null) {
                    return;
                }
                Set attackMotionSet = Set.copyOf(comboAnimations.stream().collect(Collectors.toSet()));
                if (!attackMotionSet.contains(event.getAnimation()) && itemCapability.shouldCancelCombo((LivingEntityPatch<?>)serverplayerpatch)) {
                    ComboAttacks.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, serverplayerpatch, skillContainer, event.getAnimation(), 0);
                }
            }
        });
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        EntityState playerState = executor.getEntityState();
        Player player = (Player)executor.getOriginal();
        return !player.isSpectator() && !executor.isInAir() && playerState.canBasicAttack();
    }

    @Override
    public void executeOnServer(SkillContainer skillContainer, CompoundTag args) {
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        SkillConsumeEvent event = new SkillConsumeEvent(executor, this, this.resource, null);
        if (!PlayerPatchEvent.postAndFireSkillListeners(event).isCanceled()) {
            event.getResourceType().consumer.consume(skillContainer, executor, event.getAmount());
        }
        if (PlayerPatchEvent.postAndFireSkillListeners(new ComboAttackEvent(executor)).isCanceled()) {
            return;
        }
        CapabilityItem cap = executor.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        AnimationManager.AnimationAccessor<? extends AttackAnimation> attackMotion = null;
        ServerPlayer player = (ServerPlayer)executor.getOriginal();
        SkillDataManager dataManager = skillContainer.getDataManager();
        int comboCounter = dataManager.getDataValue(EpicFightSkillDataKeys.COMBO_COUNTER);
        if (player.isPassenger()) {
            PlayerRideableJumping ridable;
            Entity entity = player.getVehicle();
            if (entity instanceof PlayerRideableJumping && (ridable = (PlayerRideableJumping)entity).canJump() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                attackMotion = cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size());
                ++comboCounter;
            }
        } else {
            List<AnimationManager.AnimationAccessor<? extends AttackAnimation>> combo = cap.getAutoAttackMotion(executor);
            if (combo == null) {
                return;
            }
            int comboSize = combo.size();
            boolean dashAttack = player.isSprinting();
            comboCounter = dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2);
            attackMotion = combo.get(comboCounter);
            comboCounter = dashAttack ? 0 : comboCounter + 1;
        }
        ComboAttacks.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.ANOTHER_ACTION_ANIMATION, executor, skillContainer, attackMotion, comboCounter);
        if (attackMotion != null) {
            ((Animator)executor.getAnimator()).getVariables().put(COMBO, attackMotion, true);
            ((Animator)executor.getAnimator()).playAnimation(attackMotion, 0.0f);
            boolean stiffAttack = EpicFightGameRules.STIFF_COMBO_ATTACKS.getRuleValue(((ServerPlayer)executor.getOriginal()).level());
            SPAnimatorControl animatorControlPacket = stiffAttack ? new SPAnimatorControl(AbstractAnimatorControl.Action.PLAY, attackMotion, skillContainer.getExecutor(), 0.0f) : new SPAnimatorControl(AbstractAnimatorControl.Action.PLAY_CLIENT, attackMotion, skillContainer.getExecutor(), 0.0f, AbstractAnimatorControl.Layer.COMPOSITE_LAYER, AbstractAnimatorControl.Priority.HIGHEST);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(animatorControlPacket, player, new CustomPacketPayload[0]);
        }
        executor.updateEntityState();
    }

    @Override
    public void updateContainer(SkillContainer container) {
        container.runOnServer(serverplayerpatch -> {
            if (container.getExecutor().getTickSinceLastAction() > 16 && container.getDataManager().getDataValue(EpicFightSkillDataKeys.COMBO_COUNTER) > 0) {
                ComboAttacks.setComboCounterWithEvent(ComboCounterHandleEvent.Causal.TIME_EXPIRED, serverplayerpatch, container, null, 0);
            }
        });
    }
}

