/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.neoevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillCancelEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetSkillContainerValue;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.registry.entries.EpicFightSkills;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;

public class GuardSkill
extends Skill
implements HoldableSkill {
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions;
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions;
    protected float penalizer;

    public static Builder createGuardBuilder(Function<Builder, GuardSkill> constructor) {
        return (Builder)((Builder)((Builder)new Builder((Function<Builder, ? extends GuardSkill>)constructor).addGuardMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.SWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (item, player) -> Animations.UCHIGATANA_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.TWO_HAND ? Animations.SPEAR_GUARD_HIT : null).addGuardMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> item.getStyle((LivingEntityPatch<?>)player) == CapabilityItem.Styles.ONE_HAND ? Animations.SWORD_GUARD_HIT : Animations.SWORD_DUAL_GUARD_HIT).addGuardMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.LONGSWORD_GUARD_HIT).addGuardBreakMotion(CapabilityItem.WeaponCategories.AXE, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.GREATSWORD_GUARD_BREAK).addGuardBreakMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.SWORD, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).addGuardBreakMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.BIPED_COMMON_NEUTRALIZED).setCategory(SkillCategories.GUARD)).setActivateType(Skill.ActivateType.HELD)).setResource(Skill.Resource.STAMINA);
    }

    public GuardSkill(Builder builder) {
        super(builder);
        this.guardMotions = builder.guardMotions;
        this.advancedGuardMotions = builder.advancedGuardMotions;
        this.guardBreakMotions = builder.guardBreakMotions;
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.penalizer = parameters.getFloat("penalizer");
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    @OnlyIn(value=Dist.CLIENT)
    public void updatePlayerMotionEvent(UpdatePlayerMotionEvent.CompositeLayer event, SkillContainer container) {
        if (container.isActivated() && this.isHoldingWeaponAvailable(container.getExecutor(), container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND), BlockType.GUARD)) {
            event.setMotion(LivingMotions.BLOCK);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void dealDamageEvent(DealDamageEvent.Post event, SkillContainer skillContainer) {
        skillContainer.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY, Float.valueOf(0.0f));
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.CLIENT)
    public void movementInputUpdateEvent(MovementInputUpdateEvent event, SkillContainer container) {
        if (container.isActivated() && container.getExecutor().getHoldingSkill() == this) {
            ((Player)container.getExecutor().getOriginal()).setSprinting(false);
            ((LocalPlayer)container.getClientExecutor().getOriginal()).sprintTriggerTime = -1;
            ControlEngine.setKeyBind(Minecraft.getInstance().options.keySprint, false);
            event.getInput().forwardImpulse *= 0.5f;
            event.getInput().leftImpulse *= 0.5f;
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, priority=1)
    public void hurtEventPreEvent(TakeDamageEvent.Income event, SkillContainer container) {
        CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (container.isActivated() && ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingSkill() == this) {
            DamageSource damageSource = event.getDamageSource();
            boolean isFront = false;
            Vec3 sourceLocation = damageSource.getSourcePosition();
            if (sourceLocation != null) {
                Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getViewVector(1.0f);
                viewVector = viewVector.subtract(0.0, viewVector.y, 0.0).normalize();
                Vec3 toSourceLocation = sourceLocation.subtract(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).position()).normalize();
                if (toSourceLocation.dot(viewVector) > 0.0) {
                    isFront = true;
                }
            }
            if (isFront) {
                float impact = 0.5f;
                float knockback = 0.25f;
                DamageSource damageSource2 = event.getDamageSource();
                if (damageSource2 instanceof EpicFightDamageSource) {
                    EpicFightDamageSource epicfightDamageSource = (EpicFightDamageSource)damageSource2;
                    if (epicfightDamageSource.is(EpicFightDamageTypeTags.GUARD_PUNCTURE)) {
                        return;
                    }
                    impact = epicfightDamageSource.calculateImpact();
                    knockback += Math.min(impact * 0.1f, 1.0f);
                }
                this.guard(container, itemCapability, event, knockback, impact, false);
            }
        }
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Income event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource = event.getDamageSource();
        Entity offender = GuardSkill.getOffender(damageSource);
        if (offender != null && this.isBlockableSource(damageSource, advanced)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument(serverPlayer.serverLevel(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverPlayer, offender);
            if (offender instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)offender;
                float modifiedKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)((ServerLevel)livingEntity.level()), (ItemStack)livingEntity.getItemInHand(livingEntity.getUsedItemHand()), (Entity)livingEntity, (DamageSource)damageSource, (float)knockback);
                knockback = (modifiedKnockback - knockback) * 0.1f;
            }
            float penalty = container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY).floatValue() + this.getPenalizer(itemCapability);
            float consumeAmount = penalty * impact;
            boolean canAfford = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, consumeAmount);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(offender.position(), knockback);
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY, Float.valueOf(penalty));
            container.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY_RESTORE_COUNTER, ((ServerPlayer)container.getServerExecutor().getOriginal()).tickCount);
            BlockType blockType = canAfford ? BlockType.GUARD : BlockType.GUARD_BREAK;
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = this.getGuardMotion(container, (PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event, advanced);
        }
    }

    public void dealEvent(PlayerPatch<?> playerpatch, TakeDamageEvent.Income event, boolean advanced) {
        event.setCanceled(true);
        event.setResult(AttackResult.ResultType.BLOCKED);
        playerpatch.countHurtTime(event.getDamage());
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getDamageSource().getEntity(), LivingEntityPatch.class).ifPresent(attackerpatch -> attackerpatch.setLastAttackEntity((Entity)playerpatch.getOriginal()));
        EpicFightCapabilities.getParameterizedEntityPatch(event.getDamageSource().getDirectEntity(), LivingEntity.class, LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onAttackBlocked(event.getDamageSource(), playerpatch));
    }

    @Override
    public void cancelOnServer(SkillContainer container, CompoundTag arguments) {
        container.deactivate();
        container.getExecutor().resetHolding();
        PlayerPatchEvent.postAndFireSkillListeners(new SkillCancelEvent(container.getServerExecutor(), container));
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(SPSetSkillContainerValue.activate(container.getSlot(), false, ((Player)container.getExecutor().getOriginal()).getId()), container.getExecutor().getOriginal(), new CustomPacketPayload[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void cancelOnClient(SkillContainer container, CompoundTag arguments) {
        super.cancelOnClient(container, arguments);
        container.deactivate();
    }

    @Override
    public void startHolding(SkillContainer container) {
        container.activate();
        container.runOnServer(serverplayerpatch -> EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(SPSetSkillContainerValue.activate(container.getSlot(), true, ((ServerPlayer)serverplayerpatch.getOriginal()).getId()), serverplayerpatch.getOriginal(), new CustomPacketPayload[0]));
    }

    @Override
    public void holdTick(SkillContainer container) {
        container.runOnServer(serverplayerpatch -> {
            if (container.isActivated()) {
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY_RESTORE_COUNTER, ((ServerPlayer)container.getServerExecutor().getOriginal()).tickCount);
            }
        });
    }

    @Override
    public void resetHolding(SkillContainer container) {
        container.deactivate();
    }

    @Override
    public void onStopHolding(SkillContainer container, SPSkillFeedback feedback) {
        container.deactivate();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeyMapping() {
        return EpicFightKeyMappings.GUARD;
    }

    @Override
    public boolean canExecute(SkillContainer container) {
        return this.checkExecuteCondition(container) && this.isHoldingWeaponAvailable(container.getExecutor(), container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND), BlockType.GUARD);
    }

    protected float getPenalizer(CapabilityItem itemCapability) {
        return this.penalizer;
    }

    protected Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> getGuardMotionMap(BlockType blockType) {
        switch (blockType.ordinal()) {
            case 0: {
                return this.guardBreakMotions;
            }
            case 1: {
                return this.guardMotions;
            }
            case 2: {
                return this.advancedGuardMotions;
            }
        }
        throw new IllegalArgumentException("unsupported block type " + String.valueOf((Object)blockType));
    }

    public boolean isHoldingWeaponAvailable(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        AnimationManager.AnimationAccessor<? extends StaticAnimation> anim = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (anim != null) {
            return true;
        }
        Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = this.getGuardMotionMap(blockType);
        if (!guardMotions.containsKey(itemCapability.getWeaponCategory())) {
            return false;
        }
        Object motion = guardMotions.get(itemCapability.getWeaponCategory()).apply(itemCapability, playerpatch);
        return motion != null;
    }

    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, BlockType blockType) {
        AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        return (AnimationManager.AnimationAccessor)this.getGuardMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch);
    }

    @Override
    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        container.runOnServer(serverplayerpatch -> {
            if (!container.getExecutor().isHoldingSkill(this)) {
                int hitTick;
                float penalty = container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY).floatValue();
                if (penalty > 0.0f && ((Player)container.getExecutor().getOriginal()).tickCount - (hitTick = container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY_RESTORE_COUNTER).intValue()) > 40) {
                    container.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY, Float.valueOf(0.0f));
                }
            } else {
                container.getExecutor().resetActionTick();
            }
        });
    }

    @Override
    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.isEpicFightMode() && !executor.isInAir() && !executor.getEntityState().hurt() && executor.getEntityState().canUseSkill() && !executor.isHoldingAny();
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.is(EpicFightDamageTypeTags.UNBLOCKALBE) && !damageSource.is(DamageTypeTags.BYPASSES_ARMOR) && !damageSource.is(DamageTypeTags.IS_PROJECTILE) && !damageSource.is(DamageTypeTags.IS_EXPLOSION) && !damageSource.is(DamageTypes.MAGIC) && !damageSource.is(DamageTypeTags.IS_FIRE);
    }

    @Override
    public boolean shouldDraw(SkillContainer container) {
        return container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY).floatValue() > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        guiGraphics.blit(((GuardSkill)EpicFightSkills.GUARD.get()).getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.getFont(), String.format("x%.1f", container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY)), x, y + 6.0f, 0xFFFFFF, true);
    }

    public static Entity getOffender(DamageSource damageSource) {
        return damageSource.getDirectEntity() == null ? damageSource.getEntity() : damageSource.getDirectEntity();
    }

    @Override
    public Set<WeaponCategory> getAvailableWeaponCategories() {
        return this.guardMotions.keySet();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.translatable((String)"skill.epicfight.guard.consume.tooltip"), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    protected boolean isAdvancedGuard() {
        return false;
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardMotions = new HashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> advancedGuardMotions = new HashMap();
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?>> guardBreakMotions = new HashMap();

        public Builder(Function<Builder, ? extends GuardSkill> constructor) {
            super(constructor);
        }

        public Builder addGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> function) {
            this.guardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addAdvancedGuardMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, ?> function) {
            this.advancedGuardMotions.put(weaponCategory, function);
            return this;
        }

        public Builder addGuardBreakMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> function) {
            this.guardBreakMotions.put(weaponCategory, function);
            return this;
        }
    }

    public static enum BlockType {
        GUARD_BREAK,
        GUARD,
        ADVANCED_GUARD;

    }
}

