/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.DragonGroundBattlePhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedDragonPhase;
import yesman.epicfight.world.capabilities.entitypatch.boss.enderdragon.PatchedPhases;

public class DragonLandingPhase
extends PatchedDragonPhase {
    private final BlockPos[] landingCandidates = new BlockPos[3];
    private Vec3 landingPosition;
    private boolean actualLandingPhase;

    public DragonLandingPhase(EnderDragon enderdragon) {
        super(enderdragon);
        this.landingCandidates[0] = enderdragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(-3, 0, -11));
        this.landingCandidates[1] = enderdragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(17, 0, 0));
        this.landingCandidates[2] = enderdragon.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos(0, 0, 17));
    }

    public void begin() {
        this.actualLandingPhase = false;
        this.landingPosition = this.getFarthestLandingPosition();
        if (!this.dragonpatch.isLogicalClient()) {
            ((DragonGroundBattlePhase)((EnderDragon)this.dragonpatch.getOriginal()).getPhaseManager().getPhase(PatchedPhases.GROUND_BATTLE)).resetFlyCooldown();
        }
    }

    public Vec3 getFarthestLandingPosition() {
        double max = 0.0;
        Vec3 result = null;
        for (int i = 0; i < this.landingCandidates.length; ++i) {
            Vec3 vec3d = new Vec3((double)this.landingCandidates[i].getX(), (double)this.landingCandidates[i].getY(), (double)this.landingCandidates[i].getZ());
            double distanceSqr = vec3d.distanceToSqr(this.dragon.position());
            if (!(distanceSqr > max)) continue;
            max = distanceSqr;
            result = vec3d;
        }
        return result;
    }

    public void doServerTick() {
        double dx = this.landingPosition.x - this.dragon.getX();
        double dy = this.landingPosition.y - this.dragon.getY();
        double dz = this.landingPosition.z - this.dragon.getZ();
        double squaredD = dx * dx + dy * dy + dz * dz;
        double squaredHorizontalD = dx * dx + dz * dz;
        if (this.actualLandingPhase) {
            if (squaredHorizontalD < 50.0) {
                this.dragon.getPhaseManager().setPhase(PatchedPhases.GROUND_BATTLE);
            }
        } else {
            float f5 = this.getFlySpeed();
            double horizontalD = Math.sqrt(squaredHorizontalD);
            double yMove = dy;
            if (horizontalD > 0.0) {
                yMove = Mth.clamp((double)dy, (double)(-f5), (double)f5) * Mth.clamp((double)((Math.abs(dy) - 13.0) * 0.01), (double)0.01, (double)0.03);
            }
            this.dragon.setDeltaMovement(this.dragon.getDeltaMovement().add(0.0, yMove, 0.0));
            this.dragon.setYRot(Mth.wrapDegrees((float)this.dragon.getYRot()));
            Vec3 vec32 = this.landingPosition.subtract(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ()).normalize();
            Vec3 vec33 = new Vec3((double)Mth.sin((float)(this.dragon.getYRot() * ((float)Math.PI / 180))), this.dragon.getDeltaMovement().y, (double)(-Mth.cos((float)(this.dragon.getYRot() * ((float)Math.PI / 180))))).normalize();
            float f6 = Math.max(((float)vec33.dot(vec32) + 0.5f) / 1.5f, 0.0f);
            if (Math.abs(dx) > (double)1.0E-5f || Math.abs(dz) > (double)1.0E-5f) {
                double d5 = Mth.clamp((double)Mth.wrapDegrees((double)(180.0 - Mth.atan2((double)dx, (double)dz) * 57.2957763671875 - (double)this.dragon.getYRot())), (double)-50.0, (double)50.0);
                this.dragon.yRotA *= 0.8f;
                this.dragon.yRotA = (float)((double)this.dragon.yRotA + d5 * (double)this.getTurnSpeed());
                this.dragon.setYRot(this.dragon.getYRot() + this.dragon.yRotA * 0.1f);
            }
            float f18 = (float)(2.0 / (squaredD + 1.0));
            this.dragon.moveRelative(0.06f * (f6 * f18 + (1.0f - f18)), new Vec3(0.0, 0.0, -1.0));
            if (this.dragon.inWall) {
                this.dragon.move(MoverType.SELF, this.dragon.getDeltaMovement().scale((double)0.8f));
            } else {
                this.dragon.move(MoverType.SELF, this.dragon.getDeltaMovement());
            }
            Vec3 vec34 = this.dragon.getDeltaMovement().normalize();
            double d6 = 0.8 + 0.15 * (vec34.dot(vec33) + 1.0) / 2.0;
            this.dragon.setDeltaMovement(this.dragon.getDeltaMovement().multiply(d6, (double)0.91f, d6));
            if (squaredD < 400.0 && Math.abs(dy) < 14.0) {
                Vec3 vec3 = new Vec3(dx, 0.0, dz);
                Vec2 vec2 = new Vec2(0.0f, 180.0f + this.dragon.getYRot());
                if (vec3.normalize().dot(Vec3.directionFromRotation((Vec2)vec2)) > 0.95) {
                    this.dragonpatch.playAnimationSynchronized(Animations.DRAGON_FLY_TO_GROUND, 0.0f);
                    this.actualLandingPhase = true;
                }
            }
        }
    }

    public Vec3 getLandingPosition() {
        return this.landingPosition;
    }

    public EnderDragonPhase<? extends DragonPhaseInstance> getPhase() {
        return PatchedPhases.LANDING;
    }
}

