/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.neoevent.EntityRemoveEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.registry.entries.EpicFightMobEffects;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class EndermanPatch
extends MobPatch<EnderMan> {
    private static final AttributeModifier SPEED_MODIFIER_ON_RAGE = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"rage_speed_bonus"), 0.1, AttributeModifier.Operation.ADD_VALUE);
    private boolean onRage;
    private Goal normalAttacks;
    private Goal teleportAttacks;
    private Goal rageAttacks;
    private Goal rageTargeting;

    public EndermanPatch(EnderMan original) {
        super(original, Factions.ENDERMAN);
    }

    @Override
    public void onJoinWorld(EnderMan enderman, EntityJoinLevelEvent event) {
        if (enderman.level().dimension() == Level.END && EpicFightGameRules.NO_MOBS_IN_BOSSFIGHT.getRuleValue(enderman.level()).booleanValue() && enderman.position().horizontalDistanceSqr() < 40000.0) {
            event.setCanceled(true);
        }
        super.onJoinWorld(enderman, event);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.isRaging()) {
            SPEntityPairingPacket packet = new SPEntityPairingPacket(((EnderMan)this.original).getId(), EntityPairingPacketTypes.ENDERMAN_RAGE);
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer, new CustomPacketPayload[0]);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        if (packet.pairingPacketType() == EntityPairingPacketTypes.ENDERMAN_RAGE) {
            ClientAnimator animator = this.getClientAnimator();
            animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE);
            animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
            animator.setCurrentMotionsAsDefault();
        }
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.ENDERMAN, EpicFightAttributes.STUN_ARMOR, 8.0);
        event.add(EntityType.ENDERMAN, EpicFightAttributes.IMPACT, 1.8);
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN.build(this));
        this.teleportAttacks = new EndermanTeleportMove(this, MobCombatBehaviors.ENDERMAN_TELEPORT.build(this));
        this.rageAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN_RAGE.build(this));
        this.rageTargeting = new NearestAttackableTargetGoal((Mob)this.original, Player.class, true);
        ((EnderMan)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 0.75, false));
        if (this.isRaging()) {
            ((EnderMan)this.original).targetSelector.addGoal(3, this.rageTargeting);
            ((EnderMan)this.original).goalSelector.addGoal(1, this.rageAttacks);
        } else {
            ((EnderMan)this.original).goalSelector.addGoal(1, this.normalAttacks);
            ((EnderMan)this.original).goalSelector.addGoal(0, this.teleportAttacks);
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.ENDERMAN_DEATH);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_WALK);
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_IDLE);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void preTickServer(EntityTickEvent.Pre event) {
        super.preTickServer(event);
        if (this.isRaging() && !this.onRage && ((EnderMan)this.original).tickCount > 5) {
            this.toRaging();
        } else if (this.onRage && !this.isRaging()) {
            this.toNormal();
        }
    }

    @Override
    public void postTickClient(EntityTickEvent.Post event) {
        if (((EnderMan)this.original).getHealth() <= 0.0f) {
            ((EnderMan)this.original).setXRot(0.0f);
        }
        super.postTickClient(event);
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        super.poseTick(animation, pose, elapsedTime, partialTicks);
        if (this.isRaging() && pose.hasTransform("Head_Top")) {
            pose.orElseEmpty("Head_Top").frontResult(JointTransform.translation(new Vec3f(0.0f, 0.25f, 0.0f)), OpenMatrix4f::mul);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (!((EnderMan)this.original).level().isClientSide() && damageSource.getEntity() != null && !this.isRaging()) {
            EpicFightDamageSource extDamageSource = null;
            if (damageSource instanceof EpicFightDamageSource) {
                extDamageSource = (EpicFightDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != StunType.HOLD) {
                int percentage;
                int n = percentage = this.getServerAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation ? 10 : 3;
                if (((EnderMan)this.original).getRandom().nextInt(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!((EnderMan)this.original).teleport()) continue;
                        if (damageSource.getEntity() instanceof LivingEntity) {
                            ((EnderMan)this.original).setLastHurtByMob((LivingEntity)damageSource.getEntity());
                        }
                        if (this.state.inaction()) {
                            this.playAnimationSynchronized(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return AttackResult.blocked(amount);
                    }
                }
            }
        }
        return super.tryHurt(damageSource, amount);
    }

    public boolean isRaging() {
        return ((EnderMan)this.original).getHealth() / ((EnderMan)this.original).getMaxHealth() < 0.33f;
    }

    protected void toRaging() {
        this.onRage = true;
        this.playAnimationSynchronized(Animations.ENDERMAN_CONVERT_RAGE, 0.0f);
        if (!((EnderMan)this.original).isNoAi()) {
            ((EnderMan)this.original).goalSelector.removeGoal(this.normalAttacks);
            ((EnderMan)this.original).goalSelector.removeGoal(this.teleportAttacks);
            ((EnderMan)this.original).goalSelector.addGoal(1, this.rageAttacks);
            ((EnderMan)this.original).targetSelector.addGoal(3, this.rageTargeting);
            ((EnderMan)this.original).getEntityData().set(EnderMan.DATA_CREEPY, (Object)true);
            ((EnderMan)this.original).addEffect(new MobEffectInstance(EpicFightMobEffects.STUN_IMMUNITY, 120000));
            ((EnderMan)this.original).getAttribute(Attributes.MOVEMENT_SPEED).addTransientModifier(SPEED_MODIFIER_ON_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).getId(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original, new CustomPacketPayload[0]);
        }
    }

    protected void toNormal() {
        this.onRage = false;
        if (!((EnderMan)this.original).isNoAi()) {
            ((EnderMan)this.original).goalSelector.addGoal(1, this.normalAttacks);
            ((EnderMan)this.original).goalSelector.addGoal(0, this.teleportAttacks);
            ((EnderMan)this.original).goalSelector.removeGoal(this.rageAttacks);
            ((EnderMan)this.original).targetSelector.removeGoal(this.rageTargeting);
            if (((EnderMan)this.original).getTarget() == null) {
                ((EnderMan)this.original).getEntityData().set(EnderMan.DATA_CREEPY, (Object)false);
            }
            ((EnderMan)this.original).removeEffect(EpicFightMobEffects.STUN_IMMUNITY);
            ((EnderMan)this.original).getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_ON_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).getId(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original, new CustomPacketPayload[0]);
        }
    }

    @Override
    public void onRemoved(EntityRemoveEvent event) {
        if (event.getRemovalReason() == Entity.RemovalReason.KILLED && this.isLogicalClient()) {
            this.getLevel().playLocalSound(this.original, SoundEvents.ENDERMAN_TELEPORT, ((EnderMan)this.original).getSoundSource(), 1.0f, 1.0f);
            for (int i = 0; i < 100; ++i) {
                RandomSource rand = ((EnderMan)this.original).getRandom();
                Vec3f vec = new Vec3f(rand.nextInt(), rand.nextInt(), rand.nextInt());
                vec.normalize().scale(0.5f);
                Minecraft minecraft = Minecraft.getInstance();
                minecraft.particleEngine.createParticle((ParticleOptions)EpicFightParticles.ENDERMAN_DEATH_EMIT.get(), ((EnderMan)this.original).getX(), ((EnderMan)this.original).getY() + (double)(((EnderMan)this.original).getDimensions(net.minecraft.world.entity.Pose.STANDING).height() / 2.0f), ((EnderMan)this.original).getZ(), (double)vec.x, (double)vec.y, (double)vec.z);
            }
        }
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        switch (stunType) {
            case SHORT: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case LONG: {
                return Animations.ENDERMAN_HIT_LONG;
            }
            case HOLD: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
            case NEUTRALIZE: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
        }
        return null;
    }

    static class EndermanTeleportMove
    extends AnimatedAttackGoal<EndermanPatch> {
        private int waitingCounter;
        private int delayCounter;
        private CombatBehaviors.Behavior<EndermanPatch> move;

        public EndermanTeleportMove(EndermanPatch mobpatch, CombatBehaviors<EndermanPatch> mobAttacks) {
            super(mobpatch, mobAttacks);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean canUse() {
            this.combatBehaviors.tick();
            if (super.canUse()) {
                this.move = this.combatBehaviors.selectRandomBehaviorSeries();
                return this.move != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            boolean waitExpired;
            boolean bl = waitExpired = this.waitingCounter <= 100;
            if (!waitExpired) {
                this.waitingCounter = 500;
            }
            return this.checkTargetValid() && !((EndermanPatch)this.mobpatch).getEntityState().hurt() && !((EndermanPatch)this.mobpatch).getEntityState().inaction() && waitExpired;
        }

        public void start() {
            this.delayCounter = 20 + ((EnderMan)((EndermanPatch)this.mobpatch).getOriginal()).getRandom().nextInt(5);
            this.waitingCounter = 0;
        }

        public void stop() {
            this.move = null;
        }

        @Override
        public void tick() {
            Mob mob = (Mob)((EndermanPatch)this.mobpatch).getOriginal();
            LivingEntity target = mob.getTarget();
            mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !((EndermanPatch)this.mobpatch).getEntityState().inaction()) {
                Vec3f vec = new Vec3f((float)(mob.getX() - target.getX()), 0.0f, (float)(mob.getZ() - target.getZ()));
                vec.normalize().scale(1.414f);
                boolean flag = mob.randomTeleport(target.getX() + (double)vec.x, target.getY(), target.getZ() + (double)vec.z, false);
                if (flag) {
                    ((EndermanPatch)this.mobpatch).rotateTo((Entity)target, 360.0f, true);
                    this.move.execute((EndermanPatch)this.mobpatch);
                    mob.level().playSound(null, mob.xo, mob.yo, mob.zo, SoundEvents.ENDERMAN_TELEPORT, mob.getSoundSource(), 1.0f, 1.0f);
                    mob.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    this.waitingCounter = 0;
                } else {
                    ++this.waitingCounter;
                }
            }
        }
    }
}

