/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.mob.SkeletonPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class WitherSkeletonPatch<T extends PathfinderMob>
extends SkeletonPatch<T> {
    public WitherSkeletonPatch(T original) {
        super(original, Factions.WITHER);
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.WITHER_SKELETON, EpicFightAttributes.STUN_ARMOR, 6.0);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.CHASE, Animations.WITHER_SKELETON_CHASE), Pair.of((Object)LivingMotions.WALK, Animations.WITHER_SKELETON_WALK), Pair.of((Object)LivingMotions.IDLE, Animations.WITHER_SKELETON_IDLE))));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.SKELETON_SWORD));
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        OpenMatrix4f mat = super.getModelMatrix(partialTicks);
        return OpenMatrix4f.scale(new Vec3f(1.2f, 1.2f, 1.2f), mat, mat);
    }
}

