/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.item;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.server.SPDatapackSync;

public class ItemKeywordReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>> {
    private static final String DIRECTORY = "capabilities/weapons/item_keyword";
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<ResourceLocation, ItemRegex> REGEXES = new HashMap<ResourceLocation, ItemRegex>();
    private static final List<CompoundTag> COMPOUNDS = new ArrayList<CompoundTag>();

    public static void scanDirectory(ResourceManager pResourceManager, String pName, Gson pGson, Map<ResourceLocation, List<JsonElement>> pOutput) {
        FileToIdConverter filetoidconverter = FileToIdConverter.json((String)pName);
        for (Map.Entry entry : filetoidconverter.listMatchingResourceStacks(pResourceManager).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.fileToId(resourcelocation);
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)pGson, (Reader)reader, JsonElement.class);
                        List list = pOutput.computeIfAbsent(resourcelocation1, k -> new ArrayList());
                        list.add(jsonelement);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                    EpicFightMod.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonparseexception);
                }
            }
        }
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        ItemKeywordReloadListener.scanDirectory(pResourceManager, DIRECTORY, GSON, map);
        return map;
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> packEntry, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        REGEXES.clear();
        COMPOUNDS.clear();
        HashMap<ResourceLocation, List> regexMap = new HashMap<ResourceLocation, List>();
        packEntry.entrySet().stream().forEach(entry -> {
            for (JsonElement jsonelement : (List)entry.getValue()) {
                CompoundTag compound = ParseUtil.parseTagOrThrow(jsonelement);
                if (!compound.contains("regexes", 9)) {
                    throw new NoSuchElementException("No regexes provided");
                }
                List regexes = compound.getList("regexes", 8).stream().map(Tag::getAsString).collect(Collectors.toList());
                List list = regexMap.computeIfAbsent((ResourceLocation)entry.getKey(), k -> new ArrayList());
                list.addAll(regexes);
            }
        });
        regexMap.forEach((k, v) -> REGEXES.put((ResourceLocation)k, new ItemRegex((List<String>)v)));
        REGEXES.forEach((k, v) -> {
            CompoundTag compound = new CompoundTag();
            compound.putString("registry_name", k.toString());
            ListTag list = new ListTag();
            v.regexes().stream().map(StringTag::valueOf).forEach(arg_0 -> list.add(arg_0));
            compound.put("regexes", (Tag)list);
            COMPOUNDS.add(compound);
        });
    }

    public static Map<ResourceLocation, ItemRegex> getRegexes() {
        return ImmutableMap.copyOf(REGEXES);
    }

    public static Stream<CompoundTag> getCompounds() {
        return COMPOUNDS.stream();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientBoundSyncPacket(SPDatapackSync packet) {
        if (packet.packetType() == SPDatapackSync.PacketType.WEAPON_TYPE) {
            REGEXES.clear();
            for (CompoundTag tag : packet.tags()) {
                ResourceLocation id = ResourceLocation.parse((String)tag.getString("registry_name"));
                REGEXES.put(id, ItemRegex.deserialize(tag));
            }
        }
    }

    public record ItemRegex(List<String> regexes) {
        public static ItemRegex deserialize(CompoundTag compound) {
            if (!compound.contains("regexes", 9)) {
                throw new NoSuchElementException("No regexes provided");
            }
            List<String> regexes = compound.getList("regexes", 8).stream().map(Tag::getAsString).collect(Collectors.toList());
            return new ItemRegex(regexes);
        }

        public boolean matchesAny(String itemName) {
            for (String regex : this.regexes()) {
                if (!itemName.matches(regex)) continue;
                return true;
            }
            return false;
        }
    }
}

