/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.datastruct.TypeFlexibleHashMap;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MainFrameAnimation
extends StaticAnimation {
    public MainFrameAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends MainFrameAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, false, accessor, armature);
    }

    public MainFrameAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, false, path, armature);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        if (((Animator)entitypatch.getAnimator()).getPlayerFor(null).getAnimation().get() == this) {
            TypeFlexibleHashMap<EntityState.StateFactor<?>> stateMap = this.stateSpectrum.getStateMap(entitypatch, 0.0f);
            TypeFlexibleHashMap modifiedStateMap = new TypeFlexibleHashMap(false);
            stateMap.forEach((k, v) -> modifiedStateMap.put(k, this.getModifiedLinkState((EntityState.StateFactor<?>)k, v, entitypatch, 0.0f)));
            entitypatch.updateEntityState(new EntityState(modifiedStateMap));
        }
        if (entitypatch.isLogicalClient()) {
            entitypatch.updateMotion(false);
            this.getProperty(AnimationProperty.StaticAnimationProperty.RESET_LIVING_MOTION).ifPresentOrElse(livingMotion -> entitypatch.getClientAnimator().forceResetBeforeAction((LivingMotion)livingMotion, (LivingMotion)livingMotion), () -> {
                entitypatch.getClientAnimator().resetMotion(true);
                entitypatch.getClientAnimator().resetCompositeMotion();
            });
            entitypatch.getClientAnimator().getPlayerFor(this.getAccessor()).setReversed(false);
        }
        super.begin(entitypatch);
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            if (playerpatch.isLogicalClient()) {
                if (((Player)playerpatch.getOriginal()).m_7578_()) {
                    playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_CLIENT, new ActionEvent(playerpatch, this.getAccessor()));
                }
            } else {
                ActionEvent actionEvent = new ActionEvent(playerpatch, this.getAccessor());
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ACTION_EVENT_SERVER, actionEvent);
                if (actionEvent.shouldResetActionTick()) {
                    playerpatch.resetActionTick();
                }
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267771_(0.0f);
    }

    @Override
    public boolean isMainFrameAnimation() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.HIGHEST);
    }
}

