/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.datapack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.datapack.DatapackAttackAnimation;
import yesman.epicfight.api.animation.types.datapack.EditorAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;

@OnlyIn(value=Dist.CLIENT)
public class DatapackDashAttackAnimation
extends DatapackAttackAnimation {
    public DatapackDashAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, ListTag phases) {
        super(convertTime, path, armature, phases);
    }

    public DatapackDashAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    @Override
    public EditorAnimation readAnimationFromJson(JsonArray rawAnimationJson) {
        EditorAnimation fakeAnimation = new EditorAnimation(this.registryName().toString(), this.armature, this.clip, rawAnimationJson);
        fakeAnimation.setAnimationClass(EditorAnimation.AnimationType.DASH_ATTACK);
        fakeAnimation.setParameter("convertTime", Float.valueOf(this.transitionTime));
        fakeAnimation.setParameter("path", this.registryName().toString());
        fakeAnimation.setParameter("armature", this.armature);
        ListTag listTag = new ListTag();
        for (AttackAnimation.Phase phase : this.phases) {
            CompoundTag compTag = new CompoundTag();
            compTag.m_128350_("antic", phase.antic);
            compTag.m_128350_("preDelay", phase.preDelay);
            compTag.m_128350_("contact", phase.contact);
            compTag.m_128350_("recovery", phase.recovery);
            compTag.m_128359_("hand", phase.hand.toString());
            if (phase.colliders[0].getSecond() != null) {
                compTag.m_128365_("collider", (Tag)((Collider)phase.colliders[0].getSecond()).serialize(new CompoundTag()));
            }
            compTag.m_128359_("joint", this.armature.toString() + "." + ((Joint)phase.colliders[0].getFirst()).getName());
            listTag.add((Object)compTag);
        }
        fakeAnimation.setParameter("phases", listTag);
        this.getProperty(ClientAnimationProperties.TRAIL_EFFECT).ifPresent((? super T trailInfos) -> {
            JsonArray trailArray = new JsonArray();
            for (TrailInfo trailInfo : trailInfos) {
                JsonObject trailObj = new JsonObject();
                trailObj.addProperty("start_time", (Number)Float.valueOf(trailInfo.startTime()));
                trailObj.addProperty("end_time", (Number)Float.valueOf(trailInfo.endTime()));
                trailObj.addProperty("joint", trailInfo.joint());
                trailObj.addProperty("item_skin_hand", trailInfo.hand().toString());
                trailArray.add((JsonElement)trailObj);
            }
            fakeAnimation.getPropertiesJson().add("trail_effects", (JsonElement)trailArray);
            fakeAnimation.addProperty(ClientAnimationProperties.TRAIL_EFFECT, trailInfos);
        });
        this.fakeAnimation = fakeAnimation;
        return fakeAnimation;
    }
}

