/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.util.internal.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;

@OnlyIn(value=Dist.CLIENT)
public class WeaponAttributeScreen
extends Screen {
    private final Map<String, Condition.ParameterEditor> weaponAttributeEditors = Maps.newLinkedHashMap();
    private final Map<String, Condition.ParameterEditor> armorAttributeEditors = Maps.newLinkedHashMap();
    private final Screen parentScreen;
    private final DatapackEditScreen.ItemCapabilityTab.ItemType itemType;
    private Grid stylesGrid;
    private Grid attributesGrid;
    private final List<PackEntry<String, CompoundTag>> styles = Lists.newArrayList();
    private final CompoundTag rootTag;

    public WeaponAttributeScreen(Screen parentScreen, CompoundTag rootTag, DatapackEditScreen.ItemCapabilityTab.ItemType itemType) {
        super((Component)Component.m_237115_((String)"datapack_edit.item_capability.attributes"));
        this.itemType = itemType;
        this.parentScreen = parentScreen;
        this.rootTag = rootTag;
        this.f_96541_ = parentScreen.getMinecraft();
        this.f_96547_ = parentScreen.getMinecraft().f_91062_;
        ResizableEditBox impactEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"impact"), null, null);
        ResizableEditBox armorNegationEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"armor_negation"), null, null);
        ResizableEditBox maxStrikesEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"max_strikes"), null, null);
        ResizableEditBox damageBonusEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"damage_bonus"), null, null);
        ResizableEditBox speedBonusEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"speed_bonus"), null, null);
        ResizableEditBox stunArmorEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"stun_armor"), null, null);
        ResizableEditBox weightEditBox = new ResizableEditBox(this.f_96547_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"weight"), null, null);
        impactEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        armorNegationEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        maxStrikesEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
        damageBonusEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        speedBonusEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        stunArmorEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        weightEditBox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
        this.weaponAttributeEditors.put("armor_negation", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)armorNegationEditBox));
        this.weaponAttributeEditors.put("impact", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)impactEditBox));
        this.weaponAttributeEditors.put("max_strikes", Condition.ParameterEditor.of(value -> IntTag.m_128679_((int)ParseUtil.parseOrGet(value.toString(), Integer::parseInt, 0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)maxStrikesEditBox));
        this.weaponAttributeEditors.put("damage_bonus", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)damageBonusEditBox));
        this.weaponAttributeEditors.put("speed_bonus", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)speedBonusEditBox));
        this.armorAttributeEditors.put("stun_armor", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)stunArmorEditBox));
        this.armorAttributeEditors.put("weight", Condition.ParameterEditor.of(value -> DoubleTag.m_128500_((double)ParseUtil.parseOrGet(value.toString(), Double::parseDouble, 0.0)), tag -> ParseUtil.valueOfOmittingType(tag.m_7916_()), (AbstractWidget)weightEditBox));
        if (itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
            this.stylesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(20, 60).xy2(90, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_WIDTH).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).transparentBackground(false).rowpositionChanged((rowposition, values) -> {
                Grid.PackImporter packImporter = new Grid.PackImporter();
                for (Map.Entry entry : this.styles.get((int)rowposition.intValue()).getValue().f_128329_.entrySet()) {
                    Condition.ParameterEditor paramEditor = this.weaponAttributeEditors.get(entry.getKey());
                    packImporter.newRow().newValue("attribute", this.weaponAttributeEditors.get(entry.getKey())).newValue("amount", paramEditor == null ? "" : paramEditor.fromTag.apply((Tag)entry.getValue()));
                }
                this.attributesGrid._setActive(true);
                this.attributesGrid._setValue(packImporter);
            }).addColumn(Grid.combo("style", Style.ENUM_MANAGER.universalValues()).valueChanged(event -> this.styles.get(event.rowposition).setPackKey(ParseUtil.nullParam(event.postValue).toLowerCase(Locale.ROOT))).defaultVal(CapabilityItem.Styles.ONE_HAND)).pressAdd((grid, button) -> {
                this.styles.add(PackEntry.of("", CompoundTag::new));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "style");
            }).pressRemove((grid, button) -> {
                grid.removeRow(removedRow -> this.styles.remove(removedRow));
                if (grid.m_6702_().size() == 0) {
                    this.attributesGrid._setActive(false);
                }
            }).build();
            this.attributesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(120, 60).xy2(20, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).transparentBackground(false).addColumn(Grid.combo("attribute", List.copyOf(this.weaponAttributeEditors.values())).toDisplayText(editor -> ParseUtil.nullOrToString(editor, editor$1 -> ParseUtil.snakeToSpacedCamel(editor.editWidget.m_6035_().getString()))).valueChanged(event -> {
                CompoundTag attributesCompound = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                if (event.prevValue != null) {
                    attributesCompound.m_128473_(((Condition.ParameterEditor)event.prevValue).editWidget.m_6035_().getString());
                } else {
                    attributesCompound.m_128473_("");
                }
                attributesCompound.m_128359_(ParseUtil.nullParam(((Condition.ParameterEditor)event.postValue).editWidget.m_6035_().getString()), "");
            }).width(100)).addColumn(Grid.wildcard("amount").editWidgetProvider(row -> {
                Condition.ParameterEditor editor = (Condition.ParameterEditor)row.getValue("attribute");
                return editor == null ? null : editor.editWidget;
            }).valueChanged(event -> {
                CompoundTag attributesTag = this.styles.get(this.stylesGrid.getRowposition()).getValue();
                Condition.ParameterEditor editor = (Condition.ParameterEditor)event.grid.getValue(event.rowposition, "attribute");
                if (!StringUtil.isNullOrEmpty((String)ParseUtil.nullParam(event.postValue))) {
                    attributesTag.m_128365_(editor.editWidget.m_6035_().getString(), editor.toTag.apply(event.postValue));
                } else {
                    attributesTag.m_128473_(editor.editWidget.m_6035_().getString());
                }
            }).width(150)).pressAdd((grid, button) -> {
                this.styles.get(this.stylesGrid.getRowposition()).getValue().m_128365_("", (Tag)StringTag.m_129297_((String)""));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "attribute");
            }).pressRemove((grid, button) -> {
                this.styles.get(this.stylesGrid.getRowposition()).getValue().m_128473_(((Condition.ParameterEditor)grid.getValue((int)grid.getRowposition(), (String)"attribute")).editWidget.m_6035_().getString());
                grid.removeRow(removedRow -> {});
            }).build();
            Grid.PackImporter packImporter = new Grid.PackImporter();
            for (Map.Entry entry : rootTag.f_128329_.entrySet()) {
                this.styles.add(PackEntry.of((String)entry.getKey(), () -> (CompoundTag)entry.getValue()));
                packImporter.newRow();
                packImporter.newValue("style", Style.ENUM_MANAGER.get((String)entry.getKey()));
            }
            this.stylesGrid._setValue(packImporter);
            this.attributesGrid._setActive(false);
        } else if (itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.ARMOR) {
            this.styles.add(PackEntry.of("armor", CompoundTag::new));
            this.attributesGrid = Grid.builder(this, parentScreen.getMinecraft()).xy1(20, 60).xy2(20, 50).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(21).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).transparentBackground(false).addColumn(Grid.combo("attribute", List.copyOf(this.armorAttributeEditors.values())).toDisplayText(editor -> ParseUtil.nullOrToString(editor, editor$1 -> ParseUtil.snakeToSpacedCamel(editor.editWidget.m_6035_().getString()))).valueChanged(event -> {
                CompoundTag attributesCompound = this.styles.get(0).getValue();
                if (event.prevValue != null) {
                    attributesCompound.m_128473_(((Condition.ParameterEditor)event.prevValue).editWidget.m_6035_().getString());
                } else {
                    attributesCompound.m_128473_("");
                }
                attributesCompound.m_128359_(ParseUtil.nullParam(((Condition.ParameterEditor)event.postValue).editWidget.m_6035_().getString()), "");
            }).width(100)).addColumn(Grid.wildcard("amount").editWidgetProvider(row -> {
                Condition.ParameterEditor editor = (Condition.ParameterEditor)row.getValue("attribute");
                return editor == null ? null : editor.editWidget;
            }).valueChanged(event -> {
                CompoundTag attributesTag = this.styles.get(0).getValue();
                Condition.ParameterEditor editor = (Condition.ParameterEditor)event.grid.getValue(event.rowposition, "attribute");
                if (!StringUtil.isNullOrEmpty((String)ParseUtil.nullParam(event.postValue))) {
                    attributesTag.m_128365_(editor.editWidget.m_6035_().getString(), editor.toTag.apply(event.postValue));
                } else {
                    attributesTag.m_128473_(editor.editWidget.m_6035_().getString());
                }
            }).width(150)).pressAdd((grid, button) -> {
                this.styles.get(0).getValue().m_128365_("", (Tag)StringTag.m_129297_((String)""));
                int rowposition = grid.addRow();
                grid.setGridFocus(rowposition, "attribute");
            }).pressRemove((grid, button) -> {
                this.styles.get(0).getValue().m_128473_((String)grid.getValue(grid.getRowposition(), "attribute"));
                grid.removeRow(removedRow -> {});
            }).build();
            this.styles.add(PackEntry.of("attributes", CompoundTag::new));
            Grid.PackImporter packImporter = new Grid.PackImporter();
            for (Map.Entry entry : rootTag.f_128329_.entrySet()) {
                Condition.ParameterEditor paramEditor = this.armorAttributeEditors.get(entry.getKey());
                packImporter.newRow();
                packImporter.newValue("attribute", this.armorAttributeEditors.get(entry.getKey()));
                packImporter.newValue("amount", paramEditor.fromTag.apply((Tag)entry.getValue()));
            }
            this.attributesGrid._setValue(packImporter);
        }
    }

    protected void m_7856_() {
        if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
            this.stylesGrid.resize(this.m_264198_());
            this.m_142416_(new Static((Screen)this, 20, 60, 40, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237115_((String)"datapack_edit.styles")));
            this.m_142416_(this.stylesGrid);
        }
        this.attributesGrid.resize(this.m_264198_());
        this.m_142416_(new Static((Screen)this, this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON ? 120 : 20, 60, 40, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237115_((String)"datapack_edit.item_capability.attributes")));
        this.m_142416_(this.attributesGrid);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.WEAPON) {
                HashSet styles = Sets.newHashSet();
                for (PackEntry<String, CompoundTag> entry : this.styles) {
                    if (styles.contains(entry.getKey())) {
                        this.f_96541_.m_91152_(new MessageScreen("Save Failed", "Unable to save because of duplicated style: " + entry.getKey(), (Screen)this, button2 -> this.f_96541_.m_91152_((Screen)this), 180, 90));
                        return;
                    }
                    styles.add(entry.getKey());
                }
                this.rootTag.f_128329_.clear();
                for (PackEntry<String, CompoundTag> entry : this.styles) {
                    this.rootTag.m_128365_(entry.getKey(), (Tag)entry.getValue());
                }
            } else if (this.itemType == DatapackEditScreen.ItemCapabilityTab.ItemType.ARMOR) {
                CompoundTag attributesTag = this.styles.get(0).getValue();
                for (Map.Entry tag : attributesTag.f_128329_.entrySet()) {
                    this.rootTag.m_128365_((String)tag.getKey(), (Tag)tag.getValue());
                }
            }
            this.m_7379_();
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 32).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(new MessageScreen("", "Do you want to quit without saving changes?", (Screen)this, button2 -> this.m_7379_(), button2 -> this.f_96541_.m_91152_((Screen)this), 180, 70))).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 32).m_253046_(160, 21).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yBegin = 32;
        int yEnd = this.f_96544_ - 45;
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 20, 16, 0xFFFFFF);
        guiGraphics.m_280246_(0.125f, 0.125f, 0.125f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, 0, yBegin, (float)this.f_96543_, (float)yEnd - (float)yBegin, this.f_96543_, yEnd, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, 0, 0, 0.0f, 0.0f, this.f_96543_, yBegin, 32, 32);
        guiGraphics.m_280163_(Screen.f_279548_, 0, yEnd, 0.0f, (float)yEnd - (float)yBegin, this.f_96543_, yEnd, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_285978_(RenderType.m_286086_(), 0, yBegin, this.f_96543_, yBegin + 4, -16777216, 0, 0);
        guiGraphics.m_285978_(RenderType.m_286086_(), 0, yEnd, this.f_96543_, yEnd + 1, 0, -16777216, 0);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }
}

