/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PCustomEntityRenderer
extends PatchedEntityRenderer<LivingEntity, LivingEntityPatch<LivingEntity>, EntityRenderer<LivingEntity>, SkinnedMesh> {
    private final AssetAccessor<SkinnedMesh> mesh;

    public PCustomEntityRenderer(AssetAccessor<SkinnedMesh> mesh, EntityRendererProvider.Context context) {
        this.mesh = mesh;
    }

    @Override
    public void render(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, EntityRenderer<LivingEntity> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        SkinnedMesh mesh;
        PrepareModelEvent prepareModelEvent;
        super.render(entity, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        boolean isGlowing = mc.m_91314_((Entity)entity);
        ResourceLocation textureLocation = renderer.m_5478_((Entity)entity);
        RenderType renderType = isGlowing ? RenderType.m_110491_((ResourceLocation)textureLocation) : RenderType.m_110458_((ResourceLocation)textureLocation);
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
        this.setArmaturePose(entitypatch, armature, partialTicks);
        if (renderType != null && !MinecraftForge.EVENT_BUS.post((Event)(prepareModelEvent = new PrepareModelEvent(this, mesh = this.mesh.get(), entitypatch, buffer, poseStack, packedLight, partialTicks)))) {
            mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, !entity.m_20177_((Player)mc.f_91074_) ? 0.15f : 1.0f, this.getOverlayCoord(entity, entitypatch, partialTicks), armature, armature.getPoseMatrices());
        }
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    protected int getOverlayCoord(LivingEntity entity, LivingEntityPatch<LivingEntity> entitypatch, float partialTicks) {
        return OverlayTexture.m_118093_((int)0, (int)OverlayTexture.m_118096_((entity.f_20916_ > 5 ? 1 : 0) != 0));
    }

    @Override
    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        return this.mesh;
    }
}

