/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.shader.compute.backend.program;

import java.nio.FloatBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL46C;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class Uniform {
    private final int programHandle;
    private final int uniformLocation;

    public Uniform(int programHandle, int uniformLocation) {
        this.programHandle = programHandle;
        this.uniformLocation = uniformLocation;
    }

    public void uploadMatrix3f(Matrix3f matrix) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL46C.glProgramUniformMatrix3fv((int)this.programHandle, (int)this.uniformLocation, (boolean)false, (FloatBuffer)matrix.get(stack.callocFloat(9)));
        }
    }

    public void uploadMatrix4f(Matrix4f matrix) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL46C.glProgramUniformMatrix4fv((int)this.programHandle, (int)this.uniformLocation, (boolean)false, (FloatBuffer)matrix.get(stack.callocFloat(16)));
        }
    }

    public void uploadUnsignedInt(int value) {
        GL46C.glProgramUniform1ui((int)this.programHandle, (int)this.uniformLocation, (int)value);
    }

    public void uploadVec4(float a, float b, float c, float d) {
        GL46C.glProgramUniform4f((int)this.programHandle, (int)this.uniformLocation, (float)a, (float)b, (float)c, (float)d);
    }
}

