/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerSkillActivated
extends Condition.EntityPatchCondition {
    private Skill skill;

    public PlayerSkillActivated read(CompoundTag tag) {
        String skillName = this.assertTag("skill", "string", tag, StringTag.class, CompoundTag::m_128461_);
        this.skill = SkillManager.getSkill(skillName);
        if (this.skill == null) {
            throw new NoSuchElementException(MessageFormat.format((String)"{} condition error: Skill named {} does not exist", (Object[])new Object[]{this.getClass().getSimpleName(), skillName}));
        }
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("skill", this.skill.getRegistryName().toString());
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        if (target instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)target;
            Optional<SkillContainer> skill = playerpatch.getSkillContainerFor(this.skill);
            if (skill.isEmpty()) {
                return false;
            }
            return skill.get().isActivated();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        PopupBox.RegistryPopupBox<Skill> popupBox = new PopupBox.RegistryPopupBox<Skill>(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, (Component)Component.m_237113_((String)"skill"), SkillManager.getSkillRegistry(), null);
        return List.of(Condition.ParameterEditor.of(skill -> StringTag.m_129297_((String)skill.toString()), tag -> SkillManager.getSkill(ParseUtil.nullOrToString(tag, Tag::m_7916_)), popupBox));
    }
}

