/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types.procedural;

import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulatable;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulator;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EnderDragonDynamicActionAnimation
extends ActionAnimation {
    public EnderDragonDynamicActionAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends EnderDragonDynamicActionAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, (AnimationManager.AnimationAccessor<? extends ActionAnimation>)accessor, armature);
    }

    @Override
    public void putOnPlayer(AnimationPlayer animationPlayer, LivingEntityPatch<?> entitypatch) {
        super.putOnPlayer(animationPlayer, entitypatch);
        if (entitypatch instanceof InverseKinematicsSimulatable) {
            InverseKinematicsSimulatable ikSimulatable = (InverseKinematicsSimulatable)((Object)entitypatch);
            Vec3 entitypos = ikSimulatable.toEntity().m_20182_();
            OpenMatrix4f toWorld = OpenMatrix4f.mul(OpenMatrix4f.createTranslation((float)entitypos.f_82479_, (float)entitypos.f_82480_, (float)entitypos.f_82481_), ikSimulatable.getModelMatrix(1.0f), null);
            TransformSheet movementAnimation = (TransformSheet)((Animator)entitypatch.getAnimator()).getVariables().getOrDefaultSharedVariable(ACTION_ANIMATION_COORD);
            this.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).ifPresent(ikDefinitions -> {
                for (InverseKinematicsSimulator.BakedInverseKinematicsDefinition bakedIKInfo : ikDefinitions) {
                    TransformSheet tipAnim = this.clipAnimation(bakedIKInfo.terminalBoneTransform(), bakedIKInfo);
                    Keyframe[] keyframes = tipAnim.getKeyframes();
                    Vec3f startpos = movementAnimation.getInterpolatedTranslation(0.0f);
                    for (int i = 0; i < keyframes.length; ++i) {
                        Vec3f finalTargetpos;
                        Keyframe kf = keyframes[i];
                        Vec3f dynamicpos = movementAnimation.getInterpolatedTranslation(kf.time()).sub(startpos);
                        OpenMatrix4f.transform3v(OpenMatrix4f.createRotatorDeg(-90.0f, Vec3f.X_AXIS), dynamicpos, dynamicpos).multiply(-1.0f, 1.0f, -1.0f);
                        if (!bakedIKInfo.clipAnimation() || bakedIKInfo.touchingGround()[i]) {
                            Vec3f clipStart = kf.transform().translation().copy().multiply(-1.0f, 1.0f, -1.0f).add(dynamicpos).add(0.0f, 2.5f, 0.0f);
                            finalTargetpos = this.getRayCastedTipPosition(ikSimulatable, clipStart, toWorld, 2.5f, bakedIKInfo.rayLeastHeight());
                        } else {
                            Vec3f start = kf.transform().translation().copy().multiply(-1.0f, 1.0f, -1.0f).add(dynamicpos);
                            finalTargetpos = OpenMatrix4f.transform3v(toWorld, start, null);
                        }
                        kf.transform().translation().set(finalTargetpos);
                    }
                    ikSimulatable.getIKSimulator().runUntil(bakedIKInfo.endJoint(), this, InverseKinematicsSimulator.InverseKinematicsBuilder.create(keyframes[0].transform().translation(), tipAnim, bakedIKInfo), () -> ((Animator)entitypatch.getAnimator()).getPlayer(this.getAccessor()).isPresent());
                }
            });
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch instanceof InverseKinematicsSimulatable) {
            InverseKinematicsSimulatable ikSimulatable = (InverseKinematicsSimulatable)((Object)entitypatch);
            float elapsedTime = ((Animator)entitypatch.getAnimator()).getPlayerFor(this.getAccessor()).getElapsedTime();
            this.getProperty(AnimationProperty.StaticAnimationProperty.BAKED_IK_DEFINITION).ifPresent(ikDefinitions -> {
                for (InverseKinematicsSimulator.BakedInverseKinematicsDefinition bakedIKInfo : ikDefinitions) {
                    InverseKinematicsSimulator.InverseKinematicsObject tipAnim;
                    if (!ikSimulatable.getIKSimulator().isRunning(bakedIKInfo.endJoint()) || !bakedIKInfo.clipAnimation()) continue;
                    Keyframe[] keyframes = this.getTransfroms().get(bakedIKInfo.endJoint().getName()).getKeyframes();
                    float startTime = keyframes[bakedIKInfo.startFrame()].time();
                    float endTime = keyframes[bakedIKInfo.endFrame() - 1].time();
                    if (!(startTime <= elapsedTime) || !(elapsedTime < endTime) || (tipAnim = (InverseKinematicsSimulator.InverseKinematicsObject)ikSimulatable.getIKSimulator().getRunningObject(bakedIKInfo.endJoint()).get()).isOnWorking()) continue;
                    this.startSimple(tipAnim);
                }
            });
        }
    }
}

