/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
public class SelectFromRegistryScreen<T>
extends Screen {
    private final RegistryList registryList;
    private final Screen parentScreen;
    private final Consumer<T> onPressRow;
    private final BiConsumer<String, T> onAccept;
    private final BiConsumer<String, T> onCancel;

    public SelectFromRegistryScreen(Screen parentScreen, IForgeRegistry<T> registry, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Predicate<T> filter) {
        this(parentScreen, registry, onAccept, onCancel, select -> {}, filter);
    }

    public SelectFromRegistryScreen(Screen parentScreen, IForgeRegistry<T> registry, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Consumer<T> onPressRow, Predicate<T> filter) {
        super((Component)Component.m_237110_((String)"gui.epicfight.select", (Object[])new Object[]{ParseUtil.snakeToSpacedCamel(registry.getRegistryName().m_135815_())}));
        this.parentScreen = parentScreen;
        this.f_96541_ = parentScreen.getMinecraft();
        this.f_96547_ = parentScreen.getMinecraft().f_91062_;
        HashMap filteredItems = Maps.newHashMap();
        registry.getValues().stream().filter(filter).forEach(value -> filteredItems.put(registry.getKey(value), value));
        this.registryList = new RegistryList(parentScreen.getMinecraft(), this.f_96543_, this.f_96544_, 36, this.f_96544_ - 16, 21, filteredItems);
        this.onPressRow = onPressRow;
        this.onAccept = onAccept;
        this.onCancel = onCancel;
    }

    public SelectFromRegistryScreen(Screen parentScreen, Set<Pair<ResourceLocation, T>> entries, String title, BiConsumer<String, T> onAccept, BiConsumer<String, T> onCancel, Consumer<T> onPressRow, Predicate<T> filter) {
        super((Component)Component.m_237110_((String)"gui.epicfight.select", (Object[])new Object[]{ParseUtil.snakeToSpacedCamel(title)}));
        this.parentScreen = parentScreen;
        this.f_96541_ = parentScreen.getMinecraft();
        this.f_96547_ = parentScreen.getMinecraft().f_91062_;
        Map filteredItems = entries.stream().filter(entry -> filter.test(entry.getSecond())).reduce(Maps.newHashMap(), (map, element) -> {
            map.put((ResourceLocation)element.getFirst(), element.getSecond());
            return map;
        }, (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        });
        this.registryList = new RegistryList(parentScreen.getMinecraft(), this.f_96543_, this.f_96544_, 36, this.f_96544_ - 16, 21, filteredItems);
        this.onPressRow = onPressRow;
        this.onAccept = onAccept;
        this.onCancel = onCancel;
    }

    protected void m_7856_() {
        this.registryList.m_93437_(this.f_96543_, this.f_96544_, 36, this.f_96544_ - 32);
        EditBox editBox = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2, 12, this.f_96543_ / 2 - 12, 16, (Component)Component.m_237113_((String)EpicFightMod.prefix("")));
        editBox.m_94151_(this.registryList::applyFilter);
        this.m_142416_((GuiEventListener)this.registryList);
        this.m_142416_((GuiEventListener)editBox);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button$1 -> {
            if (this.registryList.m_93511_() == null) {
                this.f_96541_.m_91152_(new MessageScreen("", "Select an item from the list", (Screen)this, button$2 -> this.f_96541_.m_91152_((Screen)this), 180, 60));
            } else {
                try {
                    this.onAccept.accept(((RegistryList.RegistryEntry)this.registryList.m_93511_()).name, (String)((RegistryList.RegistryEntry)this.registryList.m_93511_()).item);
                    this.f_96541_.m_91152_(this.parentScreen);
                }
                catch (Exception e) {
                    this.f_96541_.m_91152_(new MessageScreen("", e.getMessage(), this.parentScreen, button$2 -> this.f_96541_.m_91152_(this.parentScreen), 180, 70).autoCalculateHeight());
                }
            }
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            this.onCancel.accept("", null);
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280039_(guiGraphics);
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 20, 16, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegistryList
    extends ObjectSelectionList<yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
        private final Map<ResourceLocation, T> registry;

        public RegistryList(Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight, Map<ResourceLocation, T> registry) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.registry = registry;
            registry.entrySet().stream().sorted((entry1, entry2) -> ((ResourceLocation)entry1.getKey()).toString().compareTo(((ResourceLocation)entry2.getKey()).toString())).forEach(entry -> this.m_7085_((AbstractSelectionList.Entry)new RegistryEntry(entry.getValue(), ((ResourceLocation)entry.getKey()).toString())));
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(@Nullable RegistryEntry selEntry) {
            SelectFromRegistryScreen.this.onPressRow.accept(selEntry.item);
            super.m_6987_((AbstractSelectionList.Entry)selEntry);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        public void applyFilter(String keyward) {
            this.m_93410_(0.0);
            this.m_6702_().clear();
            this.registry.entrySet().stream().sorted((entry1, entry2) -> ((ResourceLocation)entry1.getKey()).toString().compareTo(((ResourceLocation)entry2.getKey()).toString())).filter(entry -> StringUtil.m_14408_((String)keyward) ? true : ((ResourceLocation)entry.getKey()).toString().contains(keyward)).map(entry -> new RegistryEntry(entry.getValue(), ((ResourceLocation)entry.getKey()).toString())).forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        @OnlyIn(value=Dist.CLIENT)
        class RegistryEntry
        extends ObjectSelectionList.Entry<yesman.epicfight.client.gui.datapack.screen.SelectFromRegistryScreen$RegistryList.RegistryEntry> {
            private final T item;
            private final String name;

            public RegistryEntry(T item, String name) {
                this.item = item;
                this.name = name;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                guiGraphics.m_280056_(((SelectFromRegistryScreen)SelectFromRegistryScreen.this).f_96541_.f_91062_, this.name, left + 25, top + 5, 0xFFFFFF, false);
            }

            public Component m_142172_() {
                return Component.m_237115_((String)"narrator.select");
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegistryList.this.m_93511_() == this) {
                        try {
                            SelectFromRegistryScreen.this.onAccept.accept(this.name, (String)this.item);
                            SelectFromRegistryScreen.this.f_96541_.m_91152_(SelectFromRegistryScreen.this.parentScreen);
                        }
                        catch (Exception e) {
                            SelectFromRegistryScreen.this.f_96541_.m_91152_(new MessageScreen("", e.getMessage(), SelectFromRegistryScreen.this.parentScreen, button$2 -> SelectFromRegistryScreen.this.f_96541_.m_91152_(SelectFromRegistryScreen.this.parentScreen), 180, 70).autoCalculateHeight());
                        }
                        return true;
                    }
                    RegistryList.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

