/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;
import yesman.epicfight.world.capabilities.provider.SkillCapabilityProvider;

@Mod.EventBusSubscriber(modid="epicfight")
public class CapabilityEvents {
    private static final ResourceLocation ENTITY_CAPABILITY_KEY = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"entity_cap");
    private static final ResourceLocation ITEM_CAPABILITY_KEY = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"item_cap");
    private static final ResourceLocation SKILL_CAPABILITY_KEY = ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"skill_cap");

    @SubscribeEvent
    public static void attachItemCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemCapabilityProvider prov;
        if (event.getObject() != null && (prov = new ItemCapabilityProvider((ItemStack)event.getObject())).hasCapability()) {
            event.addCapability(ITEM_CAPABILITY_KEY, (ICapabilityProvider)prov);
        }
    }

    @SubscribeEvent
    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        EntityPatchProvider prov;
        EntityPatch oldEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getObject(), EntityPatch.class);
        if (oldEntitypatch == null && (prov = new EntityPatchProvider((Entity)event.getObject())).hasCapability()) {
            EntityPatch entitypatch = (EntityPatch)prov.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            entitypatch.onConstructed((Entity)event.getObject());
            event.addCapability(ENTITY_CAPABILITY_KEY, (ICapabilityProvider)prov);
            if (entitypatch instanceof PlayerPatch) {
                PlayerPatch playerpatch = (PlayerPatch)entitypatch;
                if (((Entity)event.getObject()).getCapability(EpicFightCapabilities.CAPABILITY_SKILL).orElse(null) == null && playerpatch != null) {
                    SkillCapabilityProvider skillProvider = new SkillCapabilityProvider(playerpatch);
                    event.addCapability(SKILL_CAPABILITY_KEY, (ICapabilityProvider)skillProvider);
                }
            }
        }
    }
}

