/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.events;

import java.io.File;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.common.AnimatorControlPacket;
import yesman.epicfight.network.server.SPAbsorption;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.ItemUseEndEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.RightClickItemEvent;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

@Mod.EventBusSubscriber(modid="epicfight")
public class PlayerEvents {
    @SubscribeEvent
    public static void arrowLoose(ArrowLooseEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), PlayerPatch.class).ifPresent(playerpatch -> {
            if (playerpatch.isLogicalClient()) {
                ((Animator)playerpatch.getAnimator()).playShootingAnimation();
            } else {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAnimatorControl(AnimatorControlPacket.Action.SHOT, -1, event.getEntity().m_19879_(), 0.0f, false), (Entity)event.getEntity(), new Object[0]);
            }
        });
    }

    @SubscribeEvent
    public static void startTrackingEvent(PlayerEvent.StartTracking event) {
        LivingEntity livingEntity;
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6103_() > 0.0f) {
            EpicFightNetworkManager.sendToPlayer(new SPAbsorption(event.getTarget().m_19879_(), livingEntity.m_6103_()), (ServerPlayer)event.getEntity(), new Object[0]);
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getTarget(), EntityPatch.class).ifPresent(entitypatch -> entitypatch.onStartTracking((ServerPlayer)event.getEntity()));
    }

    @SubscribeEvent
    public static void stopTrackingEvent(PlayerEvent.StopTracking event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch(event.getTarget(), EntityPatch.class).ifPresent(entitypatch -> entitypatch.onStopTracking((ServerPlayer)event.getEntity()));
    }

    @SubscribeEvent
    public static void playerLoadEvent(PlayerEvent.LoadFromFile event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            File file = new File(event.getPlayerDirectory(), event.getPlayerUUID() + ".dat");
            if (!file.exists()) {
                int initialMode = Math.min(EpicFightGameRules.INITIAL_PLAYER_MODE.getRuleValue(event.getEntity().m_9236_()), PlayerPatch.PlayerMode.values().length - 1);
                playerpatch.toMode(PlayerPatch.PlayerMode.values()[initialMode], true);
            }
        });
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getOriginal(), ServerPlayerPatch.class).ifPresent(oldCap -> EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getEntity(), ServerPlayer.class, ServerPlayerPatch.class).ifPresent(newCap -> {
            if (!event.isWasDeath() || EpicFightGameRules.KEEP_SKILLS.getRuleValue(event.getOriginal().m_9236_()).booleanValue()) {
                newCap.copySkillsFrom((PlayerPatch<?>)oldCap, event.isWasDeath());
            }
            newCap.toMode(oldCap.getPlayerMode(), false);
        }));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void changeDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            ((Animator)playerpatch.getAnimator()).resetLivingAnimations();
            playerpatch.modifyLivingMotionByCurrentItem(true);
            EpicFightNetworkManager.PayloadBundleBuilder packetBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
            playerpatch.getSkillCapability().listSkillContainers().filter(SkillContainer::hasSkill).forEach(skillContainer -> skillContainer.getSkill().onTracked((SkillContainer)skillContainer, packetBundleBuilder));
            packetBundleBuilder.send((start, others) -> EpicFightNetworkManager.sendToPlayer(start, (ServerPlayer)playerpatch.getOriginal(), others));
        });
    }

    @SubscribeEvent
    public static void rightClickItemServerEvent(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            ItemStack itemstack = ((ServerPlayer)playerpatch.getOriginal()).m_21206_();
            if (!playerpatch.getEntityState().canUseItem()) {
                event.setCanceled(true);
            } else if (itemstack.m_41780_() == UseAnim.NONE || !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch<?>)playerpatch).canUseOffhand()) {
                boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, new RightClickItemEvent<ServerPlayerPatch>((ServerPlayerPatch)playerpatch));
                if (playerpatch.getEntityState().movementLocked()) {
                    canceled = true;
                }
                event.setCanceled(canceled);
            }
        });
    }

    @SubscribeEvent
    public static void itemUseStartEvent(LivingEntityUseItemEvent.Start event) {
        EpicFightCapabilities.getParameterizedEntityPatch((Entity)event.getEntity(), Player.class, PlayerPatch.class).ifPresent(playerpatch -> {
            InteractionHand hand = ((Player)playerpatch.getOriginal()).m_21120_(InteractionHand.MAIN_HAND).equals(event.getItem()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            CapabilityItem itemCap = playerpatch.getHoldingItemCapability(hand);
            if (!playerpatch.getEntityState().canUseItem()) {
                event.setCanceled(true);
            } else if (event.getItem() == ((Player)playerpatch.getOriginal()).m_21206_() && !playerpatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getStyle((LivingEntityPatch<?>)playerpatch).canUseOffhand()) {
                event.setCanceled(true);
            }
            if (itemCap.getUseAnimation((LivingEntityPatch<?>)playerpatch) == UseAnim.BLOCK) {
                event.setDuration(Integer.MAX_VALUE);
            }
        });
    }

    @SubscribeEvent
    public static void itemUseStopEvent(LivingEntityUseItemEvent.Stop event) {
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)event.getEntity(), ServerPlayerPatch.class).ifPresent(playerpatch -> {
            boolean canceled = playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.SERVER_ITEM_STOP_EVENT, new ItemUseEndEvent((ServerPlayerPatch)playerpatch, event));
            event.setCanceled(canceled);
        });
    }

    public static boolean fakePlayerCheck(Player source) {
        return source instanceof FakePlayer;
    }
}

