/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerModeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"mode").requires(commandSourceStack -> commandSourceStack.m_6761_(2));
        for (PlayerPatch.PlayerMode mode : PlayerPatch.PlayerMode.values()) {
            builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)mode.name().toLowerCase(Locale.ROOT)).executes(command -> PlayerModeCommand.setMode((CommandContext<CommandSourceStack>)command, Collections.singleton(((CommandSourceStack)command.getSource()).m_81375_()), mode))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(p_137728_ -> PlayerModeCommand.setMode((CommandContext<CommandSourceStack>)p_137728_, EntityArgument.m_91477_((CommandContext)p_137728_, (String)"target"), mode))));
        }
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"epicfight").then((ArgumentBuilder)builder));
    }

    private static int setMode(CommandContext<CommandSourceStack> command, Collection<ServerPlayer> players, PlayerPatch.PlayerMode playerMode) {
        int i = 0;
        for (ServerPlayer serverplayer : players) {
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverplayer, ServerPlayerPatch.class);
            if (playerpatch == null) continue;
            PlayerModeCommand.logGamemodeChange((CommandSourceStack)command.getSource(), serverplayer, playerMode);
            playerpatch.toMode(playerMode, true);
            ++i;
        }
        return i;
    }

    private static void logGamemodeChange(CommandSourceStack command, ServerPlayer serverPlayer, PlayerPatch.PlayerMode playerMode) {
        MutableComponent component = Component.m_237115_((String)("gameMode.epicfight." + playerMode.name().toLowerCase(Locale.ROOT)));
        if (command.m_81373_() == serverPlayer) {
            command.m_288197_(() -> PlayerModeCommand.lambda$logGamemodeChange$3((Component)component), true);
        } else {
            if (command.m_81372_().m_46469_().m_46207_(GameRules.f_46144_)) {
                serverPlayer.m_213846_((Component)Component.m_237110_((String)"gameMode.changed", (Object[])new Object[]{component}));
            }
            command.m_288197_(() -> PlayerModeCommand.lambda$logGamemodeChange$4(serverPlayer, (Component)component), true);
        }
    }

    private static /* synthetic */ Component lambda$logGamemodeChange$4(ServerPlayer serverPlayer, Component component) {
        return Component.m_237110_((String)"commands.gamemode.success.other", (Object[])new Object[]{serverPlayer.m_5446_(), component});
    }

    private static /* synthetic */ Component lambda$logGamemodeChange$3(Component component) {
        return Component.m_237110_((String)"commands.gamemode.success.self", (Object[])new Object[]{component});
    }
}

