/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import yesman.epicfight.api.animation.types.DodgeAnimation;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class TechnicianSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("99e5c782-fdaf-11eb-9a03-0242ac130003");

    public TechnicianSkill(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.TECHNICIAN.get(), 1.0f, 1.0f, 1.0f);
            serverplayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_123759_, event.getLocation().m_7096_(), event.getLocation().m_7098_(), event.getLocation().m_7094_(), 4, 0.0, 0.0, 0.0, 0.075);
            float consumption = container.getExecutor().getModifiedStaminaConsume(container.getExecutor().getSkill(SkillSlots.DODGE).getSkill().getConsumption());
            container.getExecutor().setStamina(container.getExecutor().getStamina() + consumption);
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, event -> {
            if (!container.getExecutor().isLogicalClient() && event.getAnimation() instanceof DodgeAnimation) {
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(new SPEntityPairingPacket(((ServerPlayer)container.getServerExecutor().getOriginal()).m_19879_(), EntityPairingPacketTypes.TECHNICIAN_ACTIVATED), (ServerPlayer)container.getServerExecutor().getOriginal(), new Object[0]);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
    }
}

