/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.property;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.physics.ik.InverseKinematicsSimulator;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;

public abstract class AnimationProperty<T> {
    private static final Map<String, AnimationProperty<?>> SERIALIZABLE_ANIMATION_PROPERTY_KEYS = Maps.newHashMap();
    private final Codec<T> codecs;
    private final String name;

    public static <T> AnimationProperty<T> getSerializableProperty(String name) {
        if (!SERIALIZABLE_ANIMATION_PROPERTY_KEYS.containsKey(name)) {
            throw new IllegalStateException("No property key named " + name);
        }
        return SERIALIZABLE_ANIMATION_PROPERTY_KEYS.get(name);
    }

    public AnimationProperty(String name, @Nullable Codec<T> codecs) {
        this.codecs = codecs;
        this.name = name;
        if (name != null) {
            if (SERIALIZABLE_ANIMATION_PROPERTY_KEYS.containsKey(name)) {
                throw new IllegalStateException("Animation property key " + name + " is already registered.");
            }
            SERIALIZABLE_ANIMATION_PROPERTY_KEYS.put(name, this);
        }
    }

    public AnimationProperty(String name) {
        this(name, null);
    }

    public T parseFrom(JsonElement e) {
        return this.codecs.parse((DynamicOps)JsonOps.INSTANCE, (Object)e).resultOrPartial(errm -> EpicFightMod.LOGGER.warn("Failed to parse property " + this.name + " because of " + errm)).orElseThrow();
    }

    public Codec<T> getCodecs() {
        return this.codecs;
    }

    @FunctionalInterface
    public static interface YRotProvider {
        public float get(DynamicAnimation var1, LivingEntityPatch<?> var2);
    }

    @FunctionalInterface
    public static interface DestLocationProvider {
        public Vec3 get(DynamicAnimation var1, LivingEntityPatch<?> var2);
    }

    @FunctionalInterface
    public static interface PlaybackTimeModifier {
        public Pair<Float, Float> modify(DynamicAnimation var1, LivingEntityPatch<?> var2, float var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface PlaybackSpeedModifier {
        public float modify(DynamicAnimation var1, LivingEntityPatch<?> var2, float var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface PoseModifier {
        public void modify(DynamicAnimation var1, Pose var2, LivingEntityPatch<?> var3, float var4, float var5);
    }

    @FunctionalInterface
    public static interface Registerer<T> {
        public void register(Map<AnimationProperty<T>, Object> var1, AnimationProperty<T> var2, T var3);
    }

    public static class AttackPhaseProperty<T> {
        public static final AttackPhaseProperty<ValueModifier> MAX_STRIKES_MODIFIER = new AttackPhaseProperty<ValueModifier.Unified>("max_strikes", ValueModifier.CODEC);
        public static final AttackPhaseProperty<ValueModifier> DAMAGE_MODIFIER = new AttackPhaseProperty<ValueModifier.Unified>("damage", ValueModifier.CODEC);
        public static final AttackPhaseProperty<ValueModifier> ARMOR_NEGATION_MODIFIER = new AttackPhaseProperty<ValueModifier.Unified>("armor_negation", ValueModifier.CODEC);
        public static final AttackPhaseProperty<ValueModifier> IMPACT_MODIFIER = new AttackPhaseProperty<ValueModifier.Unified>("impact", ValueModifier.CODEC);
        public static final AttackPhaseProperty<Set<ExtraDamageInstance>> EXTRA_DAMAGE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<StunType> STUN_TYPE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<SoundEvent> SWING_SOUND = new AttackPhaseProperty();
        public static final AttackPhaseProperty<SoundEvent> HIT_SOUND = new AttackPhaseProperty();
        public static final AttackPhaseProperty<DeferredHolder<ParticleType<?>, HitParticleType>> PARTICLE = new AttackPhaseProperty();
        public static final AttackPhaseProperty<HitEntityList.Priority> HIT_PRIORITY = new AttackPhaseProperty();
        public static final AttackPhaseProperty<Set<TagKey<DamageType>>> SOURCE_TAG = new AttackPhaseProperty();
        public static final AttackPhaseProperty<Function<LivingEntityPatch<?>, Vec3>> SOURCE_LOCATION_PROVIDER = new AttackPhaseProperty();

        public AttackPhaseProperty(String rl, @Nullable Codec<? extends T> codecs) {
        }

        public AttackPhaseProperty() {
        }
    }

    public static class AttackAnimationProperty<T>
    extends ActionAnimationProperty<T> {
        public static final AttackAnimationProperty<Boolean> FIXED_MOVE_DISTANCE = new AttackAnimationProperty("fixed_movement_distance", Codec.BOOL);
        public static final AttackAnimationProperty<Float> ATTACK_SPEED_FACTOR = new AttackAnimationProperty("attack_speed_factor", Codec.FLOAT);
        public static final AttackAnimationProperty<Float> BASIS_ATTACK_SPEED = new AttackAnimationProperty("basis_attack_speed", Codec.FLOAT);
        public static final AttackAnimationProperty<Integer> EXTRA_COLLIDERS = new AttackAnimationProperty("extra_colliders", Codec.INT);
        public static final AttackAnimationProperty<Float> REACH = new AttackAnimationProperty("reach", Codec.FLOAT);

        public AttackAnimationProperty(String rl, @Nullable Codec<T> codecs) {
            super(rl, codecs);
        }

        public AttackAnimationProperty() {
            this(null, null);
        }
    }

    public static class ActionAnimationProperty<T>
    extends StaticAnimationProperty<T> {
        public static final ActionAnimationProperty<Boolean> STOP_MOVEMENT = new ActionAnimationProperty("stop_movements", Codec.BOOL);
        public static final ActionAnimationProperty<Boolean> REMOVE_DELTA_MOVEMENT = new ActionAnimationProperty("revmoe_delta_move", Codec.BOOL);
        public static final ActionAnimationProperty<Boolean> MOVE_VERTICAL = new ActionAnimationProperty("move_vertically", Codec.BOOL);
        public static final ActionAnimationProperty<TimePairList> NO_GRAVITY_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<TransformSheet> COORD = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> MOVE_ON_LINK = new ActionAnimationProperty("move_during_link", Codec.BOOL);
        public static final ActionAnimationProperty<TimePairList> MOVE_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordSetter> COORD_SET_BEGIN = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordSetter> COORD_SET_TICK = new ActionAnimationProperty();
        public static final ActionAnimationProperty<MoveCoordFunctions.MoveCoordGetter> COORD_GET = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> AFFECT_SPEED = new ActionAnimationProperty("move_speed_based_distance", Codec.BOOL);
        public static final ActionAnimationProperty<Boolean> CANCELABLE_MOVE = new ActionAnimationProperty("cancellable_movement", Codec.BOOL);
        public static final ActionAnimationProperty<Boolean> IS_DEATH_ANIMATION = new ActionAnimationProperty("is_death", Codec.BOOL);
        public static final ActionAnimationProperty<TimePairList> COORD_UPDATE_TIME = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> RESET_PLAYER_COMBO_COUNTER = new ActionAnimationProperty("reset_combo_attack_counter", Codec.BOOL);
        public static final ActionAnimationProperty<DestLocationProvider> DEST_LOCATION_PROVIDER = new ActionAnimationProperty();
        public static final ActionAnimationProperty<YRotProvider> ENTITY_YROT_PROVIDER = new ActionAnimationProperty();
        public static final ActionAnimationProperty<YRotProvider> DEST_COORD_YROT_PROVIDER = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Integer> COORD_START_KEYFRAME_INDEX = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Integer> COORD_DEST_KEYFRAME_INDEX = new ActionAnimationProperty();
        public static final ActionAnimationProperty<Boolean> SYNC_CAMERA = new ActionAnimationProperty("sync_camera", Codec.BOOL);

        public ActionAnimationProperty(String rl, @Nullable Codec<T> codecs) {
            super(rl, codecs);
        }

        public ActionAnimationProperty() {
            this(null, null);
        }
    }

    public static class StaticAnimationProperty<T>
    extends AnimationProperty<T> {
        public static final StaticAnimationProperty<List<AnimationEvent<?, ?>>> TICK_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<List<AnimationEvent.SimpleEvent<?>>> ON_BEGIN_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<List<AnimationEvent.SimpleEvent<?>>> ON_END_EVENTS = new StaticAnimationProperty();
        public static final StaticAnimationProperty<AnimationEvent.SimpleEvent<AnimationEvent.E2<CapabilityItem, CapabilityItem>>> ON_ITEM_CHANGE_EVENT = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PlaybackSpeedModifier> PLAY_SPEED_MODIFIER = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PlaybackTimeModifier> ELAPSED_TIME_MODIFIER = new StaticAnimationProperty();
        public static final StaticAnimationProperty<PoseModifier> POSE_MODIFIER = new StaticAnimationProperty();
        public static final StaticAnimationProperty<Boolean> FIXED_HEAD_ROTATION = new StaticAnimationProperty();
        public static final StaticAnimationProperty<Map<ResourceLocation, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> TRANSITION_ANIMATIONS_FROM = new StaticAnimationProperty();
        public static final StaticAnimationProperty<Map<ResourceLocation, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> TRANSITION_ANIMATIONS_TO = new StaticAnimationProperty();
        public static final StaticAnimationProperty<Boolean> NO_PHYSICS = new StaticAnimationProperty("no_physics", Codec.BOOL);
        public static final StaticAnimationProperty<List<InverseKinematicsSimulator.InverseKinematicsDefinition>> IK_DEFINITION = new StaticAnimationProperty();
        public static final StaticAnimationProperty<List<InverseKinematicsSimulator.BakedInverseKinematicsDefinition>> BAKED_IK_DEFINITION = new StaticAnimationProperty();
        public static final StaticAnimationProperty<LivingMotion> RESET_LIVING_MOTION = new StaticAnimationProperty();

        public StaticAnimationProperty(String rl, @Nullable Codec<T> codecs) {
            super(rl, codecs);
        }

        public StaticAnimationProperty() {
            this(null, null);
        }
    }
}

