/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input.handlers;

import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.api.client.input.handlers.DiscreteActionHandler;

@ApiStatus.Internal
public final class DiscreteInputActionTrigger {
    private DiscreteInputActionTrigger() {
    }

    @Nullable
    private static IEpicFightControllerMod getControllerModApi() {
        return EpicFightControllerModProvider.get();
    }

    public static void triggerOnPress(EpicFightInputActions action, DiscreteActionHandler handler) {
        IEpicFightControllerMod controllerMod = DiscreteInputActionTrigger.getControllerModApi();
        KeyMapping keyMapping = action.keyMapping();
        if (controllerMod == null) {
            DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
            return;
        }
        switch (controllerMod.getInputMode()) {
            case MIXED: {
                boolean handled = DiscreteInputActionTrigger.handleController(controllerMod.getBinding(action), handler);
                if (handled) {
                    return;
                }
                DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
                break;
            }
            case CONTROLLER: {
                DiscreteInputActionTrigger.handleController(controllerMod.getBinding(action), handler);
                break;
            }
            case KEYBOARD_MOUSE: {
                DiscreteInputActionTrigger.handleKeyboardAndMouse(keyMapping, handler);
            }
        }
    }

    private static void handleKeyboardAndMouse(KeyMapping keyMapping, DiscreteActionHandler handler) {
        while (keyMapping.consumeClick()) {
            handler.onAction(DiscreteInputActionTrigger.createContext(false));
        }
    }

    private static boolean handleController(ControllerBinding controllerBinding, DiscreteActionHandler handler) {
        if (controllerBinding.isDigitalJustPressed()) {
            handler.onAction(DiscreteInputActionTrigger.createContext(true));
            return true;
        }
        return false;
    }

    @NotNull
    private static DiscreteActionHandler.Context createContext(boolean triggeredByController) {
        return new DiscreteActionHandler.Context(triggeredByController);
    }
}

