/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.widgets;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.datapack.widgets.DataBindingComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.TickableComponent;

@OnlyIn(value=Dist.CLIENT)
public abstract class InputComponentList<T>
extends ContainerObjectSelectionList<InputComponentEntry> {
    private final Screen owner;
    private final List<DataBindingComponent<?, ?>> dataBindingComponent = Lists.newArrayList();
    private InputComponentEntry lastEntry;
    private InputComponentEntry focusingEntry;

    public InputComponentList(Screen owner, int width, int height, int y, int itemHeight) {
        super(owner.getMinecraft(), width, height, y, itemHeight);
        this.owner = owner;
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public int nextStart(int spacing) {
        int xPos;
        if (this.lastEntry.children.size() == 0) {
            xPos = 0;
        } else {
            ResizableComponent lastWidget = this.lastEntry.children.get(this.lastEntry.children.size() - 1);
            xPos = lastWidget._getX() + lastWidget._getWidth();
        }
        return xPos + spacing;
    }

    public void addComponentCurrentRow(ResizableComponent inputWidget) {
        this.lastEntry.children.add(inputWidget);
        if (inputWidget instanceof DataBindingComponent) {
            DataBindingComponent dataBindingComponent = (DataBindingComponent)inputWidget;
            this.dataBindingComponent.add(dataBindingComponent);
        }
    }

    public void setDataBindingComponenets(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            DataBindingComponent<?, ?> dataBinder = this.dataBindingComponent.get(i);
            try {
                Consumer<?> consumer = dataBinder._getResponder();
                dataBinder._setResponder(null);
                dataBinder._setValue(values[i]);
                dataBinder._setResponder(consumer);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException(String.format("Error while binding %sst component [%s] because of %s", String.valueOf(i), dataBinder._getMessage(), e.getMessage()));
            }
        }
    }

    public void newRow() {
        this.lastEntry = new InputComponentEntry();
        this.addEntry((AbstractSelectionList.Entry)this.lastEntry);
    }

    public void clearComponents() {
        this.children().clear();
        this.focusingEntry = null;
        this.dataBindingComponent.clear();
    }

    public void setComponentsActive(boolean active) {
        for (InputComponentEntry e : this.children()) {
            for (ResizableComponent componenet : e.children) {
                componenet._setActive(active);
            }
        }
    }

    public void resetComponents() {
        this.dataBindingComponent.forEach(dataBinder -> dataBinder.reset());
    }

    public <O extends ResizableComponent> O getComponent(int row, int column) {
        return (O)((InputComponentEntry)((Object)this.children().get((int)row))).children.get(column);
    }

    public abstract void importTag(T var1);

    public void updateSizeAndPosition(int width, int height, int y) {
        super.updateSizeAndPosition(width, height, y);
        for (InputComponentEntry entry : this.children()) {
            for (ResizableComponent resizableComponent : entry.children()) {
                resizableComponent.resize(this.getRectangle());
            }
        }
    }

    public void setX(int xPos) {
        super.setX(xPos);
        for (InputComponentEntry entry : this.children()) {
            for (ResizableComponent resizableComponent : entry.children()) {
                resizableComponent.resize(this.getRectangle());
            }
        }
    }

    public void tick() {
        for (InputComponentEntry entry : this.children()) {
            for (ResizableComponent resizableComponent : entry.children()) {
                if (!(resizableComponent instanceof TickableComponent)) continue;
                TickableComponent tickableComponent = (TickableComponent)((Object)resizableComponent);
                tickableComponent._tick();
            }
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        int i;
        if (!this.isMouseOver(x, y)) {
            return false;
        }
        this.updateScrollingState(x, y, button);
        if (this.focusingEntry != null) {
            i = this.children().indexOf((Object)this.focusingEntry);
            int j1 = this.getRowTop(i);
            int k1 = this.getRowBottom(i);
            if (k1 >= this.getY() && j1 <= this.getBottom()) {
                boolean pressed = false;
                for (GuiEventListener guiEventListener : this.focusingEntry.children()) {
                    boolean bl = guiEventListener.mouseClicked(x, y, button);
                    pressed |= bl;
                    if (!bl) continue;
                    this.owner.setFocused(guiEventListener);
                }
                if (pressed) {
                    return false;
                }
            }
        }
        for (i = 0; i < this.children().size(); ++i) {
            InputComponentEntry entry = (InputComponentEntry)((Object)this.children().get(i));
            if (entry == this.focusingEntry) continue;
            int j1 = this.getRowTop(i);
            int k1 = this.getRowBottom(i);
            if (k1 < this.getY() || j1 > this.getBottom()) continue;
            boolean pressed = false;
            for (GuiEventListener guiEventListener : entry.children()) {
                boolean mouseClicked = guiEventListener.mouseClicked(x, y, button);
                pressed |= mouseClicked;
                if (!mouseClicked) continue;
                this.owner.setFocused(guiEventListener);
            }
            if (!pressed) continue;
            this.focusingEntry = entry;
            return false;
        }
        return false;
    }

    public boolean mouseScrolled(double x, double y, double xScroll, double yScroll) {
        for (int i = 0; i < this.children().size(); ++i) {
            InputComponentEntry entry = (InputComponentEntry)((Object)this.children().get(i));
            int j1 = this.getRowTop(i);
            int k1 = this.getRowBottom(i);
            if (k1 < this.getY() || j1 > this.getBottom() || !entry.getChildAt(x, y).filter(component -> component.mouseScrolled(x, y, xScroll, yScroll)).isPresent()) continue;
            return true;
        }
        return super.mouseScrolled(x, y, xScroll, yScroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        for (int i = 0; i < this.children().size(); ++i) {
            InputComponentEntry entry = (InputComponentEntry)((Object)this.children().get(i));
            int j1 = this.getRowTop(i);
            int k1 = this.getRowBottom(i);
            if (k1 < this.getY() || j1 > this.getBottom() || !entry.getChildAt(mouseX, mouseY).filter(component -> component.mouseDragged(mouseX, mouseY, button, dx, dy)).isPresent()) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class InputComponentEntry
    extends ContainerObjectSelectionList.Entry<InputComponentEntry> {
        final List<ResizableComponent> children = Lists.newArrayList();

        public Optional<GuiEventListener> getChildAt(double x, double y) {
            for (GuiEventListener guiEventListener : this.children) {
                if (!guiEventListener.isMouseOver(x, y)) continue;
                return Optional.of(guiEventListener);
            }
            return Optional.empty();
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            for (ResizableComponent widget : this.children) {
                widget.relocateY(InputComponentList.this.owner.getRectangle(), top + InputComponentList.this.itemHeight / 2 - widget._getHeight() / 2);
                widget._renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }

        public List<? extends ResizableComponent> children() {
            return this.children;
        }

        public List<? extends ResizableComponent> narratables() {
            return this.children;
        }
    }
}

