/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.SkillContainer;

@OnlyIn(value=Dist.CLIENT)
public class SlotSelectScreen
extends Screen {
    private static final int MAX_ROWS = 2;
    private static final int MAX_COLUMNS = 3;
    private static final int STRIDE = 60;
    private final SkillBookScreen parent;
    private final List<SkillContainer> containers;
    private final List<SlotButton> slotButtons = new ArrayList<SlotButton>();
    private int maxScroll;
    private int scroll = 0;

    public SlotSelectScreen(Set<SkillContainer> containers, SkillBookScreen parent) {
        super((Component)Component.empty());
        this.parent = parent;
        this.containers = containers.stream().sorted((c1, c2) -> {
            if (c1.getSlotId() > c2.getSlotId()) {
                return 1;
            }
            if (c1.getSlotId() < c2.getSlotId()) {
                return -1;
            }
            return 0;
        }).toList();
    }

    protected void init() {
        this.parent.init(this.minecraft, this.width, this.height);
        int buttonX = this.width / 2 - 84;
        int buttonY = this.height / 2 - 40;
        int columns = 0;
        this.maxScroll = Math.max(this.containers.size() / 3 + 1 - 2, 0);
        if (this.maxScroll > 0) {
            this.addRenderableWidget((GuiEventListener)new ScrollArrow(this.width / 2 - 8, this.height / 2 - 98, 16, 16, button -> this.scrollUp(), true));
            this.addRenderableWidget((GuiEventListener)new ScrollArrow(this.width / 2 - 8, this.height / 2 + 82, 16, 16, button -> this.scrollDown(), false));
        }
        this.slotButtons.clear();
        for (SkillContainer container : this.containers) {
            String slotName = container.getSlot().toString().toLowerCase(Locale.ROOT);
            String skillName = container.getSkill() == null ? "Empty" : Component.translatable((String)container.getSkill().getTranslationKey()).getString();
            SlotButton slotbutton = new SlotButton(this, buttonX, buttonY, 48, 48, (Component)Component.literal((String)(slotName + ": " + skillName)), container.getSkill() == null ? SkillEditScreen.EMPTY_SKILL_SLOT_ICON : container.getSkill().getSkillTexture(), button -> {
                this.parent.acquireSkillTo(container);
                if (this.minecraft.screen == this) {
                    this.onClose();
                }
            });
            if (!this.parent.consumesItem() && container.onReplaceCooldown()) {
                slotbutton.active = false;
                slotbutton.setTooltip(Tooltip.create((Component)Component.literal((String)(slotName + ": " + skillName + "\n")).append((Component)Component.translatable((String)EpicFightMod.format("gui.%s.container_on_cooldown"), (Object[])new Object[]{container.getReplaceCooldown() / 20}))));
            }
            buttonX += 60;
            if (++columns >= 3) {
                buttonX = this.width / 2 - 84;
                buttonY += 60;
                columns = 0;
            }
            this.slotButtons.add(slotbutton);
            this.addRenderableWidget((GuiEventListener)slotbutton);
        }
        this.scroll = 0;
        this.setScrollVisibilities();
    }

    protected void scrollUp() {
        int nextScroll = Mth.clamp((int)(this.scroll - 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.forEach(button -> button.setY(button.getY() + 60));
            this.setScrollVisibilities();
        }
    }

    protected void scrollDown() {
        int nextScroll = Mth.clamp((int)(this.scroll + 1), (int)0, (int)this.maxScroll);
        if (this.scroll != nextScroll) {
            this.scroll = nextScroll;
            this.slotButtons.forEach(button -> button.setY(button.getY() - 60));
            this.setScrollVisibilities();
        }
    }

    protected void setScrollVisibilities() {
        int i = 0;
        for (SlotButton slotButton : this.slotButtons) {
            slotButton.visible = i / 3 >= this.scroll && i / 3 < this.scroll + 2;
            ++i;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        if (yScroll > 0.0) {
            this.scrollUp();
        } else {
            this.scrollDown();
        }
        return true;
    }

    public void onClose() {
        if (this.parent != null) {
            this.minecraft.setScreen((Screen)this.parent);
        } else {
            super.onClose();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int boxWidth = 192;
        int boxHeight = 160;
        int left = (this.width - boxWidth) / 2;
        int top = (this.height - boxHeight) / 2;
        this.parent.render(guiGraphics, mouseX, mouseY, partialTick, true);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().translate(0.0f, 0.0f, 5000.0f);
        guiGraphics.fill(left, top, left + boxWidth, top + boxHeight, -6250336);
        guiGraphics.fill(left + 1, top + 1, left + boxWidth - 1, top + boxHeight - 1, -16777215);
        MutableComponent component = Component.translatable((String)EpicFightMod.format("gui.%s.select_slot_tooltip"));
        int lineHeight = 0;
        for (FormattedCharSequence s : this.font.split((FormattedText)component, 250)) {
            guiGraphics.drawString(this.font, s, (this.width - boxWidth) / 2 + 8, this.height / 2 - 70 + lineHeight, -1513240, false);
            lineHeight += 10;
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ScrollArrow
    extends Button {
        final boolean up;

        protected ScrollArrow(int x, int y, int width, int height, Button.OnPress onPress, boolean up) {
            super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.up = up;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.up && SlotSelectScreen.this.scroll != 0) {
                guiGraphics.blit(SkillEditScreen.SCROLL_ARROW_UP, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 16, 16, 16, 16);
            } else if (!this.up && SlotSelectScreen.this.scroll != SlotSelectScreen.this.maxScroll) {
                guiGraphics.blit(SkillEditScreen.SCROLL_ARROW_DOWN, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        protected boolean clicked(double mouseX, double mouseY) {
            return super.clicked(mouseX, mouseY) && (this.up && SlotSelectScreen.this.scroll != 0 || !this.up && SlotSelectScreen.this.scroll != SlotSelectScreen.this.maxScroll);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SlotButton
    extends Button {
        final ResourceLocation texture;

        protected SlotButton(SlotSelectScreen this$0, int x, int y, int width, int height, Component tooltip, ResourceLocation textureLocation, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.texture = textureLocation;
            this.setTooltip(Tooltip.create((Component)tooltip));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            RenderSystem.enableBlend();
            if (!this.active) {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            guiGraphics.blit(this.texture, this.getX() + 2, this.getY() + 2, this.width - 4, this.height - 4, 0.0f, 0.0f, 32, 32, 32, 32);
            if (!this.active) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
        }
    }
}

