/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class AimHelperRenderer {
    public void doRender(PoseStack poseStack, float partialTick) {
        if (!ClientConfig.enableAimHelper) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer entity = minecraft.player;
        Optional<LocalPlayerPatch> entitypatchOpt = EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)entity, LocalPlayerPatch.class);
        HitResult rayHit = entitypatchOpt.isEmpty() ? entity.pick(200.0, partialTick, false) : AimHelperRenderer.pick(entitypatchOpt.get(), 200.0, partialTick);
        Vec3 vec3 = rayHit.getLocation();
        Vec3f pos1 = new Vec3f((float)Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX()), (float)Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY()) + entity.getEyeHeight() - 0.15f, (float)Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ()));
        Vec3f pos2 = new Vec3f((float)vec3.x, (float)vec3.y, (float)vec3.z);
        Camera renderInfo = minecraft.gameRenderer.getMainCamera();
        Vec3 projectedView = renderInfo.getPosition();
        poseStack.pushPose();
        poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        Matrix4f matrix = poseStack.last().pose();
        int color = ClientConfig.aimHelperPackedColor;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)2.0f);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        bufferBuilder.addVertex(matrix, pos2.x, pos2.y, pos2.z).setColor(f1, f2, f3, 0.5f).setNormal(pos2.x - pos1.x, pos2.y - pos1.y, pos2.z - pos1.z);
        bufferBuilder.addVertex(matrix, pos1.x, pos1.y, pos1.z).setColor(f1, f2, f3, 0.5f).setNormal(pos2.x - pos1.x, pos2.y - pos1.y, pos2.z - pos1.z);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        poseStack.popPose();
    }

    public static HitResult pick(LocalPlayerPatch entitypatch, double hitDistance, float partialTick) {
        Vec3 vec3 = ((LocalPlayer)entitypatch.getOriginal()).getEyePosition(partialTick);
        Vec3 vec31 = entitypatch.getViewVector(partialTick);
        Vec3 vec32 = vec3.add(vec31.x * hitDistance, vec31.y * hitDistance, vec31.z * hitDistance);
        return entitypatch.getLevel().clip(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entitypatch.getOriginal()));
    }
}

