/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.online.EpicSkins;
import yesman.epicfight.api.client.physics.cloth.ClothSimulator;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedLayer;
import yesman.epicfight.client.world.capabilites.entitypatch.player.AbstractClientPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;

@OnlyIn(value=Dist.CLIENT)
public class PatchedCapeLayer
extends PatchedLayer<AbstractClientPlayer, AbstractClientPlayerPatch<AbstractClientPlayer>, PlayerModel<AbstractClientPlayer>, CapeLayer> {
    @Override
    protected void renderLayer(AbstractClientPlayerPatch<AbstractClientPlayer> entitypatch, AbstractClientPlayer entityliving, CapeLayer vanillaLayer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTick) {
        ItemStack itemstack;
        if (ClientConfig.enableCosmetics) {
            if (Minecraft.getInstance().screen instanceof EffectRenderingInventoryScreen && entityliving == Minecraft.getInstance().player && partialTick == 1.0f) {
                return;
            }
            entitypatch.getClothSimulator().getRunningObject(ClothSimulator.PLAYER_CLOAK).ifPresent(clothObj -> {
                ResourceLocation capeTexture;
                ResourceLocation resourceLocation = capeTexture = entitypatch.isEpicSkinsLoaded() ? entitypatch.getEpicSkinsInformation().capeTexture().get() : entityliving.getSkin().capeTexture();
                if (capeTexture != null) {
                    Function<Float, OpenMatrix4f> partialColliderTransformProvider = partialFrame -> {
                        Vec3 pos = ((AbstractClientPlayer)entitypatch.getOriginal()).getPosition(partialFrame.floatValue());
                        float yRotLerp = Mth.rotLerp((float)partialFrame.floatValue(), (float)entitypatch.getYRotO(), (float)entitypatch.getYRot());
                        return OpenMatrix4f.createTranslation((float)pos.x, (float)pos.y, (float)pos.z).rotateDeg(180.0f - yRotLerp, Vec3f.Y_AXIS);
                    };
                    clothObj.tick(entitypatch, partialColliderTransformProvider, partialTick, entitypatch.getArmature(), poses);
                    double entityX = Mth.lerp((double)partialTick, (double)entityliving.xOld, (double)entityliving.getX());
                    double entityY = Mth.lerp((double)partialTick, (double)entityliving.yOld, (double)entityliving.getY());
                    double entityZ = Mth.lerp((double)partialTick, (double)entityliving.zOld, (double)entityliving.getZ());
                    PoseStack posestack$2 = new PoseStack();
                    PatchedEntityRenderer renderer = RenderEngine.getInstance().getEntityRenderer(EntityType.PLAYER);
                    renderer.mulPoseStack(posestack$2, entitypatch.getArmature(), (LivingEntity)entitypatch.getOriginal(), entitypatch, partialTick);
                    Matrix4f renderLocalPose = posestack$2.last().pose();
                    float bodyYRot = Mth.rotLerp((float)partialTick, (float)entitypatch.getYRotO(), (float)entitypatch.getYRot());
                    if (entitypatch.isEpicSkinsLoaded()) {
                        EpicSkins epicskinsInfo = entitypatch.getEpicSkinsInformation();
                        PatchedCapeLayer.renderSimulatingCape(poseStack, buffer, RenderType.entityCutoutNoCull((ResourceLocation)capeTexture), Mesh.DrawingFunction.NEW_ENTITY, clothObj, entityX, entityY, entityZ, epicskinsInfo.r(), epicskinsInfo.g(), epicskinsInfo.b(), 1.0f, entitypatch, poses, packedLight, renderLocalPose, bodyYRot);
                    } else {
                        PatchedCapeLayer.renderSimulatingCape(poseStack, buffer, RenderType.entityCutoutNoCull((ResourceLocation)capeTexture), Mesh.DrawingFunction.NEW_ENTITY, clothObj, entityX, entityY, entityZ, 1.0f, 1.0f, 1.0f, 1.0f, entitypatch, poses, packedLight, renderLocalPose, bodyYRot);
                    }
                }
            });
        } else if (entityliving.getSkin().capeTexture() != null && !entityliving.isInvisible() && entityliving.isModelPartShown(PlayerModelPart.CAPE) && (itemstack = entityliving.getItemBySlot(EquipmentSlot.CHEST)).getItem() != Items.ELYTRA) {
            OpenMatrix4f modelMatrix = new OpenMatrix4f();
            modelMatrix.scale(new Vec3f(-1.0f, -1.0f, 1.0f)).mulFront(poses[8]);
            poseStack.pushPose();
            MathUtils.mulStack(poseStack, modelMatrix);
            poseStack.translate(0.0, -0.4, -0.025);
            vanillaLayer.render(poseStack, buffer, packedLight, entityliving, entityliving.walkAnimation.position(), entityliving.walkAnimation.speed(), partialTick, (float)entityliving.tickCount, yRot, xRot);
            poseStack.popPose();
        }
    }

    public static void renderSimulatingCape(PoseStack poseStack, MultiBufferSource buffers, RenderType rendertype, Mesh.DrawingFunction drawFunction, ClothSimulator.ClothObject clothObj, double x, double y, double z, float r, float g, float b, float a, AbstractClientPlayerPatch<?> entitypatch, OpenMatrix4f[] poses, int packedLight, Matrix4f renderLocalMatrix, float yBodyRot) {
        poseStack.pushPose();
        float scaler = entitypatch.getScale();
        poseStack.scale(scaler, scaler, scaler);
        if (((AbstractClientPlayer)entitypatch.getOriginal()).hasItemInSlot(EquipmentSlot.CHEST)) {
            OpenMatrix4f poseMat = poses[((HumanoidArmature)Armatures.BIPED.get()).chest.getId()];
            poseStack.translate(poseMat.m30, poseMat.m31, poseMat.m32);
            poseStack.scale(1.17f, 1.17f, 1.17f);
            poseStack.translate(-poseMat.m30, -poseMat.m31, -poseMat.m32);
        }
        clothObj.scaleFromPose(poseStack, poses);
        poseStack.pushPose();
        renderLocalMatrix = renderLocalMatrix.invert(new Matrix4f());
        poseStack.mulPose(renderLocalMatrix);
        poseStack.translate((double)(-renderLocalMatrix.m30()) - x, (double)(-renderLocalMatrix.m31()) - y, (double)(-renderLocalMatrix.m32()) - z);
        poseStack.last().normal().rotate((Quaternionfc)QuaternionUtils.YP.rotationDegrees(yBodyRot));
        clothObj.drawPosed(poseStack, buffers.getBuffer(EpicFightRenderTypes.getTriangulated(rendertype)), drawFunction, packedLight, r, g, b, a, OverlayTexture.NO_OVERLAY, entitypatch.getArmature(), poses);
        poseStack.popPose();
        poseStack.popPose();
    }
}

