/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat.controlify;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.guide.ActionLocation;
import dev.isxander.controlify.api.guide.Fact;
import dev.isxander.controlify.api.guide.GuideDomainRegistry;
import dev.isxander.controlify.api.guide.InGameCtx;
import dev.isxander.controlify.api.guide.InGameFacts;
import dev.isxander.controlify.api.guide.Rule;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.bindings.input.InputType;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.PlayerInputState;
import yesman.epicfight.api.client.input.action.EpicFightInputActions;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.client.input.controller.EpicFightControllerModProvider;
import yesman.epicfight.api.client.input.controller.IEpicFightControllerMod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.client.gui.screen.SkillEditScreen;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;

@ApiStatus.Internal
public class ControlifyCompat
implements ControlifyEntrypoint {
    private static InputBindingSupplier attack;
    private static InputBindingSupplier mobility;
    private static InputBindingSupplier guard;
    private static InputBindingSupplier dodge;
    private static InputBindingSupplier lockOn;
    private static InputBindingSupplier switchMode;
    private static InputBindingSupplier weaponInnateSkill;
    private static InputBindingSupplier weaponInnateSkillTooltip;
    private static InputBindingSupplier openSkillEditorScreen;
    private static InputBindingSupplier openConfigScreen;
    private static InputBindingSupplier switchVanillaModeDebugging;
    private static final BindContext COMBAT_MODE_CONTEXT;
    private static final BindContext IN_GAME_CONTEXT;
    private static final BindContext ANY_SCREEN_CONTEXT;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
        ControlifyCompat.registerModIntegration();
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        ControlifyCompat.registerCustomRadialIcons();
        registrar.registerBindContext(COMBAT_MODE_CONTEXT);
        ControlifyCompat.registerInputBindings(registrar);
        ControlifyCompat.registerTargetLockOnSupport();
        ControlifyCompat.registerInGameGuides((GuideDomainRegistry<InGameCtx>)context.guideRegistries().inGame());
        ControlifyCompat.registerScreenProcessors();
    }

    private static void registerCustomRadialIcons() {
        for (EpicFightRadialIcons icon : EpicFightRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                CGuiPose pose = CGuiPose.ofPush((GuiGraphics)graphics);
                pose.translate((float)x, (float)y);
                pose.scale(0.5f, 0.5f);
                Blit.tex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                pose.pop();
            });
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        for (EpicFightInputActions action : EpicFightInputActions.nonVanillaActions()) {
            ControlifyCompat.registerInputBinding(registrar, action);
        }
    }

    @NotNull
    private static InputBindingSupplier registerInputBinding(@NotNull ControlifyBindApi registrar, @NotNull EpicFightInputActions action) {
        Component combatCategory = ComponentConstants.KEY_COMBAT;
        Component guiCategory = ComponentConstants.KEY_GUI;
        Component systemCategory = ComponentConstants.KEY_SYSTEM;
        KeyMapping keyMappingToDisable = action.keyMapping();
        return switch (action) {
            default -> throw new MatchException(null, null);
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY, EpicFightInputActions.USE, EpicFightInputActions.SWAP_OFF_HAND, EpicFightInputActions.TOGGLE_PERSPECTIVE, EpicFightInputActions.DROP, EpicFightInputActions.MOVE_FORWARD, EpicFightInputActions.MOVE_BACKWARD, EpicFightInputActions.MOVE_LEFT, EpicFightInputActions.MOVE_RIGHT, EpicFightInputActions.SPRINT, EpicFightInputActions.SNEAK, EpicFightInputActions.JUMP -> throw new IllegalArgumentException("ControlifyCompat#registerInputBinding() must only be called for non-vanilla actions. This action is vanilla and already registered by Controlify: " + action.name());
            case EpicFightInputActions.ATTACK -> attack = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("attack")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_ATTACK).description(ComponentConstants.KEY_ATTACK_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.MOBILITY -> mobility = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("mobility")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_MOVER_SKILL).description(ComponentConstants.KEY_MOVER_SKILL_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.GUARD -> guard = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("guard")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_GUARD).description(ComponentConstants.KEY_GUARD_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.DODGE -> dodge = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("dodge")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_DODGE).description(ComponentConstants.KEY_DODGE_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.LOCK_ON -> lockOn = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("lock_on")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_LOCK_ON).description(ComponentConstants.KEY_LOCK_ON_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.SWITCH_MODE -> switchMode = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("switch_mode")).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SWITCH_MODE).description(ComponentConstants.KEY_SWITCH_MODE_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(EpicFightRadialIcons.UCHIGATANA.getId()));
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("weapon_innate_skill")).category(combatCategory).allowedContexts(new BindContext[]{COMBAT_MODE_CONTEXT}).name(ComponentConstants.KEY_WEAPON_INNATE_SKILL).description(ComponentConstants.KEY_WEAPON_INNATE_SKILL_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("weapon_innate_skill_tooltip")).category(guiCategory).allowedContexts(new BindContext[]{ANY_SCREEN_CONTEXT}).name(ComponentConstants.WEAPON_INNATE_SKILL_TOOLTIP).description(ComponentConstants.WEAPON_INNATE_SKILL_TOOLTIP_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("open_skill_editor_screen")).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SKILL_GUI).description(ComponentConstants.KEY_SKILL_GUI_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(EpicFightRadialIcons.SKILL_BOOK.getId()));
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("open_config_screen")).category(guiCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_CONFIG).description(ComponentConstants.KEY_CONFIG_DESCRIPTION).addKeyCorrelation(keyMappingToDisable).radialCandidate(RadialIcons.getItem((Item)Items.REDSTONE)));
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging = registrar.registerBinding(builder -> builder.id(EpicFightMod.rl("switch_vanilla_mode_debugging")).category(systemCategory).allowedContexts(new BindContext[]{IN_GAME_CONTEXT}).name(ComponentConstants.KEY_SWITCH_VANILLA_MODEL_DEBUG).description(ComponentConstants.KEY_SWITCH_VANILLA_MODEL_DEBUG_DESCRIPTION).addKeyCorrelation(keyMappingToDisable));
        };
    }

    private static void registerModIntegration() {
        EpicFightControllerModProvider.set("epicfight", new ControlifyIntegration());
    }

    private static void registerTargetLockOnSupport() {
        ControlifyEvents.LOOK_INPUT_MODIFIER.register(event -> {
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch != null && localPlayerPatch.isTargetLockedOn()) {
                event.lookInput().zero();
            }
        });
    }

    private static void registerInGameGuides(GuideDomainRegistry<InGameCtx> registry) {
        registry.registerDynamicRule(Rule.builder().binding(dodge).where(ActionLocation.RIGHT).then(ComponentConstants.KEY_DODGE).build());
        registry.registerDynamicRule(Rule.builder().binding(lockOn).where(ActionLocation.LEFT).when(new Fact[]{InGameFacts.LOOKING_AT_ENTITY}).then(ComponentConstants.KEY_LOCK_ON).build());
    }

    @NotNull
    private static InputBinding getControlifyBinding(@NotNull EpicFightInputActions action) {
        InputBindingSupplier bindingSupplier = switch (action) {
            default -> throw new MatchException(null, null);
            case EpicFightInputActions.VANILLA_ATTACK_DESTROY -> ControlifyBindings.ATTACK;
            case EpicFightInputActions.USE -> ControlifyBindings.USE;
            case EpicFightInputActions.SWAP_OFF_HAND -> ControlifyBindings.SWAP_HANDS;
            case EpicFightInputActions.DROP -> ControlifyBindings.DROP_INGAME;
            case EpicFightInputActions.TOGGLE_PERSPECTIVE -> ControlifyBindings.CHANGE_PERSPECTIVE;
            case EpicFightInputActions.ATTACK -> attack;
            case EpicFightInputActions.JUMP -> ControlifyBindings.JUMP;
            case EpicFightInputActions.MOBILITY -> mobility;
            case EpicFightInputActions.GUARD -> guard;
            case EpicFightInputActions.DODGE -> dodge;
            case EpicFightInputActions.LOCK_ON -> lockOn;
            case EpicFightInputActions.SWITCH_MODE -> switchMode;
            case EpicFightInputActions.WEAPON_INNATE_SKILL -> weaponInnateSkill;
            case EpicFightInputActions.WEAPON_INNATE_SKILL_TOOLTIP -> weaponInnateSkillTooltip;
            case EpicFightInputActions.MOVE_FORWARD -> ControlifyBindings.WALK_FORWARD;
            case EpicFightInputActions.MOVE_BACKWARD -> ControlifyBindings.WALK_BACKWARD;
            case EpicFightInputActions.MOVE_LEFT -> ControlifyBindings.WALK_LEFT;
            case EpicFightInputActions.MOVE_RIGHT -> ControlifyBindings.WALK_RIGHT;
            case EpicFightInputActions.SPRINT -> ControlifyBindings.SPRINT;
            case EpicFightInputActions.SNEAK -> ControlifyBindings.SNEAK;
            case EpicFightInputActions.OPEN_SKILL_SCREEN -> openSkillEditorScreen;
            case EpicFightInputActions.OPEN_CONFIG_SCREEN -> openConfigScreen;
            case EpicFightInputActions.SWITCH_VANILLA_MODEL_DEBUGGING -> switchVanillaModeDebugging;
        };
        @Nullable InputBinding binding = bindingSupplier.onOrNull(ControlifyCompat.requireControllerEntity());
        return Objects.requireNonNull(binding, "The binding for the action " + action.name() + " is not yet registered.");
    }

    @NotNull
    private static ControlifyApi getApi() {
        return ControlifyApi.get();
    }

    @NotNull
    private static ControllerEntity requireControllerEntity() {
        Optional optionalControllerEntity = ControlifyCompat.getApi().getCurrentController();
        if (optionalControllerEntity.isEmpty()) {
            String message = String.format("The method IEpicFightControllerMod#getInputState must not be called when the input mode is not %s", yesman.epicfight.api.client.input.InputMode.CONTROLLER.name());
            EpicFightMod.LOGGER.error(message);
            throw new IllegalStateException(message);
        }
        return (ControllerEntity)optionalControllerEntity.get();
    }

    private static void registerScreenProcessors() {
        ScreenProcessorProvider.registerProvider(SkillEditScreen.class, SkillEditScreenProcessor::new);
        ScreenProcessorProvider.registerProvider(SkillBookScreen.class, SkillBookScreenProcessor::new);
    }

    static {
        COMBAT_MODE_CONTEXT = new BindContext(EpicFightMod.rl("epicfight_combat"), mc -> {
            boolean isInGame = mc.screen == null && mc.level != null && mc.player != null;
            return isInGame && ClientEngine.getInstance().isEpicFightMode();
        });
        IN_GAME_CONTEXT = BindContext.IN_GAME;
        ANY_SCREEN_CONTEXT = BindContext.ANY_SCREEN;
    }

    private static enum EpicFightRadialIcons {
        UCHIGATANA(EpicFightMod.rl("textures/item/uchigatana_gui.png")),
        SKILL_BOOK(EpicFightMod.rl("textures/item/skillbook.png"));

        @NotNull
        private final ResourceLocation id;

        private EpicFightRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class ComponentConstants {
        private static final Component KEY_COMBAT = Component.translatable((String)"key.epicfight.combat");
        private static final Component KEY_GUI = Component.translatable((String)"key.epicfight.gui");
        private static final Component KEY_SYSTEM = Component.translatable((String)"key.epicfight.system");
        private static final Component WEAPON_INNATE_SKILL_TOOLTIP = Component.translatable((String)"key.epicfight.show_tooltip");
        private static final Component KEY_SWITCH_MODE = Component.translatable((String)"key.epicfight.switch_mode");
        private static final Component KEY_ATTACK = Component.translatable((String)"key.epicfight.attack");
        private static final Component KEY_WEAPON_INNATE_SKILL = Component.translatable((String)"key.epicfight.weapon_innate_skill");
        private static final Component KEY_SKILL_GUI = Component.translatable((String)"key.epicfight.skill_gui");
        private static final Component KEY_DODGE = Component.translatable((String)"key.epicfight.dodge");
        private static final Component KEY_GUARD = Component.translatable((String)"key.epicfight.guard");
        private static final Component KEY_LOCK_ON = Component.translatable((String)"key.epicfight.lock_on");
        private static final Component KEY_MOVER_SKILL = Component.translatable((String)"key.epicfight.mover_skill");
        private static final Component KEY_CONFIG = Component.translatable((String)"key.epicfight.config");
        private static final Component KEY_SWITCH_VANILLA_MODEL_DEBUG = Component.translatable((String)"key.epicfight.switch_vanilla_model_debug");
        private static final Component WEAPON_INNATE_SKILL_TOOLTIP_DESCRIPTION = Component.translatable((String)"key.epicfight.show_tooltip.description");
        private static final Component KEY_SWITCH_MODE_DESCRIPTION = Component.translatable((String)"key.epicfight.switch_mode.description");
        private static final Component KEY_ATTACK_DESCRIPTION = Component.translatable((String)"key.epicfight.attack.description");
        private static final Component KEY_WEAPON_INNATE_SKILL_DESCRIPTION = Component.translatable((String)"key.epicfight.weapon_innate_skill.description");
        private static final Component KEY_SKILL_GUI_DESCRIPTION = Component.translatable((String)"key.epicfight.skill_gui.description");
        private static final Component KEY_DODGE_DESCRIPTION = Component.translatable((String)"key.epicfight.dodge.description");
        private static final Component KEY_GUARD_DESCRIPTION = Component.translatable((String)"key.epicfight.guard.description");
        private static final Component KEY_LOCK_ON_DESCRIPTION = Component.translatable((String)"key.epicfight.lock_on.description");
        private static final Component KEY_MOVER_SKILL_DESCRIPTION = Component.translatable((String)"key.epicfight.mover_skill.description");
        private static final Component KEY_CONFIG_DESCRIPTION = Component.translatable((String)"key.epicfight.config.description");
        private static final Component KEY_SWITCH_VANILLA_MODEL_DEBUG_DESCRIPTION = Component.translatable((String)"key.epicfight.switch_vanilla_model_debug.description");

        private ComponentConstants() {
        }
    }

    private static class ControlifyIntegration
    implements IEpicFightControllerMod {
        private ControlifyIntegration() {
        }

        @Override
        public String getModName() {
            return "Controlify";
        }

        @Override
        @NotNull
        public yesman.epicfight.api.client.input.InputMode getInputMode() {
            return switch (ControlifyCompat.getApi().currentInputMode()) {
                default -> throw new MatchException(null, null);
                case InputMode.KEYBOARD_MOUSE -> yesman.epicfight.api.client.input.InputMode.KEYBOARD_MOUSE;
                case InputMode.CONTROLLER -> yesman.epicfight.api.client.input.InputMode.CONTROLLER;
                case InputMode.MIXED -> yesman.epicfight.api.client.input.InputMode.MIXED;
            };
        }

        @Override
        @NotNull
        public ControllerBinding getBinding(EpicFightInputActions action) {
            return new ControllerBindingImpl(ControlifyCompat.getControlifyBinding(action));
        }

        @Override
        @NotNull
        public PlayerInputState getInputState() {
            ControllerEntity controller = ControlifyCompat.requireControllerEntity();
            InputBinding forwardBind = ControlifyBindings.WALK_FORWARD.on(controller);
            InputBinding backwardBind = ControlifyBindings.WALK_BACKWARD.on(controller);
            InputBinding leftBind = ControlifyBindings.WALK_LEFT.on(controller);
            InputBinding rightBind = ControlifyBindings.WALK_RIGHT.on(controller);
            InputBinding jumpBind = ControlifyBindings.JUMP.on(controller);
            InputBinding sneakBind = ControlifyBindings.SNEAK.on(controller);
            float forwardImpulse = forwardBind.analogueNow() - backwardBind.analogueNow();
            float leftImpulse = leftBind.analogueNow() - rightBind.analogueNow();
            return new PlayerInputState(leftImpulse, forwardImpulse, forwardBind.digitalNow(), backwardBind.digitalNow(), leftBind.digitalNow(), rightBind.digitalNow(), jumpBind.digitalNow(), sneakBind.digitalNow());
        }

        @Override
        public boolean isBoundToSameButton(@NotNull EpicFightInputActions action, @NotNull EpicFightInputActions action2) {
            Input input1 = ControlifyCompat.getControlifyBinding(action).boundInput();
            Input input2 = ControlifyCompat.getControlifyBinding(action2).boundInput();
            return input1.getRelevantInputs().equals(input2.getRelevantInputs());
        }
    }

    private static class SkillBookScreenProcessor
    extends ScreenProcessor<SkillBookScreen> {
        private static final InputBindingSupplier LEARN_SKILL = ControlifyBindings.GUI_PRESS;

        public SkillBookScreenProcessor(SkillBookScreen screen) {
            super((Screen)screen);
        }

        protected void handleButtons(ControllerEntity controller) {
            if (LEARN_SKILL.on(controller).guiPressed().get()) {
                ((SkillBookScreen)this.screen).learnButton.onPress();
            }
            super.handleButtons(controller);
        }

        protected void setInitialFocus() {
        }

        protected void handleComponentNavigation(ControllerEntity controller) {
        }

        public void onWidgetRebuild() {
            super.onWidgetRebuild();
            ButtonGuideApi.addGuideToButton((Object)((SkillBookScreen)this.screen).learnButton, (InputBindingSupplier)LEARN_SKILL, (ButtonGuidePredicate)ButtonGuidePredicate.always());
        }
    }

    private static class SkillEditScreenProcessor
    extends ScreenProcessor<SkillEditScreen> {
        public SkillEditScreenProcessor(SkillEditScreen screen) {
            super((Screen)screen);
        }

        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.ENABLED;
        }
    }

    private record ControllerBindingImpl(@NotNull InputBinding inputBinding) implements ControllerBinding
    {
        @Override
        public ResourceLocation id() {
            return this.inputBinding.id();
        }

        @Override
        @NotNull
        public ControllerBinding.InputType getInputType() {
            if (this.inputBinding.boundInput().type() == InputType.AXIS) {
                return ControllerBinding.InputType.ANALOGUE;
            }
            EpicFightMod.LOGGER.error("The method ControllerBinding#getInputType is misleading and should not be called as it will be removed in future updates.");
            return ControllerBinding.InputType.DIGITAL;
        }

        @Override
        public boolean isDigitalActiveNow() {
            return this.inputBinding.digitalNow();
        }

        @Override
        public boolean wasDigitalActivePreviously() {
            return this.inputBinding.digitalPrev();
        }

        @Override
        public boolean isDigitalJustPressed() {
            return this.inputBinding.justPressed();
        }

        @Override
        public boolean isDigitalJustReleased() {
            return this.inputBinding.justReleased();
        }

        @Override
        public float getAnalogueNow() {
            return this.inputBinding.analogueNow();
        }

        @Override
        public void emulatePress() {
            this.inputBinding.fakePress();
        }
    }
}

