/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.data.conditions.entity;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerSkillActivated
extends Condition.EntityPatchCondition {
    private Skill skill;

    public PlayerSkillActivated read(CompoundTag tag) {
        String skillName = this.assertTag("skill", "string", tag, StringTag.class, CompoundTag::getString);
        this.skill = SkillReloadListener.getSkill(skillName);
        if (this.skill == null) {
            throw new NoSuchElementException(MessageFormat.format((String)"{} condition error: Skill named {} does not exist", (Object[])new Object[]{this.getClass().getSimpleName(), skillName}));
        }
        return this;
    }

    @Override
    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putString("skill", this.skill.getRegistryName().toString());
        return tag;
    }

    @Override
    public boolean predicate(LivingEntityPatch<?> target) {
        if (target instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)target;
            Optional<SkillContainer> skill = playerpatch.getSkillContainerFor(this.skill);
            if (skill.isEmpty()) {
                return false;
            }
            return skill.get().isActivated();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        PopupBox.RegistryPopupBox<Skill> popupBox = new PopupBox.RegistryPopupBox<Skill>(screen, screen.getMinecraft().font, 0, 0, 0, 0, null, null, (Component)Component.literal((String)"skill"), EpicFightRegistries.SKILL, null);
        return List.of(Condition.ParameterEditor.of(skill -> StringTag.valueOf((String)skill.toString()), tag -> EpicFightRegistries.SKILL.get(ResourceLocation.parse((String)ParseUtil.nullOrToString(tag, Tag::getAsString))), popupBox));
    }
}

