/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.mixin.common;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.neoevent.EntityRemoveEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAbsorption;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity {
    @Shadow
    protected void hurtArmor(DamageSource p_21122_, float p_21123_) {
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"})
    private void epicfight$constructor(EntityType<?> entityType, Level level, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)self, HurtableEntityPatch.class).ifPresent(entitypatch -> {
            AttributeSupplier.Builder builder = AttributeSupplier.builder();
            self.getAttributes().supplier.instances.forEach((k, v) -> builder.add(k, v.getBaseValue()));
            if (!builder.hasAttribute(Attributes.ATTACK_DAMAGE)) {
                builder.add(Attributes.ATTACK_DAMAGE);
            }
            builder.add(EpicFightAttributes.WEIGHT);
            builder.add(EpicFightAttributes.IMPACT);
            builder.add(EpicFightAttributes.ARMOR_NEGATION);
            builder.add(EpicFightAttributes.MAX_STRIKES);
            builder.add(EpicFightAttributes.STUN_ARMOR);
            builder.add(EpicFightAttributes.ASSASSINATION_RESISTANCE);
            builder.add(EpicFightAttributes.OFFHAND_ARMOR_NEGATION);
            builder.add(EpicFightAttributes.OFFHAND_IMPACT);
            builder.add(EpicFightAttributes.OFFHAND_MAX_STRIKES);
            builder.add(EpicFightAttributes.OFFHAND_ATTACK_SPEED);
            self.getAttributes().supplier = builder.build();
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"blockUsingShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, cancellable=true)
    private void epicfight$blockUsingShield(LivingEntity p_21200_, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch opponentEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)p_21200_, LivingEntityPatch.class);
        LivingEntityPatch selfEntitypatch = EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
        if (opponentEntitypatch != null) {
            opponentEntitypatch.setLastAttackResult(AttackResult.blocked(0.0f));
            if (selfEntitypatch != null && opponentEntitypatch.getEpicFightDamageSource() != null) {
                opponentEntitypatch.onAttackBlocked(opponentEntitypatch.getEpicFightDamageSource(), selfEntitypatch);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"}, cancellable=true)
    private void epicfight$hurt(DamageSource damagesource, float amount, CallbackInfoReturnable<Boolean> info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(damagesource.getEntity(), LivingEntityPatch.class);
        if (entitypatch != null && ((Boolean)info.getReturnValue()).booleanValue()) {
            entitypatch.setLastAttackEntity((Entity)self);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"push(Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void epicfight$push(Entity p_20293_, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)self, LivingEntityPatch.class);
        if (entitypatch != null && !entitypatch.canPush(p_20293_)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, cancellable=true)
    private void epicfight$getDamageAfterArmorAbsorb(DamageSource source, float amount, CallbackInfoReturnable<Float> info) {
        if (source instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)source;
            if (!source.is(DamageTypeTags.BYPASSES_ARMOR)) {
                this.hurtArmor(source, amount);
                float armorNegationAmount = amount * Math.min(epicFightDamageSource.calculateArmorNegation() * 0.01f, 1.0f);
                float amountElse = amount - armorNegationAmount;
                LivingEntity self = (LivingEntity)this;
                amountElse = CombatRules.getDamageAfterAbsorb((LivingEntity)self, (float)amountElse, (DamageSource)source, (float)self.getArmorValue(), (float)((float)self.getAttributeValue(Attributes.ARMOR_TOUGHNESS)));
                info.setReturnValue((Object)Float.valueOf(armorNegationAmount + amountElse));
                info.cancel();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setAbsorptionAmount(F)V"}, cancellable=true)
    private void epicfight$setAbsorptionAmount(float absorptionAmount, CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        if (!self.level().isClientSide()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAbsorption(self.getId(), absorptionAmount), (Entity)self, new CustomPacketPayload[0]);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"makePoofParticles()V"}, cancellable=true)
    private void epicfight$makePoofParticles(CallbackInfo info) {
        LivingEntity self = (LivingEntity)this;
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)self, LivingEntityPatch.class).ifPresent(entitypatch -> entitypatch.onRemoved(new EntityRemoveEvent(Entity.RemovalReason.KILLED, (Entity)self)));
    }
}

