/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import yesman.epicfight.api.neoevent.BuilderModificationEvent;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;

public class SkillBuilder<B extends SkillBuilder<?>> {
    protected final Function<B, ? extends Skill> constructor;
    protected ResourceLocation registryName;
    protected CreativeModeTab tab;
    protected SkillCategory category;
    protected Skill.ActivateType activateType = Skill.ActivateType.ONE_SHOT;
    protected Skill.Resource resource = Skill.Resource.NONE;
    protected Map<String, Map<Class<?>, Skill.SkillEventSubscriber>> clientEventListeners = new HashMap();
    protected Map<String, Map<Class<?>, Skill.SkillEventSubscriber>> serverEventListeners = new HashMap();

    public SkillBuilder(Function<B, ? extends Skill> constructor) {
        this.constructor = constructor;
    }

    public B setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
        return (B)this;
    }

    public B setCreativeTab(CreativeModeTab tab) {
        this.tab = tab;
        return (B)this;
    }

    public B setCategory(SkillCategory category) {
        this.category = category;
        return (B)this;
    }

    public B setActivateType(Skill.ActivateType activateType) {
        this.activateType = activateType;
        return (B)this;
    }

    public B setResource(Skill.Resource resource) {
        this.resource = resource;
        return (B)this;
    }

    public <T extends Event> B addClientEventListener(String modid, Class<T> eventClass, int priority, BiConsumer<T, SkillContainer> eventSubscriber) {
        Map events = this.clientEventListeners.computeIfAbsent(modid, k -> new HashMap());
        if (events.containsKey(eventClass)) {
            EpicFightMod.LOGGER.warn("Overwrote the existing client side skill event " + eventClass.getSimpleName() + " in " + String.valueOf(this.registryName));
        }
        events.put(eventClass, new Skill.SkillEventSubscriber(priority, eventSubscriber, null));
        return (B)this;
    }

    public <T extends Event> B addServerEventListener(String modid, Class<T> eventClass, int priority, BiConsumer<T, SkillContainer> eventSubscriber) {
        Map events = this.serverEventListeners.computeIfAbsent(modid, k -> new HashMap());
        if (events.containsKey(eventClass)) {
            EpicFightMod.LOGGER.warn("Overwrote the existing server side skill event " + eventClass.getSimpleName() + " in " + String.valueOf(this.registryName));
        }
        events.put(eventClass, new Skill.SkillEventSubscriber(priority, eventSubscriber, null));
        return (B)this;
    }

    public <T extends Event> B addCommonEventListener(String modid, Class<T> eventClass, int priority, BiConsumer<T, SkillContainer> eventSubscriber) {
        this.addClientEventListener(modid, eventClass, priority, eventSubscriber);
        this.addServerEventListener(modid, eventClass, priority, eventSubscriber);
        return (B)this;
    }

    @ApiStatus.Internal
    public <T extends Event> B addClientEventListener(List<Pair<String, Skill.SkillEventSubscriber>> listeners) {
        return (B)this;
    }

    @ApiStatus.Internal
    public <T extends Event> B addServerEventListener(List<Pair<String, Skill.SkillEventSubscriber>> listeners) {
        return (B)this;
    }

    public <T extends Skill> T build(ResourceLocation key, Class<T> skillCls) {
        this.setRegistryName(key);
        BuilderModificationEvent builderModificationEvent = new BuilderModificationEvent(key, this);
        if (EpicFightSharedConstants.isPhysicalClient()) {
            SkillBuilder.findEventSubscriberMethods(skillCls, this.clientEventListeners, true);
        }
        SkillBuilder.findEventSubscriberMethods(skillCls, this.serverEventListeners, false);
        ModLoader.postEvent((Event)builderModificationEvent);
        return (T)this.constructor.apply(this);
    }

    private static void findEventSubscriberMethods(Class<?> skillClass, Map<String, Map<Class<?>, Skill.SkillEventSubscriber>> map, boolean logicalClient) {
        try {
            for (Method m : skillClass.getMethods()) {
                Class<?> eventClass;
                SkillEvent eventAnnotation = m.getAnnotation(SkillEvent.class);
                if (eventAnnotation == null || eventAnnotation.side() == SkillEvent.Side.CLIENT && (!logicalClient || !EpicFightSharedConstants.isPhysicalClient()) || eventAnnotation.side() == SkillEvent.Side.SERVER && logicalClient) continue;
                if (m.getParameterTypes().length != 2) {
                    throw new IllegalArgumentException("Failed at loading skill events at " + skillClass.getSimpleName() + ": Skill subscriber method must have 2 paramters. (event, skillcontainer)");
                }
                if (!Event.class.isAssignableFrom(m.getParameterTypes()[0])) {
                    throw new IllegalArgumentException("Failed at loading skill events at " + skillClass.getSimpleName() + ": " + String.valueOf(m.getParameterTypes()[0]) + " is not a subtype of net.neoforged.bus.api.Event");
                }
                if (!m.getDeclaringClass().equals(skillClass) && !eventAnnotation.extendable()) continue;
                Map byEventClass = map.computeIfAbsent(eventAnnotation.caller(), k -> new HashMap());
                if (byEventClass.containsKey(eventClass = m.getParameterTypes()[0])) {
                    if (eventAnnotation.override() && !((Skill.SkillEventSubscriber)byEventClass.get(eventClass)).reflectionMethod().getDeclaringClass().equals(skillClass) || ((Skill.SkillEventSubscriber)byEventClass.get(eventClass)).reflectionMethod().getAnnotation(SkillEvent.class).override() && !m.getDeclaringClass().equals(skillClass)) continue;
                    throw new IllegalStateException("Failed at loading skill events at " + skillClass.getSimpleName() + ": Duplicated event " + m.getName() + "(" + String.valueOf(m.getParameterTypes()[0]) + ")");
                }
                byEventClass.put(m.getParameterTypes()[0], new Skill.SkillEventSubscriber(eventAnnotation.priority(), (event, skillContainer) -> {
                    try {
                        m.invoke((Object)skillContainer.getSkill(), event, skillContainer);
                    }
                    catch (Exception e) {
                        EpicFightMod.logAndStacktraceIfDevSide(Logger::error, "Failed to execute skill event: " + String.valueOf(skillContainer.getSkill()) + " " + event.getClass().getSimpleName(), RuntimeException::new);
                    }
                }, m));
            }
        }
        catch (Exception e) {
            EpicFightMod.LOGGER.error("Error while reading skill event subscribers of " + skillClass.getSimpleName());
            throw e;
        }
    }
}

