/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.identity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.screen.SkillBookScreen;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class MeteorSlamSkill
extends Skill {
    protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> slamMotions;
    private final double minDistance = 6.0;

    public static float getFallDistance(SkillContainer skillContainer) {
        return skillContainer.getDataManager().getDataValue(EpicFightSkillDataKeys.FALL_DISTANCE).floatValue();
    }

    public static Builder createMeteorSlamBuilder() {
        return (Builder)((Builder)new Builder(MeteorSlamSkill::new).addSlamMotion(CapabilityItem.WeaponCategories.SPEAR, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.GREATSWORD, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.TACHI, (item, player) -> Animations.METEOR_SLAM).addSlamMotion(CapabilityItem.WeaponCategories.LONGSWORD, (item, player) -> Animations.METEOR_SLAM).setCategory(SkillCategories.IDENTITY)).setResource(Skill.Resource.NONE);
    }

    public MeteorSlamSkill(Builder builder) {
        super(builder);
        this.slamMotions = builder.slamMotions;
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void skillCastEvent(SkillCastEvent event, SkillContainer container) {
        if (!container.getExecutor().isLogicalClient()) {
            Vec3 from;
            Vec3 to;
            double distance;
            Skill skill = event.getSkillContainer().getSkill();
            if (skill.getCategory() != SkillCategories.BASIC_ATTACK && skill.getCategory() != SkillCategories.AIR_ATTACK) {
                return;
            }
            if (((Player)container.getExecutor().getOriginal()).onGround() || ((Player)container.getExecutor().getOriginal()).getXRot() < 40.0f) {
                return;
            }
            CapabilityItem holdingItem = container.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (!this.slamMotions.containsKey(holdingItem.getWeaponCategory())) {
                return;
            }
            AnimationManager.AnimationAccessor<? extends StaticAnimation> slamAnimation = this.slamMotions.get(holdingItem.getWeaponCategory()).apply(holdingItem, container.getExecutor());
            if (slamAnimation == null) {
                return;
            }
            Vec3 vec3 = ((Player)container.getExecutor().getOriginal()).getEyePosition(1.0f);
            Vec3 vec31 = ((Player)container.getExecutor().getOriginal()).getViewVector(1.0f);
            Vec3 vec32 = vec3.add(vec31.x * 50.0, vec31.y * 50.0, vec31.z * 50.0);
            BlockHitResult hitResult = ((Player)container.getExecutor().getOriginal()).level().clip(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, container.getExecutor().getOriginal()));
            if (hitResult.getType() != HitResult.Type.MISS && (distance = (to = hitResult.getLocation()).distanceTo(from = ((Player)container.getExecutor().getOriginal()).position())) > this.minDistance) {
                container.getExecutor().playAnimationSynchronized(slamAnimation, 0.0f);
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.FALL_DISTANCE, Float.valueOf((float)distance));
                container.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, true);
                event.setCanceled(true);
            }
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void takeDamagePost(TakeDamageEvent.Pre event, SkillContainer container) {
        if (event.getDamageSource().is(DamageTypeTags.IS_FALL) && container.getDataManager().getDataValue(EpicFightSkillDataKeys.PROTECT_NEXT_FALL).booleanValue()) {
            float stamina = container.getExecutor().getStamina();
            float damage = event.getDamage();
            event.attachValueModifier(ValueModifier.adder(-stamina));
            container.getExecutor().setStamina(stamina - damage);
            container.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, false);
        }
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER)
    public void fallEvent(LivingFallEvent event, SkillContainer skillContainer) {
        if (LevelUtil.calculateLivingEntityFallDamage(event.getEntity(), event.getDamageMultiplier(), event.getDistance()) == 0) {
            skillContainer.getDataManager().setData(EpicFightSkillDataKeys.PROTECT_NEXT_FALL, false);
        }
    }

    @Override
    public Set<WeaponCategory> getAvailableWeaponCategories() {
        return this.slamMotions.keySet();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean getCustomConsumptionTooltips(SkillBookScreen.AttributeIconList consumptionList) {
        consumptionList.add((Component)Component.translatable((String)"attribute.name.epicfight.stamina.consume.tooltip"), (Component)Component.translatable((String)"skill.epicfight.meteor_slam.consume.tooltip"), SkillBookScreen.STAMINA_TEXTURE_INFO);
        return true;
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected final Map<WeaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> slamMotions = Maps.newHashMap();

        public Builder(Function<Builder, MeteorSlamSkill> constructor) {
            super(constructor);
        }

        public Builder addSlamMotion(WeaponCategory weaponCategory, BiFunction<CapabilityItem, PlayerPatch<?>, AnimationManager.AnimationAccessor<? extends StaticAnimation>> function) {
            this.slamMotions.put(weaponCategory, function);
            return this;
        }
    }
}

