/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import yesman.epicfight.api.neoevent.playerpatch.ModifyAttackSpeedEvent;
import yesman.epicfight.api.neoevent.playerpatch.ModifyBaseDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityDecorations;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class BerserkerSkill
extends PassiveSkill {
    private float speedBonus;
    private float damageBonus;

    public BerserkerSkill(SkillBuilder<?> builder) {
        super((SkillBuilder<? extends SkillBuilder>)builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.speedBonus = parameters.getFloat("speed_bonus");
        this.damageBonus = parameters.getFloat("damage_bonus");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInitiateClient(final SkillContainer container) {
        final Player player = (Player)container.getExecutor().getOriginal();
        container.getExecutor().getEntityDecorations().addDecorationOverlay(EntityDecorations.BERSERKER_OVERLAY, new EntityDecorations.DecorationOverlay(){

            @Override
            public Vector4f color(float partialTick) {
                float alpha = Mth.clampedLerp((float)0.0f, (float)0.42f, (float)(1.0f - player.getHealth() / player.getMaxHealth()));
                return new Vector4f(0.66f, 0.06f, 0.07f, alpha);
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(BerserkerSkill.this) == null;
            }
        });
        container.getExecutor().getEntityDecorations().addParticleGenerator(EntityDecorations.BERSERKER_PARTICLE, new EntityDecorations.ParticleGenerator(){

            @Override
            public void generateParticles() {
                float healthRatio = player.getHealth() / player.getMaxHealth();
                RandomSource random = player.getRandom();
                float chance = Mth.clampedLerp((float)0.0f, (float)0.04f, (float)(1.0f - healthRatio - 0.2f));
                for (int i = 0; i < 4; ++i) {
                    if (!(random.nextFloat() < chance)) continue;
                    player.level().addParticle((ParticleOptions)ParticleTypes.POOF, player.getX() + random.nextGaussian() * (double)0.4f, player.getY() + (double)player.getBbHeight() * 0.5 + random.nextGaussian() * (double)0.6f, player.getZ() + random.nextGaussian() * (double)0.4f, 0.0, (double)0.2f, 0.0);
                }
            }

            @Override
            public boolean shouldRemove() {
                return container.getExecutor().getSkill(BerserkerSkill.this) == null;
            }
        });
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.BOTH)
    public void modifyAttackSpeedEvent(ModifyAttackSpeedEvent event, SkillContainer skillContainer) {
        Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
        float health = player.getHealth();
        float maxHealth = player.getMaxHealth();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.01f * this.speedBonus;
        float attackSpeed = event.getAttackSpeed();
        event.setAttackSpeed(Math.min(5.0f, attackSpeed * (1.0f + lostHealthPercentage)));
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.BOTH)
    public void modifyBaseDamageEvent(ModifyBaseDamageEvent event, SkillContainer skillContainer) {
        Player player = (Player)((EntityPatch)event.getPlayerPatch()).getOriginal();
        float health = player.getHealth();
        float maxHealth = player.getMaxHealth();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f) * 0.01f * this.damageBonus;
        event.attachValueModifier(ValueModifier.multiplier(1.0f + lostHealthPercentage));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        Player player = (Player)container.getExecutor().getOriginal();
        float health = player.getHealth();
        float maxHealth = player.getMaxHealth();
        return maxHealth - health > 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        guiGraphics.blit(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        Player player = (Player)container.getExecutor().getOriginal();
        float health = player.getHealth();
        float maxHealth = player.getMaxHealth();
        float lostHealthPercentage = (maxHealth - health) / maxHealth;
        lostHealthPercentage = (float)Math.floor(lostHealthPercentage * 100.0f);
        guiGraphics.drawString(gui.getFont(), String.format("%.0f%%", Float.valueOf(lostHealthPercentage)), x + 4.0f, y + 6.0f, 0xFFFFFF, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.speedBonus)));
        list.add(String.format("%.1f", Float.valueOf(this.damageBonus)));
        return list;
    }
}

